/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.ElementHandler;
import org.dom4j.io.DispatchHandler;
import org.dom4j.io.SAXContentHandler;
import org.dom4j.io.SAXHelper;
import org.dom4j.io.SAXReader$SAXEntityResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXReader {
    private DocumentFactory factory;
    private XMLReader xmlReader;
    private boolean validating;
    private DispatchHandler dispatchHandler;
    private ErrorHandler errorHandler;
    private EntityResolver entityResolver;
    private boolean stringInternEnabled = true;
    private boolean includeInternalDTDDeclarations = false;
    private boolean includeExternalDTDDeclarations = false;
    private boolean mergeAdjacentText = false;
    private boolean stripWhitespaceText = false;
    private boolean ignoreComments = false;
    private XMLFilter xmlFilter;

    public SAXReader() {
    }

    public SAXReader(String string) {
        if (string != null) {
            this.xmlReader = XMLReaderFactory.createXMLReader(string);
        }
    }

    public SAXReader(String string, boolean bl) {
        if (string != null) {
            this.xmlReader = XMLReaderFactory.createXMLReader(string);
        }
        this.validating = bl;
    }

    public SAXReader(DocumentFactory documentFactory) {
        this.factory = documentFactory;
    }

    public SAXReader(DocumentFactory documentFactory, boolean bl) {
        this.factory = documentFactory;
        this.validating = bl;
    }

    public SAXReader(XMLReader xMLReader) {
        this.xmlReader = xMLReader;
    }

    public SAXReader(XMLReader xMLReader, boolean bl) {
        this.xmlReader = xMLReader;
        this.validating = bl;
    }

    public SAXReader(boolean bl) {
        this.validating = bl;
    }

    public final void addHandler(String string, ElementHandler elementHandler) {
        this.getDispatchHandler().addHandler(string, elementHandler);
    }

    protected final void configureReader(XMLReader xMLReader, DefaultHandler defaultHandler) {
        block5: {
            SAXHelper.setParserProperty(xMLReader, "http://xml.org/sax/handlers/LexicalHandler", defaultHandler);
            SAXHelper.setParserProperty(xMLReader, "http://xml.org/sax/properties/lexical-handler", defaultHandler);
            if (this.includeInternalDTDDeclarations) {
                SAXHelper.setParserProperty(xMLReader, "http://xml.org/sax/properties/declaration-handler", defaultHandler);
            }
            SAXHelper.setParserFeature(xMLReader, "http://xml.org/sax/features/namespaces", true);
            SAXHelper.setParserFeature(xMLReader, "http://xml.org/sax/features/namespace-prefixes", false);
            SAXHelper.setParserFeature(xMLReader, "http://xml.org/sax/features/string-interning", this.isStringInternEnabled());
            try {
                xMLReader.setFeature("http://xml.org/sax/features/validation", this.isValidating());
                if (this.errorHandler != null) {
                    xMLReader.setErrorHandler(this.errorHandler);
                } else {
                    xMLReader.setErrorHandler(defaultHandler);
                }
            }
            catch (Exception exception) {
                if (!this.isValidating()) break block5;
                throw new DocumentException("Validation not supported for XMLReader: " + xMLReader, exception);
            }
        }
    }

    protected final SAXContentHandler createContentHandler(XMLReader xMLReader) {
        return new SAXContentHandler(this.getDocumentFactory(), this.dispatchHandler);
    }

    protected final EntityResolver createDefaultEntityResolver(String string) {
        int n;
        String string2 = null;
        if (string != null && string.length() > 0 && (n = string.lastIndexOf(47)) > 0) {
            string2 = string.substring(0, n + 1);
        }
        return new SAXReader$SAXEntityResolver(string2);
    }

    protected final XMLReader createXMLReader() {
        return SAXHelper.createXMLReader(this.isValidating());
    }

    protected final DispatchHandler getDispatchHandler() {
        if (this.dispatchHandler == null) {
            this.dispatchHandler = new DispatchHandler();
        }
        return this.dispatchHandler;
    }

    public final DocumentFactory getDocumentFactory() {
        if (this.factory == null) {
            this.factory = DocumentFactory.getInstance();
        }
        return this.factory;
    }

    public final EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public final ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final XMLFilter getXMLFilter() {
        return this.xmlFilter;
    }

    public final XMLReader getXMLReader() {
        if (this.xmlReader == null) {
            this.xmlReader = this.createXMLReader();
        }
        return this.xmlReader;
    }

    protected final XMLReader installXMLFilter(XMLReader xMLReader) {
        XMLFilter xMLFilter = this.getXMLFilter();
        if (xMLFilter != null) {
            XMLReader xMLReader2;
            XMLFilter xMLFilter2 = xMLFilter;
            while ((xMLReader2 = xMLFilter2.getParent()) instanceof XMLFilter) {
                xMLFilter2 = (XMLFilter)xMLReader2;
            }
            xMLFilter2.setParent(xMLReader);
            return xMLFilter;
        }
        return xMLReader;
    }

    public final boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public final boolean isIncludeExternalDTDDeclarations() {
        return this.includeExternalDTDDeclarations;
    }

    public final boolean isIncludeInternalDTDDeclarations() {
        return this.includeInternalDTDDeclarations;
    }

    public final boolean isMergeAdjacentText() {
        return this.mergeAdjacentText;
    }

    public final boolean isStringInternEnabled() {
        return this.stringInternEnabled;
    }

    public final boolean isStripWhitespaceText() {
        return this.stripWhitespaceText;
    }

    public final boolean isValidating() {
        return this.validating;
    }

    public final Document read(File file) {
        try {
            return this.read(new InputSource(new FileReader(file)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MalformedURLException(fileNotFoundException.getMessage());
        }
    }

    public final Document read(InputStream inputStream) {
        return this.read(new InputSource(inputStream));
    }

    public final Document read(InputStream inputStream, String string) {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.read(inputSource);
    }

    public final Document read(Reader reader) {
        return this.read(new InputSource(reader));
    }

    public final Document read(Reader reader, String string) {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        return this.read(inputSource);
    }

    public final Document read(String string) {
        return this.read(new InputSource(string));
    }

    public final Document read(URL uRL) {
        String string = uRL.toExternalForm();
        return this.read(new InputSource(string));
    }

    public final Document read(InputSource inputSource) {
        try {
            XMLReader xMLReader = this.getXMLReader();
            xMLReader = this.installXMLFilter(xMLReader);
            EntityResolver entityResolver = xMLReader.getEntityResolver();
            if (entityResolver == null) {
                entityResolver = this.entityResolver;
                if (entityResolver == null) {
                    entityResolver = this.createDefaultEntityResolver(inputSource.getSystemId());
                }
                xMLReader.setEntityResolver(entityResolver);
            } else if (this.entityResolver != null) {
                xMLReader.setEntityResolver(this.entityResolver);
            }
            SAXContentHandler sAXContentHandler = this.createContentHandler(xMLReader);
            sAXContentHandler.setEntityResolver(entityResolver);
            sAXContentHandler.setInputSource(inputSource);
            sAXContentHandler.setIncludeInternalDTDDeclarations(this.isIncludeInternalDTDDeclarations());
            sAXContentHandler.setIncludeExternalDTDDeclarations(this.isIncludeExternalDTDDeclarations());
            sAXContentHandler.setMergeAdjacentText(this.isMergeAdjacentText());
            sAXContentHandler.setStripWhitespaceText(this.isStripWhitespaceText());
            sAXContentHandler.setIgnoreComments(this.isIgnoreComments());
            xMLReader.setContentHandler(sAXContentHandler);
            this.configureReader(xMLReader, sAXContentHandler);
            xMLReader.parse(inputSource);
            return sAXContentHandler.getDocument();
        }
        catch (Exception exception) {
            if (exception instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)exception;
                String string = sAXParseException.getSystemId();
                if (string == null) {
                    string = "";
                }
                String string2 = "Error on line " + sAXParseException.getLineNumber() + " of document " + string + " : " + sAXParseException.getMessage();
                throw new DocumentException(string2, exception);
            }
            throw new DocumentException(exception.getMessage(), exception);
        }
    }

    public final void removeHandler(String string) {
        this.getDispatchHandler().removeHandler(string);
    }

    public final void setDefaultHandler(ElementHandler elementHandler) {
        this.getDispatchHandler().setDefaultHandler(elementHandler);
    }

    protected final void setDispatchHandler(DispatchHandler dispatchHandler) {
        this.dispatchHandler = dispatchHandler;
    }

    public final void setDocumentFactory(DocumentFactory documentFactory) {
        this.factory = documentFactory;
    }

    public final void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public final void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public final void setFeature(String string, boolean bl) {
        this.getXMLReader().setFeature(string, bl);
    }

    public final void setIgnoreComments(boolean bl) {
        this.ignoreComments = bl;
    }

    public final void setIncludeExternalDTDDeclarations(boolean bl) {
        this.includeExternalDTDDeclarations = bl;
    }

    public final void setIncludeInternalDTDDeclarations(boolean bl) {
        this.includeInternalDTDDeclarations = bl;
    }

    public final void setMergeAdjacentText(boolean bl) {
        this.mergeAdjacentText = bl;
    }

    public final void setProperty(String string, Object object) {
        this.getXMLReader().setProperty(string, object);
    }

    public final void setStringInternEnabled(boolean bl) {
        this.stringInternEnabled = bl;
    }

    public final void setStripWhitespaceText(boolean bl) {
        this.stripWhitespaceText = bl;
    }

    public final void setValidation(boolean bl) {
        this.validating = bl;
    }

    public final void setXMLFilter(XMLFilter xMLFilter) {
        this.xmlFilter = xMLFilter;
    }

    public final void setXMLReader(XMLReader xMLReader) {
        this.xmlReader = xMLReader;
    }

    public final void setXMLReaderClassName(String string) {
        this.setXMLReader(XMLReaderFactory.createXMLReader(string));
    }
}

