/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.io.OutputFormat;
import org.dom4j.tree.NamespaceStack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class XMLWriter
extends XMLFilterImpl
implements LexicalHandler {
    protected static final String[] LEXICAL_HANDLER_NAMES = new String[]{"http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/handlers/LexicalHandler"};
    private static final boolean SUPPORT_PAD_TEXT = false;
    protected static final OutputFormat DEFAULT_FORMAT = new OutputFormat();
    private boolean resolveEntityRefs = true;
    protected int lastOutputNodeType;
    protected Writer writer;
    private NamespaceStack namespaceStack = new NamespaceStack();
    private OutputFormat format;
    private boolean escapeText = true;
    private int indentLevel = 0;
    private StringBuffer buffer = new StringBuffer();
    private boolean autoFlush;
    private LexicalHandler lexicalHandler;
    private boolean showCommentsInDTDs;
    private boolean inDTD;
    private Map namespacesMap;
    private int maximumAllowedCharacter;

    public XMLWriter() {
        this.format = DEFAULT_FORMAT;
        this.writer = new BufferedWriter(new OutputStreamWriter(System.out));
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter(OutputStream outputStream) {
        this.format = DEFAULT_FORMAT;
        this.writer = this.createWriter(outputStream, this.format.getEncoding());
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter(OutputStream outputStream, OutputFormat outputFormat) {
        this.format = outputFormat;
        this.writer = this.createWriter(outputStream, outputFormat.getEncoding());
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter(Writer writer) {
        this(writer, DEFAULT_FORMAT);
    }

    public XMLWriter(Writer writer, OutputFormat outputFormat) {
        this.writer = writer;
        this.format = outputFormat;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public XMLWriter(OutputFormat outputFormat) {
        this.format = outputFormat;
        this.writer = this.createWriter(System.out, outputFormat.getEncoding());
        this.autoFlush = true;
        this.namespaceStack.push(Namespace.NO_NAMESPACE);
    }

    public final void characters(char[] cArray, int n, int n2) {
        try {
            this.write(new String(cArray, n, n2));
            super.characters(cArray, n, n2);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public final void close() {
        this.writer.close();
    }

    public final void comment(char[] cArray, int n, int n2) {
        if (this.showCommentsInDTDs || !this.inDTD) {
            try {
                this.writeComment(new String(cArray, n, n2));
            }
            catch (IOException iOException) {
                this.handleException(iOException);
            }
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(cArray, n, n2);
        }
    }

    protected final Writer createWriter(OutputStream outputStream, String string) {
        return new BufferedWriter(new OutputStreamWriter(outputStream, string));
    }

    protected final int defaultMaximumAllowedCharacter() {
        String string = this.format.getEncoding();
        if (string != null && string.equals("US-ASCII")) {
            return 127;
        }
        return -1;
    }

    public final void endCDATA() {
        try {
            this.writer.write("]]>");
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public final void endDTD() {
        this.inDTD = false;
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    public final void endDocument() {
        block2: {
            super.endDocument();
            if (!this.autoFlush) break block2;
            try {
                this.flush();
            }
            catch (IOException iOException) {}
        }
    }

    public final void endElement(String string, String string2, String string3) {
        try {
            boolean bl;
            --this.indentLevel;
            if (this.lastOutputNodeType == 1) {
                this.writePrintln();
                this.indent();
            }
            if (bl = true) {
                this.writeClose(string3);
            } else {
                this.writeEmptyElementClose(string3);
            }
            this.lastOutputNodeType = 1;
            super.endElement(string, string2, string3);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public final void endEntity(String string) {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(string);
        }
    }

    public final void endPrefixMapping(String string) {
        super.endPrefixMapping(string);
    }

    protected final String escapeAttributeEntities(String string) {
        String string2;
        char[] cArray = null;
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            string2 = null;
            char c2 = string.charAt(n3);
            switch (c2) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '\'': {
                    string2 = "&apos;";
                    break;
                }
                case '\"': {
                    string2 = "&quot;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                default: {
                    if (c2 >= ' ' && !this.shouldEncodeChar(c2)) break;
                    string2 = "&#" + c2 + ";";
                }
                case '\t': 
                case '\n': 
                case '\r': 
            }
            if (string2 != null) {
                if (cArray == null) {
                    cArray = string.toCharArray();
                }
                this.buffer.append(cArray, n, n3 - n);
                this.buffer.append(string2);
                n = n3 + 1;
            }
            ++n3;
        }
        if (n == 0) {
            return string;
        }
        if (n < n2) {
            if (cArray == null) {
                cArray = string.toCharArray();
            }
            this.buffer.append(cArray, n, n3 - n);
        }
        string2 = this.buffer.toString();
        this.buffer.setLength(0);
        return string2;
    }

    protected final String escapeElementEntities(String string) {
        String string2;
        char[] cArray = null;
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            string2 = null;
            char c2 = string.charAt(n3);
            switch (c2) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                default: {
                    if (c2 >= ' ' && !this.shouldEncodeChar(c2)) break;
                    string2 = "&#" + c2 + ";";
                }
                case '\t': 
                case '\n': 
                case '\r': 
            }
            if (string2 != null) {
                if (cArray == null) {
                    cArray = string.toCharArray();
                }
                this.buffer.append(cArray, n, n3 - n);
                this.buffer.append(string2);
                n = n3 + 1;
            }
            ++n3;
        }
        if (n == 0) {
            return string;
        }
        if (n < n2) {
            if (cArray == null) {
                cArray = string.toCharArray();
            }
            this.buffer.append(cArray, n, n3 - n);
        }
        string2 = this.buffer.toString();
        this.buffer.setLength(0);
        return string2;
    }

    public final void flush() {
        this.writer.flush();
    }

    public final LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public final int getMaximumAllowedCharacter() {
        if (this.maximumAllowedCharacter == 0) {
            this.maximumAllowedCharacter = this.defaultMaximumAllowedCharacter();
        }
        return this.maximumAllowedCharacter;
    }

    protected final OutputFormat getOutputFormat() {
        return this.format;
    }

    protected final String getPadText() {
        return null;
    }

    public final Object getProperty(String string) {
        int n = 0;
        while (n < LEXICAL_HANDLER_NAMES.length) {
            if (LEXICAL_HANDLER_NAMES[n].equals(string)) {
                return this.getLexicalHandler();
            }
            ++n;
        }
        return super.getProperty(string);
    }

    protected final void handleException(IOException iOException) {
        throw new SAXException(iOException);
    }

    public final void ignorableWhitespace(char[] cArray, int n, int n2) {
        super.ignorableWhitespace(cArray, n, n2);
    }

    protected final void indent() {
        String string = this.format.getIndent();
        if (string != null && string.length() > 0) {
            int n = 0;
            while (n < this.indentLevel) {
                this.writer.write(string);
                ++n;
            }
        }
    }

    protected final void installLexicalHandler() {
        XMLReader xMLReader = this.getParent();
        if (xMLReader == null) {
            throw new NullPointerException("No parent for filter");
        }
        int n = 0;
        while (n < LEXICAL_HANDLER_NAMES.length) {
            try {
                xMLReader.setProperty(LEXICAL_HANDLER_NAMES[n], this);
                break;
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {}
            ++n;
        }
    }

    public final boolean isEscapeText() {
        return this.escapeText;
    }

    protected final boolean isExpandEmptyElements() {
        return this.format.isExpandEmptyElements();
    }

    protected final boolean isNamespaceDeclaration(Namespace namespace) {
        String string;
        return namespace != null && namespace != Namespace.XML_NAMESPACE && (string = namespace.getURI()) != null && !this.namespaceStack.contains(namespace);
    }

    public final void notationDecl(String string, String string2, String string3) {
        super.notationDecl(string, string2, string3);
    }

    public final void parse(InputSource inputSource) {
        this.installLexicalHandler();
        super.parse(inputSource);
    }

    public final void println() {
        this.writer.write(this.format.getLineSeparator());
    }

    public final void processingInstruction(String string, String string2) {
        try {
            this.indent();
            this.writer.write("<?");
            this.writer.write(string);
            this.writer.write(" ");
            this.writer.write(string2);
            this.writer.write("?>");
            this.writePrintln();
            this.lastOutputNodeType = 7;
            super.processingInstruction(string, string2);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public final boolean resolveEntityRefs() {
        return this.resolveEntityRefs;
    }

    public final void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
    }

    public final void setEscapeText(boolean bl) {
        this.escapeText = bl;
    }

    public final void setIndentLevel(int n) {
        this.indentLevel = n;
    }

    public final void setLexicalHandler(LexicalHandler lexicalHandler) {
        if (lexicalHandler == null) {
            throw new NullPointerException("Null lexical handler");
        }
        this.lexicalHandler = lexicalHandler;
    }

    public final void setMaximumAllowedCharacter(int n) {
        this.maximumAllowedCharacter = n;
    }

    public final void setOutputStream(OutputStream outputStream) {
        this.writer = this.createWriter(outputStream, this.format.getEncoding());
        this.autoFlush = true;
    }

    public final void setProperty(String string, Object object) {
        int n = 0;
        while (n < LEXICAL_HANDLER_NAMES.length) {
            if (LEXICAL_HANDLER_NAMES[n].equals(string)) {
                this.setLexicalHandler((LexicalHandler)object);
                return;
            }
            ++n;
        }
        super.setProperty(string, object);
    }

    public final void setResolveEntityRefs(boolean bl) {
        this.resolveEntityRefs = bl;
    }

    public final void setWriter(Writer writer) {
        this.writer = writer;
        this.autoFlush = false;
    }

    protected final boolean shouldEncodeChar(char c2) {
        int n = this.getMaximumAllowedCharacter();
        return n > 0 && c2 > n;
    }

    public final void startCDATA() {
        try {
            this.writer.write("<![CDATA[");
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    public final void startDTD(String string, String string2, String string3) {
        this.inDTD = true;
        try {
            this.writeDocType(string, string2, string3);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(string, string2, string3);
        }
    }

    public final void startDocument() {
        try {
            this.writeDeclaration();
            super.startDocument();
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public final void startElement(String string, String string2, String string3, Attributes attributes) {
        try {
            this.writePrintln();
            this.indent();
            this.writer.write("<");
            this.writer.write(string3);
            this.writeNamespaces();
            this.writeAttributes(attributes);
            this.writer.write(">");
            ++this.indentLevel;
            this.lastOutputNodeType = 1;
            super.startElement(string, string2, string3, attributes);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
    }

    public final void startEntity(String string) {
        try {
            this.writeEntityRef(string);
        }
        catch (IOException iOException) {
            this.handleException(iOException);
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(string);
        }
    }

    public final void startPrefixMapping(String string, String string2) {
        if (this.namespacesMap == null) {
            this.namespacesMap = new HashMap();
        }
        this.namespacesMap.put(string, string2);
        super.startPrefixMapping(string, string2);
    }

    public final void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        super.unparsedEntityDecl(string, string2, string3, string4);
    }

    public final void write(Object object) {
        if (object instanceof Node) {
            this.write((Node)object);
        } else if (object instanceof String) {
            this.write((String)object);
        } else if (object instanceof List) {
            List list = (List)object;
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                this.write(list.get(n));
                ++n;
            }
        } else if (object != null) {
            throw new IOException("Invalid object: " + object);
        }
    }

    public final void write(String string) {
        this.writeString(string);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public final void write(Attribute attribute) {
        this.writeAttribute(attribute);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public final void write(CDATA cDATA) {
        this.writeCDATA(cDATA.getText());
        if (this.autoFlush) {
            this.flush();
        }
    }

    public final void write(Comment comment) {
        this.writeComment(comment.getText());
        if (this.autoFlush) {
            this.flush();
        }
    }

    public final void write(Document document) {
        this.writeDeclaration();
        if (document.getDocType() != null) {
            this.indent();
            this.writeDocType(document.getDocType());
        }
        int n = 0;
        int n2 = document.nodeCount();
        while (n < n2) {
            Node node = document.node(n);
            this.writeNode(node);
            ++n;
        }
        this.writePrintln();
        if (this.autoFlush) {
            this.flush();
        }
    }

    public final void write(DocumentType documentType) {
        this.writeDocType(documentType);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public final void write(Element element) {
        this.writeElement(element);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public final void write(Entity entity) {
        this.writeEntity(entity);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public final void write(Namespace namespace) {
        this.writeNamespace(namespace);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public final void write(Node node) {
        this.writeNode(node);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public final void write(ProcessingInstruction processingInstruction) {
        this.writeProcessingInstruction(processingInstruction);
        if (this.autoFlush) {
            this.flush();
        }
    }

    public final void write(Text text) {
        this.writeString(text.getText());
        if (this.autoFlush) {
            this.flush();
        }
    }

    protected final void writeAttribute(Attribute attribute) {
        this.writer.write(" ");
        this.writer.write(attribute.getQualifiedName());
        this.writer.write("=");
        this.writer.write("\"");
        this.writeEscapeAttributeEntities(attribute.getValue());
        this.writer.write("\"");
        this.lastOutputNodeType = 2;
    }

    protected final void writeAttribute(Attributes attributes, int n) {
        this.writer.write(" ");
        this.writer.write(attributes.getQName(n));
        this.writer.write("=\"");
        this.writeEscapeAttributeEntities(attributes.getValue(n));
        this.writer.write("\"");
    }

    protected final void writeAttributes(Element element) {
        int n = 0;
        int n2 = element.attributeCount();
        while (n < n2) {
            Attribute attribute = element.attribute(n);
            Namespace namespace = attribute.getNamespace();
            if (namespace != null && namespace != Namespace.NO_NAMESPACE && namespace != Namespace.XML_NAMESPACE) {
                String string = namespace.getPrefix();
                String string2 = this.namespaceStack.getURI(string);
                if (!namespace.getURI().equals(string2)) {
                    this.writeNamespace(namespace);
                    this.namespaceStack.push(namespace);
                }
            }
            this.writer.write(" ");
            this.writer.write(attribute.getQualifiedName());
            this.writer.write("=\"");
            this.writeEscapeAttributeEntities(attribute.getValue());
            this.writer.write("\"");
            ++n;
        }
    }

    protected final void writeAttributes(Attributes attributes) {
        int n = 0;
        int n2 = attributes.getLength();
        while (n < n2) {
            this.writeAttribute(attributes, n);
            ++n;
        }
    }

    protected final void writeCDATA(String string) {
        this.writer.write("<![CDATA[");
        this.writer.write(string);
        this.writer.write("]]>");
        this.lastOutputNodeType = 4;
    }

    protected final void writeClose(String string) {
        this.writer.write("</");
        this.writer.write(string);
        this.writer.write(">");
    }

    public final void writeClose(Element element) {
        this.writeClose(element.getQualifiedName());
    }

    protected final void writeComment(String string) {
        if (this.format.isNewlines()) {
            this.println();
            this.indent();
        }
        this.writer.write("<!--");
        this.writer.write(string);
        this.writer.write("-->");
        this.lastOutputNodeType = 8;
    }

    protected final void writeDeclaration() {
        String string = this.format.getEncoding();
        if (!this.format.isSuppressDeclaration()) {
            if (string.equals("UTF8")) {
                this.writer.write("<?xml version=\"1.0\"");
                if (!this.format.isOmitEncoding()) {
                    this.writer.write(" encoding=\"UTF-8\"");
                }
                this.writer.write("?>");
            } else {
                this.writer.write("<?xml version=\"1.0\"");
                if (!this.format.isOmitEncoding()) {
                    this.writer.write(" encoding=\"" + string + "\"");
                }
                this.writer.write("?>");
            }
            this.println();
        }
    }

    protected final void writeDocType(String string, String string2, String string3) {
        boolean bl = false;
        this.writer.write("<!DOCTYPE ");
        this.writer.write(string);
        if (string2 != null && !string2.equals("")) {
            this.writer.write(" PUBLIC \"");
            this.writer.write(string2);
            this.writer.write("\"");
            bl = true;
        }
        if (string3 != null && !string3.equals("")) {
            if (!bl) {
                this.writer.write(" SYSTEM");
            }
            this.writer.write(" \"");
            this.writer.write(string3);
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writePrintln();
    }

    protected final void writeDocType(DocumentType documentType) {
        if (documentType != null) {
            documentType.write(this.writer);
            this.writePrintln();
        }
    }

    protected final void writeElement(Element element) {
        int n = element.nodeCount();
        String string = element.getQualifiedName();
        this.writePrintln();
        this.indent();
        this.writer.write("<");
        this.writer.write(string);
        int n2 = this.namespaceStack.size();
        Namespace namespace = element.getNamespace();
        if (this.isNamespaceDeclaration(namespace)) {
            this.namespaceStack.push(namespace);
            this.writeNamespace(namespace);
        }
        boolean bl = true;
        int n3 = 0;
        while (n3 < n) {
            Node node = element.node(n3);
            if (node instanceof Namespace) {
                Namespace namespace2 = (Namespace)node;
                if (this.isNamespaceDeclaration(namespace2)) {
                    this.namespaceStack.push(namespace2);
                    this.writeNamespace(namespace2);
                }
            } else if (node instanceof Element) {
                bl = false;
            } else if (node instanceof Comment) {
                bl = false;
            }
            ++n3;
        }
        this.writeAttributes(element);
        this.lastOutputNodeType = 1;
        if (n <= 0) {
            this.writeEmptyElementClose(string);
        } else {
            this.writer.write(">");
            if (bl) {
                this.writeElementContent(element);
            } else {
                ++this.indentLevel;
                this.writeElementContent(element);
                --this.indentLevel;
                this.writePrintln();
                this.indent();
            }
            this.writer.write("</");
            this.writer.write(string);
            this.writer.write(">");
        }
        while (this.namespaceStack.size() > n2) {
            this.namespaceStack.pop();
        }
        this.lastOutputNodeType = 1;
    }

    protected final void writeElementContent(Element element) {
        if (this.format.isTrimText()) {
            Node node = null;
            StringBuffer stringBuffer = null;
            int n = 0;
            int n2 = element.nodeCount();
            while (n < n2) {
                Node node2 = element.node(n);
                if (node2 instanceof Text) {
                    if (node == null) {
                        node = (Text)node2;
                    } else {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer(node.getText());
                        }
                        stringBuffer.append(((Text)node2).getText());
                    }
                } else {
                    if (node != null) {
                        if (stringBuffer != null) {
                            this.writeString(stringBuffer.toString());
                            stringBuffer = null;
                        } else {
                            this.writeString(node.getText());
                        }
                        node = null;
                    }
                    this.writeNode(node2);
                }
                ++n;
            }
            if (node != null) {
                if (stringBuffer != null) {
                    this.writeString(stringBuffer.toString());
                    stringBuffer = null;
                } else {
                    this.writeString(node.getText());
                }
                node = null;
            }
        } else {
            int n = 0;
            int n3 = element.nodeCount();
            while (n < n3) {
                Node node = element.node(n);
                this.writeNode(node);
                ++n;
            }
        }
    }

    protected final void writeEmptyElementClose(String string) {
        if (!this.format.isExpandEmptyElements()) {
            this.writer.write("/>");
        } else {
            this.writer.write("></");
            this.writer.write(string);
            this.writer.write(">");
        }
    }

    protected final void writeEntity(Entity entity) {
        if (!this.resolveEntityRefs()) {
            this.writeEntityRef(entity.getName());
        } else {
            this.writer.write(entity.getText());
        }
    }

    protected final void writeEntityRef(String string) {
        this.writer.write("&");
        this.writer.write(string);
        this.writer.write(";");
        this.lastOutputNodeType = 5;
    }

    protected final void writeEscapeAttributeEntities(String string) {
        if (string != null) {
            String string2 = this.escapeAttributeEntities(string);
            this.writer.write(string2);
        }
    }

    protected final void writeNamespace(String string, String string2) {
        if (string != null && string.length() > 0) {
            this.writer.write(" xmlns:");
            this.writer.write(string);
            this.writer.write("=\"");
        } else {
            this.writer.write(" xmlns=\"");
        }
        this.writer.write(string2);
        this.writer.write("\"");
    }

    protected final void writeNamespace(Namespace namespace) {
        if (namespace != null) {
            this.writeNamespace(namespace.getPrefix(), namespace.getURI());
        }
    }

    protected final void writeNamespaces() {
        if (this.namespacesMap != null) {
            Iterator iterator = this.namespacesMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                this.writeNamespace(string, string2);
            }
            this.namespacesMap = null;
        }
    }

    protected final void writeNode(Node node) {
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                this.writeElement((Element)node);
                break;
            }
            case 2: {
                this.writeAttribute((Attribute)node);
                break;
            }
            case 3: {
                this.writeString(node.getText());
                break;
            }
            case 4: {
                this.writeCDATA(node.getText());
                break;
            }
            case 5: {
                this.writeEntity((Entity)node);
                break;
            }
            case 7: {
                this.writeProcessingInstruction((ProcessingInstruction)node);
                break;
            }
            case 8: {
                this.writeComment(node.getText());
                break;
            }
            case 9: {
                this.write((Document)node);
                break;
            }
            case 10: {
                this.writeDocType((DocumentType)node);
                break;
            }
            default: {
                throw new IOException("Invalid node type: " + node);
            }
            case 13: 
        }
    }

    public final void writeOpen(Element element) {
        this.writer.write("<");
        this.writer.write(element.getQualifiedName());
        this.writeAttributes(element);
        this.writer.write(">");
    }

    protected final void writePrintln() {
        if (this.format.isNewlines()) {
            this.writer.write(this.format.getLineSeparator());
        }
    }

    protected final void writeProcessingInstruction(ProcessingInstruction processingInstruction) {
        this.writer.write("<?");
        this.writer.write(processingInstruction.getName());
        this.writer.write(" ");
        this.writer.write(processingInstruction.getText());
        this.writer.write("?>");
        this.writePrintln();
        this.lastOutputNodeType = 7;
    }

    protected final void writeString(String string) {
        if (string != null && string.length() > 0) {
            if (this.escapeText) {
                string = this.escapeElementEntities(string);
            }
            if (this.format.isTrimText()) {
                boolean bl = true;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (bl) {
                        bl = false;
                        if (this.lastOutputNodeType == 3) {
                            this.writer.write(" ");
                        }
                    } else {
                        this.writer.write(" ");
                    }
                    this.writer.write(string2);
                    this.lastOutputNodeType = 3;
                }
            } else {
                this.lastOutputNodeType = 3;
                this.writer.write(string);
            }
        }
    }
}

