/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.xpath;

import java.util.ArrayList;
import org.dom4j.InvalidXPathException;
import org.dom4j.Node;
import org.dom4j.XPathException;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.JaxenException;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPathFunctionContext;
import org.jaxen.dom4j.DocumentNavigator;
import org.jaxen.pattern.Pattern;
import org.jaxen.pattern.PatternParser;
import org.saxpath.SAXPathException;

public class XPathPattern
implements org.dom4j.rule.Pattern {
    private String text;
    private Pattern pattern;
    private Context context;

    public XPathPattern(String string) {
        this.text = string;
        this.context = new Context(this.getContextSupport());
        try {
            this.pattern = PatternParser.parse(string);
        }
        catch (SAXPathException sAXPathException) {
            throw new InvalidXPathException(string, sAXPathException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidXPathException(string);
        }
    }

    public XPathPattern(Pattern pattern) {
        this.pattern = pattern;
        this.text = pattern.getText();
        this.context = new Context(this.getContextSupport());
    }

    protected final ContextSupport getContextSupport() {
        return new ContextSupport(new SimpleNamespaceContext(), XPathFunctionContext.getInstance(), new SimpleVariableContext(), DocumentNavigator.getInstance());
    }

    public final short getMatchType() {
        return this.pattern.getMatchType();
    }

    public final String getMatchesNodeName() {
        return this.pattern.getMatchesNodeName();
    }

    public final double getPriority() {
        return this.pattern.getPriority();
    }

    public final String getText() {
        return this.text;
    }

    public final org.dom4j.rule.Pattern[] getUnionPatterns() {
        Pattern[] patternArray = this.pattern.getUnionPatterns();
        if (patternArray != null) {
            int n = patternArray.length;
            org.dom4j.rule.Pattern[] patternArray2 = new XPathPattern[n];
            int n2 = 0;
            while (n2 < n) {
                patternArray2[n2] = new XPathPattern(patternArray[n2]);
                ++n2;
            }
            return patternArray2;
        }
        return null;
    }

    protected final void handleJaxenException(JaxenException jaxenException) {
        throw new XPathException(this.text, jaxenException);
    }

    public final boolean matches(Node node) {
        try {
            ArrayList<Node> arrayList = new ArrayList<Node>(1);
            arrayList.add(node);
            this.context.setNodeSet(arrayList);
            return this.pattern.matches(node, this.context);
        }
        catch (JaxenException jaxenException) {
            this.handleJaxenException(jaxenException);
            return false;
        }
    }

    public final void setVariableContext(VariableContext variableContext) {
        this.context.getContextSupport().setVariableContext(variableContext);
    }

    public final String toString() {
        return "[XPathPattern: text: " + this.text + " Pattern: " + this.pattern + "]";
    }
}

