/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.annotation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.genepattern.annotation.SampleAnnotatorPanel$1;
import org.genepattern.annotation.SparseClassVector;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.heatmap.PixelConverter;
import org.genepattern.heatmap.image.SampleAnnotator;

public class SampleAnnotatorPanel
extends JPanel {
    private SparseClassVector classVector;
    private int heightPerClass = 6;
    private PixelConverter pixelConverter;
    private IExpressionData data;
    private int columnSize;
    private int numAnnotations = 0;
    private int spacer = 2;

    public SampleAnnotatorPanel(SparseClassVector sparseClassVector, IExpressionData iExpressionData, int n, JComponent jComponent) {
        this.setBackground(Color.WHITE);
        this.classVector = sparseClassVector;
        this.data = iExpressionData;
        this.columnSize = n;
        this.classVector.addListener(new SampleAnnotatorPanel$1(this, jComponent));
        this.pixelConverter = new PixelConverter(this);
        this.pixelConverter.setColumnSize(n);
    }

    public final void setColumnSize(int n) {
        this.columnSize = n;
    }

    @Override
    public final Dimension getPreferredSize() {
        return new Dimension(this.data.getColumnCount() * this.columnSize, this.numAnnotations * this.heightPerClass + this.numAnnotations * this.spacer);
    }

    @Override
    public final void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.pixelConverter.getLeftIndex(rectangle.x);
        int n2 = this.pixelConverter.getRightIndex(rectangle.x + rectangle.width, this.data.getColumnCount());
        for (int i2 = n; i2 < n2; ++i2) {
            List list = this.classVector.getClassNumbers(i2);
            if (list == null) continue;
            int n3 = (this.numAnnotations - 1) * this.heightPerClass + (this.numAnnotations - 1) * this.spacer;
            for (int i3 = 0; i3 < list.size(); ++i3) {
                Integer n4 = (Integer)list.get(i3);
                graphics.setColor(this.classVector.getColor(n4));
                graphics.fillRect(i2 * this.columnSize, n3, this.columnSize, this.heightPerClass);
                n3 = n3 - this.heightPerClass - this.spacer;
            }
        }
    }

    public final void setSampleAnnotator(SampleAnnotator sampleAnnotator) {
        Serializable serializable;
        Serializable serializable2;
        HashMap<Color, Integer> hashMap = new HashMap<Color, Integer>();
        int n = 0;
        for (int i2 = 0; i2 < this.data.getRowCount(); ++i2) {
            List list = sampleAnnotator.getColors(this.data.getRowName(i2));
            for (int i3 = 0; i3 < list.size(); ++i3) {
                serializable2 = (Color)list.get(i3);
                if (serializable2 == null || (serializable = (Integer)hashMap.get(serializable2)) != null) continue;
                serializable = new Integer(n++);
                hashMap.put((Color)serializable2, (Integer)serializable);
            }
        }
        SparseClassVector sparseClassVector = new SparseClassVector();
        for (Color color : hashMap.keySet()) {
            serializable2 = (Integer)hashMap.get(color);
            sparseClassVector.setClass((Integer)serializable2, "", color);
        }
        for (int i4 = 0; i4 < this.data.getRowCount(); ++i4) {
            List list = sampleAnnotator.getColors(this.data.getRowName(i4));
            for (int i5 = 0; i5 < list.size(); ++i5) {
                serializable = (Color)list.get(i5);
                if (serializable == null) continue;
                sparseClassVector.addClass(i4, (Integer)hashMap.get(serializable));
            }
        }
        this.classVector = sparseClassVector;
    }

    static final /* synthetic */ int access$002(SampleAnnotatorPanel sampleAnnotatorPanel, int n) {
        sampleAnnotatorPanel.numAnnotations = n;
        return sampleAnnotatorPanel.numAnnotations;
    }

    static final /* synthetic */ IExpressionData access$100(SampleAnnotatorPanel sampleAnnotatorPanel) {
        return sampleAnnotatorPanel.data;
    }

    static final /* synthetic */ SparseClassVector access$200(SampleAnnotatorPanel sampleAnnotatorPanel) {
        return sampleAnnotatorPanel.classVector;
    }

    static final /* synthetic */ int access$000(SampleAnnotatorPanel sampleAnnotatorPanel) {
        return sampleAnnotatorPanel.numAnnotations;
    }
}

