/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.annotation;

import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.parsers.MiscParsers;
import edu.mit.broad.genome.parsers.ParserFactory;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.genepattern.annotation.SetAnnotator;
import org.genepattern.annotation.SetAnnotatorModel;
import org.genepattern.data.matrix.ClassVector;
import org.genepattern.io.Util;
import org.genepattern.module.VisualizerUtil;
import org.genepattern.uiutil.FileChooser;
import org.genepattern.uiutil.UIUtil;

class SetAnnotator$2
implements ActionListener {
    final /* synthetic */ Frame val$parent;
    final /* synthetic */ SetAnnotatorModel val$model;
    final /* synthetic */ SetAnnotator this$0;

    SetAnnotator$2(SetAnnotator setAnnotator, Frame frame, SetAnnotatorModel setAnnotatorModel) {
        this.this$0 = setAnnotator;
        this.val$parent = frame;
        this.val$model = setAnnotatorModel;
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        String string = SetAnnotator.access$000(this.this$0) ? "Select Feature List(s)" : "Select Cls File";
        File file = FileChooser.showOpenDialog(this.val$parent, string);
        if (file != null) {
            String string2 = Util.getExtension(file);
            if (SetAnnotator.access$000(this.this$0)) {
                boolean bl = false;
                try {
                    if (string2 != null) {
                        if ((string2 = string2.toLowerCase()).equals("gmt") || string2.equals("gmx")) {
                            GeneSetMatrix geneSetMatrix = ParserFactory.readGeneSetMatrix(file, false);
                            int n = geneSetMatrix.getNumGeneSets();
                            for (int i2 = 0; i2 < n; ++i2) {
                                GeneSet geneSet = geneSetMatrix.getGeneSet(i2);
                                boolean bl2 = this.this$0.addToFeatureList(geneSet.getMembers(), geneSet.getName(), null);
                                bl = bl || bl2;
                            }
                        } else if (string2.equals("grp")) {
                            GeneSet geneSet = ParserFactory.readGeneSet(file, false);
                            bl = this.this$0.addToFeatureList(geneSet.getMembers(), file.getName(), null);
                        } else {
                            List list = VisualizerUtil.readFeatureList(this.val$parent, file.getCanonicalPath());
                            bl = this.this$0.addToFeatureList(list, file.getName(), null);
                        }
                    } else {
                        List list = VisualizerUtil.readFeatureList(this.val$parent, file.getCanonicalPath());
                        bl = this.this$0.addToFeatureList(list, file.getName(), null);
                    }
                    if (bl) {
                        UIUtil.showMessageDialog(this.val$parent, "Warning: The file contains features that are not found in the data set.");
                    }
                    if (SetAnnotator.access$100(this.this$0) != null) {
                        SetAnnotator.access$100(this.this$0).invalidate();
                        SetAnnotator.access$100(this.this$0).validate();
                        SetAnnotator.access$100(this.this$0).repaint();
                    }
                }
                catch (Exception exception) {
                    UIUtil.showErrorDialog(this.val$parent, "An error occurred while reading " + file.getName());
                }
            } else {
                try {
                    if (string2 != null && string2.equals("xls")) {
                        Map map = MiscParsers.parseColorMapFromExcel(file);
                        for (String string3 : map.keySet()) {
                            Color color = (Color)map.get(string3);
                        }
                    } else {
                        int n;
                        ClassVector classVector = VisualizerUtil.readCls(this.val$parent, file.getCanonicalPath());
                        if (classVector == null) {
                            return;
                        }
                        if (classVector.size() != this.val$model.getFeatureCount()) {
                            UIUtil.showErrorDialog(this.val$parent, "The number of samples in the cls file (" + classVector.size() + ") does not match the number of samples in the dataset (" + this.val$model.getFeatureCount() + ").");
                            return;
                        }
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        for (n = 0; n < classVector.getClassCount(); ++n) {
                            Color color = null;
                            int n2 = n + this.this$0.classNumberCounter;
                            color = n2 >= SetAnnotator.colors.length ? new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0)) : SetAnnotator.colors[n2];
                            arrayList.add(new Integer(n2));
                            this.this$0.classVector.setClass(new Integer(n2), classVector.getClassName(n), color);
                        }
                        this.this$0.classVector.addClassGroup(arrayList, file.getName());
                        for (n = 0; n < classVector.size(); ++n) {
                            this.this$0.classVector.addClass(n, new Integer(classVector.getAssignment(n) + this.this$0.classNumberCounter));
                        }
                        this.this$0.classVector.notifyListeners();
                        this.this$0.classNumberCounter += classVector.getClassCount();
                    }
                    if (SetAnnotator.access$100(this.this$0) != null) {
                        SetAnnotator.access$100(this.this$0).invalidate();
                        SetAnnotator.access$100(this.this$0).validate();
                        SetAnnotator.access$100(this.this$0).repaint();
                    }
                }
                catch (Exception exception) {
                    UIUtil.showErrorDialog(this.val$parent, "An error occurred while reading " + file.getName());
                }
            }
        }
    }
}

