/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.clustering.hierarchical;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.genepattern.clustering.hierarchical.Node;

public class AtrGtrReader {
    private double maxArrayCorr;
    private Map nodes = new HashMap();
    private double minArrayCorr;
    private String rootArrayNodeId;
    private HashMap id2Index;
    private String[] ids;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtrGtrReader(String[] stringArray, String string) {
        this.ids = stringArray;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            this.parse(bufferedReader, stringArray);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public final String[] getIds() {
        return this.ids;
    }

    private int getIndex(String string) {
        Integer n = (Integer)this.id2Index.get(string);
        if (n == null) {
            throw new IOException("id " + string + " not found");
        }
        return n;
    }

    private final void parse(BufferedReader bufferedReader, String[] stringArray) {
        String string;
        boolean bl = true;
        Node node = null;
        this.id2Index = new HashMap();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.id2Index.put(stringArray[i2], new Integer(i2));
        }
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            double d2 = Double.parseDouble(stringTokenizer.nextToken());
            Color color = null;
            if (stringTokenizer.hasMoreTokens()) {
                color = Color.decode(stringTokenizer.nextToken());
            }
            if (bl) {
                this.maxArrayCorr = d2;
                bl = false;
            }
            Node node2 = null;
            Node node3 = null;
            if (this.nodes.containsKey(string3)) {
                node2 = (Node)this.nodes.get(string3);
            } else {
                node2 = new Node(string3);
                n = this.getIndex(string3);
                node2.setIndex(n);
                node2.setMinIndex(n);
                node2.setMaxIndex(n);
                this.nodes.put(string3, node2);
            }
            if (this.nodes.containsKey(string4)) {
                node3 = (Node)this.nodes.get(string4);
            } else {
                node3 = new Node(string4);
                n = this.getIndex(string4);
                node3.setIndex(n);
                node3.setMinIndex(n);
                node3.setMaxIndex(n);
                this.nodes.put(string4, node3);
            }
            node = new Node(string2, node2, node3, d2);
            if (color != null) {
                node.setColor(color);
            }
            node.setMinIndex(Math.min(node3.getMinIndex(), node2.getMinIndex()));
            node.setMaxIndex(Math.max(node3.getMaxIndex(), node2.getMaxIndex()));
            node2.setParent(node);
            node3.setParent(node);
            this.nodes.put(string2, node);
        }
        this.minArrayCorr = node.getCorrelation();
        this.rootArrayNodeId = node.getId();
    }

    public final double getMaxArrayCorr() {
        return this.maxArrayCorr;
    }

    public final Map getNodes() {
        return this.nodes;
    }

    public final double getMinArrayCorr() {
        return this.minArrayCorr;
    }

    public final String getRootNodeId() {
        return this.rootArrayNodeId;
    }
}

