/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.clustering.hierarchical;

import java.awt.Color;

public class Node {
    protected String id = null;
    protected Node left = null;
    protected Node right = null;
    protected Node parent = null;
    protected double index;
    protected double correlation = 1.0;
    protected Color color = Color.black;
    protected boolean selected = false;
    protected int minIndex;
    protected int maxIndex;

    public Node(String string) {
        this.id = string;
    }

    public Node(String string, Node node, Node node2, double d2) {
        this.id = string;
        this.left = node;
        this.right = node2;
        this.correlation = d2;
        this.setIndex();
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String string) {
        this.id = string;
    }

    public final void setParent(Node node) {
        this.parent = node;
    }

    public final void setLeft(Node node) {
        this.left = node;
    }

    public final void setRight(Node node) {
        this.right = node;
    }

    public final Node getParent() {
        if (this.isRoot()) {
            return this;
        }
        return this.parent;
    }

    public final Node getLeft() {
        if (this.isLeaf()) {
            return this;
        }
        return this.left;
    }

    public final Node getRight() {
        if (this.isLeaf()) {
            return this;
        }
        return this.right;
    }

    public final void setCorrelation(double d2) {
        this.correlation = d2;
    }

    public final double getCorrelation() {
        return this.correlation;
    }

    public final void setIndex(double d2) {
        this.index = d2;
    }

    public final void setIndex() {
        if (this.left != null && this.right != null) {
            this.index = (this.right.getIndex() + this.left.getIndex()) / 2.0;
        }
    }

    public final double getIndex() {
        return this.index;
    }

    public final void setColor(Color color) {
        this.color = color;
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setSelected(boolean bl) {
        this.selected = bl;
        if (this.left != null) {
            this.left.setSelected(bl);
        }
        if (this.right != null) {
            this.right.setSelected(bl);
        }
    }

    public final void setRootColor(Color color) {
        this.color = color;
        if (this.left != null) {
            this.left.setRootColor(color);
        }
        if (this.right != null) {
            this.right.setRootColor(color);
        }
    }

    public final boolean isSelected() {
        return this.selected;
    }

    public final boolean isLeaf() {
        return this.left == null && this.right == null;
    }

    public final boolean isRoot() {
        return this.parent == null;
    }

    public final String toString() {
        return this.id;
    }

    public final int getMaxIndex() {
        return this.maxIndex;
    }

    public final void setMaxIndex(int n) {
        this.maxIndex = n;
    }

    public final int getMinIndex() {
        return this.minIndex;
    }

    public final void setMinIndex(int n) {
        this.minIndex = n;
    }

    public final void printSubtree() {
        if (!this.isLeaf()) {
            System.out.println(this.getId() + ", corr " + this.getCorrelation() + ", index " + this.getIndex() + " min " + this.minIndex + " max " + this.maxIndex);
            System.out.print("Left: ");
            this.getLeft().printSubtree();
            System.out.print("Right: ");
            this.getRight().printSubtree();
        } else {
            System.out.println("LEAF " + this.getId() + " corr " + this.getCorrelation() + ", index " + this.getIndex());
        }
    }

    protected final void recomputeIndices() {
        if (!this.isLeaf()) {
            this.left.recomputeIndices();
            this.right.recomputeIndices();
            this.setIndex();
            this.maxIndex = Math.max(this.left.maxIndex, this.right.maxIndex);
            this.minIndex = Math.min(this.left.minIndex, this.right.minIndex);
        }
    }
}

