/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.data.expr;

import java.util.HashMap;
import java.util.Map;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.expr.MetaData;
import org.genepattern.data.matrix.DoubleMatrix2D;
import org.genepattern.data.matrix.ObjectMatrix2D;

public class ExpressionData
implements IExpressionData {
    protected DoubleMatrix2D dataset;
    protected Map matrices;
    protected MetaData rowMetaData;
    protected MetaData columnMetaData;

    public ExpressionData(DoubleMatrix2D doubleMatrix2D, String[] stringArray, String[] stringArray2) {
        this.dataset = doubleMatrix2D;
        this.rowMetaData = new MetaData(doubleMatrix2D.getRowCount());
        if (stringArray != null) {
            if (stringArray.length != doubleMatrix2D.getRowCount()) {
                throw new IllegalArgumentException("Length of row descriptions not equal to number of rows in matrix.");
            }
            this.rowMetaData.setMetaData("description", stringArray);
        }
        this.columnMetaData = new MetaData(doubleMatrix2D.getColumnCount());
        if (stringArray2 != null) {
            if (stringArray2.length != doubleMatrix2D.getColumnCount()) {
                throw new IllegalArgumentException("Length of column descriptions not equal to number of columns in matrix.");
            }
            this.columnMetaData.setMetaData("description", stringArray2);
        }
        this.matrices = new HashMap();
    }

    public ExpressionData(DoubleMatrix2D doubleMatrix2D, MetaData metaData, MetaData metaData2, Map map) {
        this.dataset = doubleMatrix2D;
        this.rowMetaData = metaData;
        this.columnMetaData = metaData2;
        this.matrices = map;
        if (this.matrices == null) {
            this.matrices = new HashMap();
        }
    }

    public final ObjectMatrix2D getMatrix(String string) {
        return (ObjectMatrix2D)this.matrices.get(string);
    }

    public final void setMatrix(String string, ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D.getRowCount() != this.getRowCount()) {
            throw new IllegalArgumentException("Number of rows in given matrix must be equal to the number of rows.");
        }
        if (objectMatrix2D.getColumnCount() != this.getColumnCount()) {
            throw new IllegalArgumentException("Number of columns in given matrix must be equal to the number of columns.");
        }
        this.matrices.put(string, objectMatrix2D);
    }

    public final ExpressionData slice(String[] stringArray, String[] stringArray2) {
        int n;
        int n2;
        int n3;
        int[] nArray;
        int[] nArray2 = stringArray != null ? new int[stringArray.length] : null;
        int[] nArray3 = nArray = stringArray2 != null ? new int[stringArray2.length] : null;
        if (nArray2 != null) {
            n3 = nArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                n = this.dataset.getRowIndex(stringArray[n2]);
                if (n == -1) {
                    throw new IllegalArgumentException("Row name " + stringArray[n2] + " not found.");
                }
                nArray2[n2] = n;
            }
        }
        if (nArray != null) {
            n3 = nArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                n = this.dataset.getColumnIndex(stringArray2[n2]);
                if (n == -1) {
                    throw new IllegalArgumentException("Column name " + stringArray2[n2] + " not found.");
                }
                nArray[n2] = n;
            }
        }
        return this.slice(nArray2, nArray);
    }

    public final ExpressionData slice(int[] nArray, int[] nArray2) {
        int n;
        if (nArray == null) {
            nArray = new int[this.dataset.getRowCount()];
            n = this.dataset.getRowCount();
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.dataset.getColumnCount()];
            n = this.dataset.getColumnCount();
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        DoubleMatrix2D doubleMatrix2D = this.dataset.slice(nArray, nArray2);
        MetaData metaData = this.rowMetaData.slice(nArray);
        MetaData metaData2 = this.columnMetaData.slice(nArray2);
        HashMap<String, ObjectMatrix2D> hashMap = new HashMap<String, ObjectMatrix2D>();
        for (String string : this.matrices.keySet()) {
            ObjectMatrix2D objectMatrix2D = (ObjectMatrix2D)this.matrices.get(string);
            hashMap.put(string, objectMatrix2D.slice(nArray, nArray2));
        }
        return new ExpressionData(doubleMatrix2D, metaData, metaData2, hashMap);
    }

    public final void setRowDescription(int n, String string) {
        this.rowMetaData.setMetaData(n, "description", string);
    }

    public final void setColumnDescription(int n, String string) {
        this.columnMetaData.setMetaData(n, "description", string);
    }

    public final void setColumnName(int n, String string) {
        this.dataset.setColumnName(n, string);
    }

    public final void setRowName(int n, String string) {
        this.dataset.setRowName(n, string);
    }

    public final String getColumnDescription(int n) {
        if (this.columnMetaData.contains("description")) {
            return this.columnMetaData.getMetaData(n, "description");
        }
        return null;
    }

    public final String getRowDescription(int n) {
        if (this.rowMetaData.contains("description")) {
            return this.rowMetaData.getMetaData(n, "description");
        }
        return null;
    }

    public final String[] getRowDescriptions() {
        return this.rowMetaData.contains("description") ? this.rowMetaData.getArray("description") : null;
    }

    public final void setRowDescriptions(String[] stringArray) {
        if (stringArray != null && stringArray.length != this.getRowCount()) {
            throw new IllegalArgumentException("Length of descriptions must be equal to the number of rows.");
        }
        this.rowMetaData.setMetaData("description", stringArray);
    }

    public final String[] getColumnDescriptions() {
        return this.columnMetaData.contains("description") ? this.columnMetaData.getArray("description") : null;
    }

    public final void setColumnDescriptions(String[] stringArray) {
        if (stringArray != null && stringArray.length != this.getColumnCount()) {
            throw new IllegalArgumentException("Length of descriptions must be equal to the number of columns.");
        }
        this.columnMetaData.setMetaData("description", stringArray);
    }

    @Override
    public final int getRowCount() {
        return this.dataset.getRowCount();
    }

    @Override
    public final int getColumnCount() {
        return this.dataset.getColumnCount();
    }

    @Override
    public final double getValue(int n, int n2) {
        return this.dataset.get(n, n2);
    }

    @Override
    public final String getValueAsString(int n, int n2) {
        return String.valueOf(this.dataset.get(n, n2));
    }

    @Override
    public final String getColumnName(int n) {
        return this.dataset.getColumnName(n);
    }

    @Override
    public final String getRowName(int n) {
        return this.dataset.getRowName(n);
    }

    public final String[] getRowNames() {
        return this.dataset.getRowNames();
    }

    public final String[] getColumnNames() {
        return this.dataset.getColumnNames();
    }

    public final DoubleMatrix2D getExpressionMatrix() {
        return this.dataset;
    }

    public final double[][] getArray() {
        return this.dataset.getArray();
    }

    public final double[] getRow(int n) {
        return this.dataset.getRow(n);
    }

    @Override
    public final int getRowIndex(String string) {
        return this.dataset.getRowIndex(string);
    }

    @Override
    public final int getColumnIndex(String string) {
        return this.dataset.getColumnIndex(string);
    }

    public final void set(int n, int n2, double d2) {
        this.dataset.set(n, n2, d2);
    }

    public final void set(String string, String string2, double d2) {
        this.dataset.set(string, string2, d2);
    }

    public final double get(int n, int n2) {
        return this.dataset.get(n, n2);
    }

    public final boolean containsData(String string) {
        return this.matrices.containsKey(string);
    }

    public final String[] getDataNames() {
        return this.matrices.keySet().toArray(new String[0]);
    }

    public final String[] getRowMetadataNames() {
        return this.rowMetaData.getNames();
    }

    public final String[] getColumnMetadataNames() {
        return this.columnMetaData.getNames();
    }

    @Override
    public final Object getData(int n, int n2, String string) {
        ObjectMatrix2D objectMatrix2D = (ObjectMatrix2D)this.matrices.get(string);
        return objectMatrix2D != null ? objectMatrix2D.get(n, n2) : null;
    }

    public final boolean containsRowMetadata(String string) {
        return this.rowMetaData.contains(string);
    }

    public final boolean containsColumnMetadata(String string) {
        return this.columnMetaData.contains(string);
    }

    @Override
    public final String getRowMetadata(int n, String string) {
        return this.rowMetaData.getMetaData(n, string);
    }

    @Override
    public final String getColumnMetadata(int n, String string) {
        return this.columnMetaData.getMetaData(n, string);
    }

    @Override
    public final String getDataName(int n) {
        return this.matrices.keySet().toArray(new String[0])[n];
    }

    @Override
    public final int getDataCount() {
        return this.matrices.size();
    }

    @Override
    public final String getRowMetadataName(int n) {
        return this.rowMetaData.getNames()[n];
    }

    @Override
    public final int getRowMetadataCount() {
        return this.rowMetaData.size();
    }

    @Override
    public final String getColumnMetadataName(int n) {
        return this.columnMetaData.getNames()[n];
    }

    @Override
    public final int getColumnMetadataCount() {
        return this.columnMetaData.size();
    }
}

