/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import java.util.Arrays;
import org.genepattern.data.expr.IExpressionData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.util.FloatMatrix;

public class HCLAlgorithm {
    public static final int AVERAGE_LINKAGE = 0;
    public static final int COMPLETE_LINKAGE = 1;
    public static final int SINGLE_LINKAGE = -1;
    public static final int COSINE = 2;
    public static final int COVARIANCE = 3;
    public static final int DOTPRODUCT = 5;
    public static final int EUCLIDEAN = 4;
    public static final int KENDALLSTAU = 10;
    public static final int MANHATTAN = 8;
    public static final int MUTUALINFORMATION = 11;
    public static final int PEARSON = 1;
    public static final int PEARSONSQARED = 7;
    public static final int PEARSONUNCENTERED = 6;
    public static final int SPEARMANRANK = 9;
    public static final int ROWS = 0;
    public static final int BOTH = 2;
    public static final int COLUMNS = 1;
    private int clusterBy;
    private int distanceMeasure;
    private int[] genes_child_1_array;
    private int[] genes_child_2_array;
    private FloatMatrix genes_height;
    private int[] genes_node_order;
    private int[] genes_order;
    private int mergeType;
    private int[] samples_child_1_array;
    private int[] samples_child_2_array;
    private FloatMatrix samples_height;
    private int[] samples_node_order;
    private int[] samples_order;

    public HCLAlgorithm(IExpressionData iExpressionData, int n, int n2, int n3) {
        this.mergeType = n;
        this.distanceMeasure = n2;
        this.clusterBy = n3;
        AlgorithmData algorithmData = null;
        AlgorithmData algorithmData2 = null;
        FloatMatrix floatMatrix = new FloatMatrix(iExpressionData.getRowCount(), iExpressionData.getColumnCount());
        int n4 = iExpressionData.getRowCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = iExpressionData.getColumnCount();
            for (int i3 = 0; i3 < n5; ++i3) {
                floatMatrix.set(i2, i3, (float)iExpressionData.getValue(i2, i3));
            }
        }
        if (n3 == 0 || n3 == 2) {
            HCL hCL = new HCL();
            AlgorithmData algorithmData3 = new AlgorithmData();
            algorithmData3.addMatrix("experiment", floatMatrix);
            algorithmData3.addParam("distance-function", "" + n2);
            algorithmData3.addParam("distance-absolute", "false");
            algorithmData3.addParam("calculate-genes", "true");
            algorithmData3.addParam("method-linkage", "" + n);
            algorithmData2 = hCL.execute(algorithmData3);
            this.genes_child_1_array = algorithmData2.getIntArray("child-1-array");
            this.genes_child_2_array = algorithmData2.getIntArray("child-2-array");
            this.genes_node_order = algorithmData2.getIntArray("node-order");
            this.genes_order = this.getLeafOrder(this.genes_node_order, this.genes_child_1_array, this.genes_child_2_array, null);
            this.genes_height = algorithmData2.getMatrix("height");
        }
        if (n3 == 1 || n3 == 2) {
            HCL hCL = new HCL();
            AlgorithmData algorithmData4 = new AlgorithmData();
            algorithmData4.addMatrix("experiment", floatMatrix);
            algorithmData4.addParam("distance-function", "" + n2);
            algorithmData4.addParam("distance-absolute", "false");
            algorithmData4.addParam("calculate-genes", "false");
            algorithmData4.addParam("method-linkage", "0");
            algorithmData = hCL.execute(algorithmData4);
            this.samples_child_1_array = algorithmData.getIntArray("child-1-array");
            this.samples_child_2_array = algorithmData.getIntArray("child-2-array");
            this.samples_node_order = algorithmData.getIntArray("node-order");
            this.samples_order = this.getLeafOrder(this.samples_node_order, this.samples_child_1_array, this.samples_child_2_array, null);
            this.samples_height = algorithmData.getMatrix("height");
        }
    }

    public final int[] getGenes_child_1_array() {
        return this.genes_child_1_array;
    }

    public final int[] getGenes_child_2_array() {
        return this.genes_child_2_array;
    }

    public final FloatMatrix getGenes_height() {
        return this.genes_height;
    }

    public final int[] getGenes_order() {
        return this.genes_order;
    }

    public final int[] getSamples_child_1_array() {
        return this.samples_child_1_array;
    }

    public final int[] getSamples_child_2_array() {
        return this.samples_child_2_array;
    }

    public final FloatMatrix getSamples_height() {
        return this.samples_height;
    }

    public final int[] getSamples_node_order() {
        return this.samples_node_order;
    }

    public final int[] getGenes_node_order() {
        return this.genes_node_order;
    }

    public final int[] getSamples_order() {
        return this.samples_order;
    }

    private int fillLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2, int[] nArray4) {
        if (nArray2[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray2[n2], nArray4);
        }
        if (nArray3[n2] != -1) {
            n = this.fillLeafOrder(nArray, nArray2, nArray3, n, nArray3[n2], nArray4);
        } else {
            nArray[n] = nArray4 == null ? n2 : nArray4[n2];
            ++n;
        }
        return n;
    }

    private int[] getLeafOrder(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = new int[nArray.length];
        Arrays.fill(nArray5, -1);
        this.fillLeafOrder(nArray5, nArray2, nArray3, 0, nArray2.length - 2, nArray4);
        return nArray5;
    }

    public final int getClusterBy() {
        return this.clusterBy;
    }

    public final int getDistanceMeasure() {
        return this.distanceMeasure;
    }

    public final int getMergeType() {
        return this.mergeType;
    }
}

