/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.swing.JideSplitPane;
import edu.mit.broad.genome.alg.GeneSetStats;
import edu.mit.broad.genome.alg.GeneSetStats$RedStruc;
import edu.mit.broad.genome.alg.cluster.ClusteringAlgs;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.BitSetDataset;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.GPWrappers;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.RankedList;
import gnu.trove.TFloatIntHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.genepattern.gsea.GeneHistogram;
import org.genepattern.gsea.GeneSetSimilarityPanel;
import org.genepattern.gsea.JacquardHistogram;
import org.genepattern.gsea.LeadingEdgeAnalysis$1;
import org.genepattern.gsea.LeadingEdgeAnalysis$2;
import org.genepattern.gsea.LeadingEdgeAnalysis$3;
import org.genepattern.gsea.LeadingEdgePanel;
import org.genepattern.heatmap.ColorScheme;
import org.genepattern.menu.jfree.JFreeMenuBar;

public class LeadingEdgeAnalysis {
    private JPanel mainComponent;
    private LeadingEdgePanel leadingEdgePanel;
    private static final String LEADING_EDGE_MATRIX_KEY = "Leading Edge Matrix";
    private static final String GENE_SET_SIMILARITY_MATRIX_KEY = "Gene Set Similarity Matrix";
    private static final String GENE_HISTOGRAM_KEY = "Gene Histogram";
    private static final String JACQUARD_HISTOGRAM_KEY = "Jacquard Histogram of Gene Sets";

    private Dataset _morph(Dataset dataset, RankedList rankedList) {
        Matrix matrix = new Matrix(dataset.getNumRow(), dataset.getNumCol());
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            for (int i3 = 0; i3 < dataset.getNumCol(); ++i3) {
                float f2 = rankedList.getScore(dataset.getColumnName(i3));
                float f3 = dataset.getElement(i2, i3);
                if (f3 == 1.0f) {
                    matrix.setElement(i2, i3, f2);
                    continue;
                }
                matrix.setElement(i2, i3, f3);
            }
        }
        return new DefaultDataset(dataset.getName(), matrix, dataset.getRowNames(), dataset.getColumnNames(), true, dataset.getAnnot());
    }

    public final void setResultDirectory(File file) {
        this.leadingEdgePanel.setResultDirectory(file);
    }

    public LeadingEdgeAnalysis(GeneSetMatrix geneSetMatrix, RankedList rankedList, Frame frame) {
        Object object;
        int n;
        GeneSet[] geneSetArray = geneSetMatrix.getGeneSets();
        BitSetDataset bitSetDataset = new BitSetDataset(geneSetMatrix);
        Dataset dataset = bitSetDataset.toDataset(true, false);
        Dataset dataset2 = null;
        try {
            dataset2 = ClusteringAlgs.cluster(dataset).getDatasetOrdered();
        }
        catch (Throwable throwable) {
            dataset2 = dataset;
            throwable.printStackTrace();
        }
        Dataset dataset3 = rankedList != null ? this._morph(dataset2, rankedList) : dataset2;
        this.leadingEdgePanel = new LeadingEdgePanel(frame, null);
        ColorScheme colorScheme = rankedList != null ? GPWrappers.createColorScheme_for_lev_with_score(dataset3) : new LeadingEdgeAnalysis$1(this, dataset3);
        this.leadingEdgePanel.setData(GPWrappers.createIExpressionData(dataset3), false, colorScheme);
        GeneSetStats geneSetStats = new GeneSetStats();
        GeneSetStats$RedStruc geneSetStats$RedStruc = geneSetStats.calcRedundancy(geneSetArray, false);
        GeneSetSimilarityPanel geneSetSimilarityPanel = new GeneSetSimilarityPanel(frame);
        GeneSet[] geneSetArray2 = new GeneSet[geneSetArray.length];
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (n = 0; n < geneSetArray.length; ++n) {
            hashMap.put(geneSetArray[n].getName(true), new Integer(n));
        }
        for (n = 0; n < geneSetArray.length; ++n) {
            object = dataset3.getRowName(n);
            geneSetArray2[n] = geneSetArray[(Integer)hashMap.get(object)];
        }
        geneSetSimilarityPanel.setGeneSets(geneSetArray2);
        JacquardHistogram jacquardHistogram = new JacquardHistogram();
        object = geneSetStats$RedStruc.jacquardDistrib;
        jacquardHistogram.setJacquardToOccurrencesMap((TFloatIntHashMap)object);
        GeneHistogram geneHistogram = new GeneHistogram();
        RankedList rankedList2 = geneSetStats$RedStruc.featureFreq;
        geneHistogram.setFeatureFrequency(rankedList2, rankedList != null ? rankedList : null);
        LeadingEdgeAnalysis$2 leadingEdgeAnalysis$2 = new LeadingEdgeAnalysis$2(this, geneHistogram, dataset3);
        geneHistogram.getChartPanel().addChartMouseListener(leadingEdgeAnalysis$2);
        JScrollPane jScrollPane = new JScrollPane(this.leadingEdgePanel.getHeatMapComponent());
        jScrollPane.setBorder(null);
        JScrollPane jScrollPane2 = new JScrollPane(geneSetSimilarityPanel.getHeatMapComponent());
        jScrollPane2.setBorder(null);
        this.mainComponent = new JPanel();
        UIManager.getDefaults().put("JideSplitPane.dividerSize", new Integer(9));
        LeadingEdgeAnalysis$3 leadingEdgeAnalysis$3 = new LeadingEdgeAnalysis$3(this, null, this.mainComponent);
        leadingEdgeAnalysis$3.setInitSplitPriority(0);
        leadingEdgeAnalysis$3.setShowWorkspace(false);
        leadingEdgeAnalysis$3.setRearrangable(false);
        leadingEdgeAnalysis$3.setAutohidable(false);
        leadingEdgeAnalysis$3.setFloatable(false);
        leadingEdgeAnalysis$3.setShowTitleBar(false);
        leadingEdgeAnalysis$3.getWorkspace().setAcceptDockableFrame(false);
        leadingEdgeAnalysis$3.setProportionalSplits(true);
        leadingEdgeAnalysis$3.beginLoadLayoutData();
        int n2 = frame.getWidth();
        int n3 = frame.getHeight();
        DockableFrame dockableFrame = new DockableFrame(LEADING_EDGE_MATRIX_KEY, JideIconsFactory.getImageIcon("jide/dockableframe_1.gif"));
        dockableFrame.getContentPane().add(jScrollPane);
        dockableFrame.setInitIndex(0);
        dockableFrame.setInitSide(1);
        dockableFrame.setPreferredSize(new Dimension(n2 / 2, n3 / 2));
        dockableFrame.setJMenuBar(this.leadingEdgePanel.getMenuBar());
        leadingEdgeAnalysis$3.addFrame(dockableFrame);
        dockableFrame = new DockableFrame(GENE_SET_SIMILARITY_MATRIX_KEY, JideIconsFactory.getImageIcon("jide/dockableframe_1.gif"));
        dockableFrame.getContentPane().add(jScrollPane2);
        dockableFrame.setInitIndex(1);
        dockableFrame.setInitSide(1);
        dockableFrame.setPreferredSize(new Dimension(n2 / 2, n3 / 2));
        dockableFrame.setJMenuBar(geneSetSimilarityPanel.getMenuBar());
        leadingEdgeAnalysis$3.addFrame(dockableFrame);
        dockableFrame = new DockableFrame(GENE_HISTOGRAM_KEY, JideIconsFactory.getImageIcon("jide/dockableframe_1.gif"));
        geneHistogram.setPreferredSize(new Dimension(100, 100));
        dockableFrame.getContentPane().add(new JScrollPane(geneHistogram));
        dockableFrame.setInitIndex(0);
        dockableFrame.setInitSide(2);
        dockableFrame.setPreferredSize(new Dimension(n2 / 2, n3 / 2));
        JFreeMenuBar jFreeMenuBar = new JFreeMenuBar(geneHistogram.getChartPanel(), frame);
        dockableFrame.setJMenuBar(jFreeMenuBar);
        leadingEdgeAnalysis$3.addFrame(dockableFrame);
        dockableFrame = new DockableFrame(JACQUARD_HISTOGRAM_KEY, JideIconsFactory.getImageIcon("jide/dockableframe_1.gif"));
        jacquardHistogram.setPreferredSize(new Dimension(100, 100));
        dockableFrame.getContentPane().add(new JScrollPane(jacquardHistogram));
        dockableFrame.setInitIndex(1);
        dockableFrame.setInitSide(2);
        dockableFrame.setPreferredSize(new Dimension(n2 / 2, n3 / 2));
        jFreeMenuBar = new JFreeMenuBar(jacquardHistogram.getChartPanel(), frame);
        dockableFrame.setJMenuBar(jFreeMenuBar);
        leadingEdgeAnalysis$3.addFrame(dockableFrame);
        leadingEdgeAnalysis$3.loadLayoutData();
    }

    private Border createBorder(String string) {
        return BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), string));
    }

    public final Component getComponent() {
        return this.mainComponent;
    }

    private JideSplitPane createSplitPane(int n) {
        JideSplitPane jideSplitPane = new JideSplitPane(n);
        jideSplitPane.setBorder(null);
        jideSplitPane.setProportionalLayout(true);
        return jideSplitPane;
    }

    public final void saveImage() {
    }

    public final void reset() {
    }

    public final void displayOptions() {
    }

    static final /* synthetic */ LeadingEdgePanel access$000(LeadingEdgeAnalysis leadingEdgeAnalysis) {
        return leadingEdgeAnalysis.leadingEdgePanel;
    }
}

