/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap.image;

import com.sun.media.jai.codec.BMPEncodeParam;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.PNGEncodeParam$RGB;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.media.jai.JAI;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.heatmap.RowColorScheme;
import org.genepattern.heatmap.image.DisplaySettings;
import org.genepattern.heatmap.image.FeatureAnnotator;
import org.genepattern.heatmap.image.HeatMap$1;
import org.genepattern.heatmap.image.HeatMap$2;
import org.genepattern.heatmap.image.HeatMap$HeatMapImage;
import org.genepattern.heatmap.image.HeatMapHeader;
import org.genepattern.heatmap.image.LinkGenerator;
import org.genepattern.heatmap.image.SampleAnnotator;

public class HeatMap {
    public static int LOG_SCALE = 0;
    public static int LINEAR_SCALE = 1;
    public static int COLOR_RESPONSE_ROW = 0;
    public static int COLOR_RESPONSE_GLOBAL = 1;
    String[] rowDescriptions;
    IExpressionData data;
    Dimension elementSize = new Dimension(10, 10);
    int contentWidth = 0;
    int height = 0;
    boolean antiAliasing = true;
    String fontFamilyName = "monospaced";
    int fontStyle = 0;
    private HeatMapHeader header;
    private int geneNameWidth;
    private int leftBorder = 0;
    private Font font;
    int maxGeneAnnotationsWidth = 0;
    int spaceAfterGeneNames = 10;
    private int annotationWidth = 6;
    private int numFeatureClasses;
    int numSampleClasses;
    private FeatureAnnotator featureAnnotator;
    SampleAnnotator sampleAnnotator;
    private int[] annotationWidths;
    DisplaySettings ds = new DisplaySettings();

    public HeatMap(IExpressionData iExpressionData, Color[] colorArray) {
        this.data = iExpressionData;
        this.rowDescriptions = new String[iExpressionData.getRowCount()];
        int n = iExpressionData.getRowCount();
        for (int i2 = 0; i2 < n; ++i2) {
            this.rowDescriptions[i2] = iExpressionData.getRowMetadata(i2, "description");
            if (this.rowDescriptions[i2] != null) continue;
            this.rowDescriptions[i2] = "";
        }
        this.header = new HeatMapHeader(this);
        this.ds.colorConverter = RowColorScheme.getRowInstance(colorArray);
    }

    public static final Color createColor(String string) {
        String[] stringArray = string.split(":");
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("Invalid rgb triplet " + string);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Red component is not an integer " + string);
        }
        try {
            n2 = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Green component is not an integer " + string);
        }
        try {
            n3 = Integer.parseInt(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Blue component is not an integer " + string);
        }
        return new Color(n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Color[] parseColorMap(String string) {
        BufferedReader bufferedReader = null;
        try {
            Color[] colorArray;
            bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = null;
            ArrayList<Color[]> arrayList = new ArrayList<Color[]>();
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().equals("")) continue;
                colorArray = HeatMap.createColor(string2);
                arrayList.add(colorArray);
            }
            colorArray = arrayList.toArray(new Color[0]);
            return colorArray;
        }
        catch (IOException iOException) {
            Color[] colorArray = null;
            return colorArray;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static final BufferedImage createImage(IExpressionData iExpressionData, DisplaySettings displaySettings, SampleAnnotator sampleAnnotator, FeatureAnnotator featureAnnotator) {
        HeatMap heatMap = HeatMap.createHeatMap(iExpressionData, displaySettings, featureAnnotator, sampleAnnotator);
        HeatMap.updateHeatMapSize(heatMap, "png");
        BufferedImage bufferedImage = heatMap.snapshot();
        return bufferedImage;
    }

    public static final String createHtmlImageMap(int n, int n2, HeatMap$HeatMapImage heatMap$HeatMapImage, DisplaySettings displaySettings, LinkGenerator linkGenerator) {
        int n3 = heatMap$HeatMapImage.leftBorder;
        int n4 = heatMap$HeatMapImage.headerHeight;
        int n5 = displaySettings.rowSize;
        int n6 = displaySettings.columnSize;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<map name=\"" + linkGenerator.getMapName() + "\">");
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n7 = i3 * n6 + n3;
                int n8 = i2 * n5 + n4;
                int n9 = n7 + n6;
                int n10 = n8 + n5;
                String string = linkGenerator.getUrl(i2, i3);
                stringBuffer.append("<area shape=\"rect\" coords=\"" + n7 + "," + n8 + "," + n9 + "," + n10 + "\" href=\"" + string + "\">");
            }
        }
        stringBuffer.append("</map>");
        return stringBuffer.toString();
    }

    public static final HeatMap$HeatMapImage createImage2(IExpressionData iExpressionData, DisplaySettings displaySettings, SampleAnnotator sampleAnnotator, FeatureAnnotator featureAnnotator) {
        HeatMap heatMap = HeatMap.createHeatMap(iExpressionData, displaySettings, featureAnnotator, sampleAnnotator);
        HeatMap.updateHeatMapSize(heatMap, "png");
        BufferedImage bufferedImage = heatMap.snapshot();
        HeatMap$HeatMapImage heatMap$HeatMapImage = new HeatMap$HeatMapImage();
        heatMap$HeatMapImage.image = bufferedImage;
        heatMap$HeatMapImage.headerHeight = heatMap.header.height;
        heatMap$HeatMapImage.leftBorder = heatMap.leftBorder;
        return heatMap$HeatMapImage;
    }

    private static HeatMap createHeatMap(IExpressionData iExpressionData, DisplaySettings displaySettings, FeatureAnnotator featureAnnotator, SampleAnnotator sampleAnnotator) {
        HeatMap heatMap = new HeatMap(iExpressionData, RowColorScheme.getDefaultColorMap());
        heatMap.setDisplaySettings(displaySettings);
        heatMap.setSampleAnnotator(sampleAnnotator);
        heatMap.setFeatureAnnotator(featureAnnotator);
        return heatMap;
    }

    private static void updateHeatMapSize(HeatMap heatMap, String string) {
        Graphics2D graphics2D = null;
        BufferedImage bufferedImage = new BufferedImage(100, 100, 5);
        graphics2D = bufferedImage.createGraphics();
        heatMap.updateSize(graphics2D);
        heatMap.header.updateSize(heatMap.contentWidth, heatMap.elementSize.width, graphics2D);
        graphics2D.dispose();
    }

    public static final void saveImage(IExpressionData iExpressionData, DisplaySettings displaySettings, Map map, Map map2, String string, String string2) {
        HeatMap.saveImage(iExpressionData, displaySettings, HeatMap.mapToFeatureAnnotator(map), HeatMap.mapToSampleAnnotator(map2), string, string2);
    }

    public static final void saveImage(IExpressionData iExpressionData, DisplaySettings displaySettings, FeatureAnnotator featureAnnotator, SampleAnnotator sampleAnnotator, String string, String string2) {
        HeatMap heatMap = HeatMap.createHeatMap(iExpressionData, displaySettings, featureAnnotator, sampleAnnotator);
        HeatMap.updateHeatMapSize(heatMap, string2);
        HeatMap.writeImageToFile(heatMap, string, string2);
    }

    private static SampleAnnotator mapToSampleAnnotator(Map map) {
        return new HeatMap$1(map);
    }

    private static FeatureAnnotator mapToFeatureAnnotator(Map map) {
        return new HeatMap$2(map);
    }

    private void setDisplaySettings(DisplaySettings displaySettings) {
        this.ds = displaySettings;
        this.setElementSize(displaySettings.rowSize, displaySettings.columnSize);
        this.header.drawSampleNames = displaySettings.drawColumnNames;
        displaySettings.colorConverter.setDataset(this.data);
    }

    private void setSampleAnnotator(SampleAnnotator sampleAnnotator) {
        this.sampleAnnotator = sampleAnnotator;
        if (this.sampleAnnotator != null) {
            for (int i2 = 0; i2 < this.data.getColumnCount(); ++i2) {
                List list = this.sampleAnnotator.getColors(this.data.getColumnName(i2));
                if (list == null) continue;
                this.numSampleClasses = Math.max(this.numSampleClasses, list.size());
            }
        }
    }

    private void setFeatureAnnotator(FeatureAnnotator featureAnnotator) {
        this.featureAnnotator = featureAnnotator;
        if (this.featureAnnotator != null) {
            for (int i2 = 0; i2 < this.data.getRowCount(); ++i2) {
                List list = this.featureAnnotator.getColors(this.data.getRowName(i2));
                if (list == null) continue;
                this.numFeatureClasses = Math.max(this.numFeatureClasses, list.size());
            }
        }
    }

    private static void writeImageToFile(HeatMap heatMap, String string, String string2) {
        if (string2.equals("jpeg")) {
            if (!string.toLowerCase().endsWith(".jpg") && !string.toLowerCase().endsWith(".jpeg")) {
                string = string + ".jpg";
            }
        } else if (string2.equals("png")) {
            if (!string.toLowerCase().endsWith(".png")) {
                string = string + ".png";
            }
        } else if (string2.equals("tiff")) {
            if (!string.toLowerCase().endsWith(".tiff")) {
                string = string + ".tiff";
            }
        } else if (string2.equals("bmp")) {
            if (!string.toLowerCase().endsWith(".bmp")) {
                string = string + ".bmp";
            }
        } else if (string2.equals("eps") && !string.toLowerCase().endsWith(".eps") && !string.toLowerCase().endsWith(".ps")) {
            string = string + ".eps";
        }
        ImageEncodeParam imageEncodeParam = null;
        if (string2.equals("jpeg")) {
            JPEGEncodeParam jPEGEncodeParam = new JPEGEncodeParam();
            jPEGEncodeParam.setQuality(1.0f);
            imageEncodeParam = jPEGEncodeParam;
        } else if (string2.equals("png")) {
            imageEncodeParam = new PNGEncodeParam$RGB();
        } else if (string2.equals("tiff")) {
            TIFFEncodeParam tIFFEncodeParam = new TIFFEncodeParam();
            tIFFEncodeParam.setCompression(1);
            imageEncodeParam = tIFFEncodeParam;
        } else if (string2.equals("bmp")) {
            imageEncodeParam = new BMPEncodeParam();
        } else {
            throw new IllegalArgumentException("Unknown output file format");
        }
        JAI.create("filestore", (RenderedImage)heatMap.snapshot(), (Object)string, (Object)string2, (Object)imageEncodeParam);
    }

    private final void draw(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        String string;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.data.getColumnCount();
        int n9 = 0;
        int n10 = n8;
        int n11 = 0;
        int n12 = this.data.getRowCount();
        for (n7 = n11; n7 < n12; ++n7) {
            for (n6 = n9; n6 < n10; ++n6) {
                int n13 = n6 * this.elementSize.width + this.leftBorder;
                n5 = n7 * this.elementSize.height;
                graphics2D.setColor(this.ds.colorConverter.getColor(n7, n6));
                graphics2D.fillRect(n13, n5, this.elementSize.width, this.elementSize.height);
            }
        }
        n7 = n8 * this.elementSize.width + 5;
        if (this.featureAnnotator != null) {
            for (n6 = 0; n6 < this.data.getRowCount(); ++n6) {
                List list = this.featureAnnotator.getColors(this.data.getRowName(n6));
                if (list == null) continue;
                for (n5 = 0; n5 < list.size(); ++n5) {
                    graphics2D.setColor((Color)list.get(n5));
                    graphics2D.fillRect(this.annotationWidth * n5 + n7 + this.leftBorder, n6 * this.elementSize.height, this.annotationWidth, this.elementSize.height);
                }
            }
        }
        if (this.antiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n14 = this.elementSize.width * n8 + 10;
        if (this.featureAnnotator != null) {
            n14 += this.annotationWidth * this.numFeatureClasses;
        }
        if ((this.ds.drawRowNames || this.ds.drawRowDescriptions) && n10 >= n8) {
            graphics2D.setColor(Color.black);
            for (n5 = n11; n5 < n12; ++n5) {
                n4 = n5 * this.elementSize.height + fontMetrics.getAscent();
                if (this.ds.drawRowNames) {
                    String string2 = this.data.getRowName(n5);
                    graphics2D.drawString(string2, n14 + this.leftBorder, n4);
                }
                if (!this.ds.drawRowDescriptions) continue;
                int n15 = n14 + this.leftBorder + this.geneNameWidth;
                if (this.ds.drawRowNames) {
                    n15 += this.spaceAfterGeneNames;
                }
                if ((string = this.rowDescriptions[n5]) == null) continue;
                graphics2D.drawString(string, n15, n4);
            }
        }
        if (this.featureAnnotator != null) {
            n5 = n14 + this.leftBorder;
            graphics2D.setColor(Color.BLACK);
            if (this.ds.drawRowNames) {
                n5 += this.geneNameWidth + this.spaceAfterGeneNames;
            }
            if (this.ds.drawRowDescriptions) {
                n5 += this.maxGeneAnnotationsWidth + this.spaceAfterGeneNames;
            }
            int n16 = this.data.getRowCount();
            for (n4 = 0; n4 < n16; ++n4) {
                string = this.data.getRowName(n4);
                n3 = n4 * this.elementSize.height + fontMetrics.getAscent();
                n2 = this.featureAnnotator.getColumnCount();
                for (n = 0; n < n2; ++n) {
                    String string3 = this.featureAnnotator.getAnnotation(string, n);
                    if (string3 == null) continue;
                    int n17 = n5 + 10 * n;
                    if (n > 0) {
                        n17 += this.annotationWidths[n - 1];
                    }
                    graphics2D.drawString(string3, n17, n3);
                }
            }
        }
        if (this.ds.drawGrid || this.ds.showFeatureGridLines || this.ds.showSampleGridLines) {
            graphics2D.setColor(this.ds.gridLinesColor);
            n5 = n9 * this.elementSize.width + this.leftBorder;
            n4 = n10 * this.elementSize.width + this.leftBorder;
            if (!this.ds.drawGrid && this.ds.showFeatureGridLines) {
                n5 = n4;
            }
            if (this.ds.showFeatureGridLines) {
                n4 = this.contentWidth;
            }
            if (this.ds.drawGrid || this.ds.showFeatureGridLines) {
                for (int i2 = n11; i2 <= n12; ++i2) {
                    int n18 = i2 * this.elementSize.height;
                    if (this.ds.upperTriangular) {
                        n3 = i2 * this.elementSize.width + this.leftBorder;
                        graphics2D.drawLine(n3, n18, n4, n18);
                        continue;
                    }
                    graphics2D.drawLine(n5, n18, n4, n18);
                }
            }
            int n19 = 0;
            int n20 = n12 * this.elementSize.height;
            if (this.ds.showSampleGridLines && this.ds.drawGrid) {
                graphics2D.translate(0, -this.header.height);
                n20 = this.height + this.header.height;
            } else if (this.ds.showSampleGridLines && !this.ds.drawGrid) {
                graphics2D.translate(0, -this.header.height);
                n20 = this.header.height;
            }
            if (this.ds.drawGrid || this.ds.showSampleGridLines) {
                for (n3 = n9; n3 <= n10; ++n3) {
                    n = n3 * this.elementSize.width + this.leftBorder;
                    if (this.ds.upperTriangular) {
                        n2 = this.elementSize.height * n3;
                        graphics2D.drawLine(n, n19, n, n2);
                        continue;
                    }
                    graphics2D.drawLine(n, n19, n, n20);
                }
            }
        }
    }

    public final BufferedImage snapshot() {
        int n = this.header.height;
        BufferedImage bufferedImage = new BufferedImage(this.contentWidth, this.height + n, 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setColor(Color.black);
        graphics2D.setFont(this.header.font);
        this.header.draw(graphics2D);
        graphics2D.translate(0, n);
        graphics2D.setFont(this.font);
        this.draw(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    private final void updateSize(Graphics2D graphics2D) {
        int n = Math.min(14, this.elementSize.height);
        this.font = new Font(this.fontFamilyName, this.fontStyle, n);
        graphics2D.setFont(this.font);
        int n2 = this.elementSize.width * this.data.getColumnCount() + 1 + this.leftBorder;
        if (this.ds.drawRowNames) {
            this.geneNameWidth = this.getMaxGeneNamesWidth(graphics2D);
            n2 += 20 + this.geneNameWidth;
        }
        if (this.ds.drawRowDescriptions) {
            this.maxGeneAnnotationsWidth = this.getMaxGeneDescriptionsWidth(graphics2D);
            if (this.ds.drawRowNames) {
                n2 += this.spaceAfterGeneNames;
            }
            n2 += this.maxGeneAnnotationsWidth;
        }
        if (this.featureAnnotator != null) {
            n2 += this.annotationWidth * this.numFeatureClasses;
            this.annotationWidths = this.getAnnotationsWidth(graphics2D);
            for (int i2 = 0; i2 < this.annotationWidths.length; ++i2) {
                n2 += this.annotationWidths[i2] + 10;
            }
        }
        this.contentWidth = n2;
        this.height = this.elementSize.height * this.data.getRowCount() + 1;
        if (!this.ds.drawHeatMapElements) {
            this.height = 0;
        }
    }

    private int[] getAnnotationsWidth(Graphics2D graphics2D) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int[] nArray = new int[this.featureAnnotator.getColumnCount()];
        int n = this.data.getRowCount();
        for (int i2 = 0; i2 < n; ++i2) {
            String string = this.data.getRowName(i2);
            int n2 = this.featureAnnotator.getColumnCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                String string2 = this.featureAnnotator.getAnnotation(string, i3);
                if (string2 == null) continue;
                nArray[i3] = Math.max(nArray[i3], fontMetrics.stringWidth(string2));
            }
        }
        return nArray;
    }

    public final void setShowSampleNames(boolean bl) {
        this.header.setShowSampleNames(bl);
    }

    public final void setShowGeneNames(boolean bl) {
        this.ds.drawRowNames = bl;
    }

    public final void setElementSize(int n, int n2) {
        this.elementSize.width = n;
        this.elementSize.height = n2;
    }

    public final void setShowGridLines(boolean bl) {
        this.ds.showFeatureGridLines = bl;
    }

    public final void setGridLinesColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Grid lines color can not be null.");
        }
        this.ds.gridLinesColor = color;
    }

    private final int getMaxGeneNamesWidth(Graphics2D graphics2D) {
        return this.getMaxWidth(graphics2D, true);
    }

    private final int getMaxGeneDescriptionsWidth(Graphics2D graphics2D) {
        return this.getMaxWidth(graphics2D, false);
    }

    private final int getMaxWidth(Graphics2D graphics2D, boolean bl) {
        if (graphics2D == null) {
            return 0;
        }
        if (this.antiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = 0;
        for (int i2 = 0; i2 < this.data.getRowCount(); ++i2) {
            String string = bl ? this.data.getRowName(i2) : this.rowDescriptions[i2];
            if (string == null) continue;
            n = Math.max(n, fontMetrics.stringWidth(string));
        }
        return n;
    }

    private final int getTopIndex(int n) {
        if (n < 0) {
            return 0;
        }
        return n / this.elementSize.height;
    }

    private final int getLeftIndex(int n) {
        if (n < this.leftBorder) {
            return 0;
        }
        return (n - this.leftBorder) / this.elementSize.width;
    }

    private final int getRightIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n / this.elementSize.width + 1;
        return n3 > n2 ? n2 : n3;
    }

    private final int getBottomIndex(int n, int n2) {
        if (n < 0) {
            return 0;
        }
        int n3 = n / this.elementSize.height + 1;
        return n3 > n2 ? n2 : n3;
    }

    public final int getLeftBorder() {
        return this.leftBorder;
    }

    public final void setLeftBorder(int n) {
        this.leftBorder = n;
    }
}

