/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.genepattern.io.OdfWriter$Header;
import org.genepattern.io.OdfWriter$HeaderArray;

public class OdfWriter
extends PrintWriter {
    private static final String TASKLOG = "gp_task_execution_log.txt";
    private String[] columnNames;
    private List headers;
    private String model;
    private int dataLines;
    private String[] columnTypes;

    public OdfWriter(String string, String[] stringArray, String string2, int n, boolean bl) {
        super(new FileWriter(OdfWriter.fixName(string)));
        if (bl) {
            OdfWriter.appendExecutionLog(this);
        }
        this.columnNames = stringArray;
        this.model = string2;
        this.dataLines = n;
        this.headers = new ArrayList();
    }

    private static String fixName(String string) {
        if (!string.toLowerCase().endsWith(".odf")) {
            string = string + ".odf";
        }
        return string;
    }

    public final void addHeader(String string, String string2) {
        this.headers.add(new OdfWriter$Header(string, string2));
    }

    public final void addHeader(String string, int n) {
        this.headers.add(new OdfWriter$Header(string, String.valueOf(n)));
    }

    public final void addHeader(String string, double d2) {
        this.headers.add(new OdfWriter$Header(string, String.valueOf(d2)));
    }

    public final void addHeader(String string, String[] stringArray) {
        this.headers.add(new OdfWriter$HeaderArray(string, stringArray));
    }

    public final void eprintln(String string) {
        if (string.charAt(0) == '#') {
            string = "\\" + string;
        }
        this.println(string);
    }

    private void printArray(String string, String[] stringArray) {
        this.print(string + ":");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                this.print("\t");
            }
            this.print(stringArray[i2]);
        }
        this.println();
    }

    public final void printHeader() {
        this.println("ODF 1.0");
        int n = this.headers.size() + 2;
        if (this.columnNames != null && this.columnNames.length > 0) {
            ++n;
        }
        if (this.columnTypes != null && this.columnTypes.length > 0) {
            ++n;
        }
        this.println("HeaderLines=" + n);
        if (this.columnNames != null && this.columnNames.length > 0) {
            this.printArray("COLUMN_NAMES", this.columnNames);
        }
        if (this.columnTypes != null && this.columnTypes.length > 0) {
            this.printArray("COLUMN_TYPES", this.columnTypes);
        }
        this.println("Model=" + this.model);
        int n2 = this.headers.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            Object e2 = this.headers.get(i2);
            if (e2 instanceof OdfWriter$Header) {
                object = (OdfWriter$Header)e2;
                this.print(((OdfWriter$Header)object).key);
                this.print("=");
                this.println(((OdfWriter$Header)object).value);
                continue;
            }
            object = (OdfWriter$HeaderArray)e2;
            this.printArray(((OdfWriter$HeaderArray)object).key, ((OdfWriter$HeaderArray)object).value);
        }
        this.println("DataLines=" + this.dataLines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void appendExecutionLog(PrintWriter printWriter) {
        if (new File(TASKLOG).exists()) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(TASKLOG));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    printWriter.println(string);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public final void setColumnTypes(String[] stringArray) {
        this.columnTypes = stringArray;
    }
}

