/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io.expr.odf;

import org.genepattern.io.IOdfHandler;
import org.genepattern.io.ParseException;
import org.genepattern.io.expr.odf.OdfParserAdapter;
import org.genepattern.io.expr.odf.OdfParserAdapter$EndParseException;

class OdfParserAdapter$MyHandler
implements IOdfHandler {
    boolean testOnly = false;
    String[] rowNames;
    String[] columnNames;
    String[] rowDescriptions;
    String[] columnDescriptions;
    String[] columnTypes;
    int rowNamesColumn = -1;
    int rowDescriptionsColumn = -1;
    int rows;
    int columns;
    int dataOffset;
    boolean rowNamesColumnSpecified = false;
    boolean rowDescriptionsColumnSpecified = false;
    final /* synthetic */ OdfParserAdapter this$0;

    OdfParserAdapter$MyHandler(OdfParserAdapter odfParserAdapter) {
        this.this$0 = odfParserAdapter;
    }

    @Override
    public final void data(int n, int n2, String string) {
        if (n2 == this.rowNamesColumn) {
            if (this.this$0.expressionHandler != null) {
                this.this$0.expressionHandler.rowName(n, string);
            }
        } else if (n2 == this.rowDescriptionsColumn) {
            if (this.this$0.expressionHandler != null) {
                this.this$0.expressionHandler.rowMetaData(n, 0, string);
            }
        } else {
            try {
                if (this.this$0.expressionHandler != null) {
                    this.this$0.expressionHandler.data(n, n2 - this.dataOffset, Double.parseDouble(string));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Data at row " + n + " and column " + n2 + " is not a number.");
            }
        }
    }

    @Override
    public final void endHeader() {
        int n;
        int n2;
        if (this.rowNamesColumnSpecified && this.rowNames != null) {
            throw new ParseException("Row names specifed in header and in data block.");
        }
        if (this.rowDescriptionsColumnSpecified && this.rowDescriptions != null) {
            throw new ParseException("Row descriptions specifed in header and in data block.");
        }
        if (this.rowNames == null) {
            this.rowNames = new String[this.rows];
        }
        if (this.rowDescriptions == null) {
            this.rowDescriptions = new String[this.rows];
        }
        if (this.columnNames == null) {
            throw new ParseException("No column names found.");
        }
        if (this.columnDescriptions == null) {
            throw new ParseException("No column descriptions found.");
        }
        if (this.columnTypes == null) {
            throw new ParseException("No column types found.");
        }
        if (this.columnNames.length != this.columnDescriptions.length) {
            String[] stringArray = new String[this.columnNames.length];
            n2 = Math.min(this.columnNames.length, this.columnDescriptions.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                stringArray[i2] = this.columnDescriptions[i2];
            }
            this.columnDescriptions = stringArray;
        }
        if (this.columnNames.length != this.columnTypes.length) {
            throw new ParseException("Length of column names is not equal to the length of column types.");
        }
        if (!this.rowDescriptionsColumnSpecified && this.rowDescriptions == null) {
            throw new ParseException("No row descriptions found.");
        }
        if (!this.rowNamesColumnSpecified && this.rowNames == null) {
            throw new ParseException("No row names found.");
        }
        if (this.rowNamesColumnSpecified && !this.columnTypes[0].equals("String")) {
            throw new ParseException("0th column type must be String.");
        }
        if (this.rowDescriptionsColumnSpecified && !this.columnTypes[1].equals("String")) {
            throw new ParseException("1st column type must be String.");
        }
        if (this.rowNamesColumnSpecified && this.rowNamesColumn != 0) {
            throw new ParseException("RowNamesColumn must be column 0.");
        }
        if (this.rowDescriptionsColumnSpecified && this.rowDescriptionsColumn != 1) {
            throw new ParseException("RowNamesColumn must be column 1.");
        }
        if (this.rowNamesColumnSpecified) {
            ++this.dataOffset;
        }
        if (this.rowDescriptionsColumnSpecified) {
            ++this.dataOffset;
        }
        for (n = this.dataOffset; n < this.columnTypes.length; ++n) {
            if (this.columnTypes[n].equals("float")) continue;
            throw new ParseException("The column type of column " + n + " must be float.");
        }
        this.columns = this.columnNames.length;
        if (this.rowNamesColumn > 0) {
            throw new ParseException("Row names column must be 0th column.");
        }
        n = this.columns - this.dataOffset;
        if (this.this$0.expressionHandler != null) {
            String[] stringArray;
            if (this.rowDescriptionsColumnSpecified) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "description";
            } else {
                stringArray = new String[]{};
            }
            String[] stringArray3 = stringArray;
            this.this$0.expressionHandler.init(this.rows, n, stringArray3, new String[]{"description"}, new String[0]);
        }
        if (this.this$0.expressionHandler != null) {
            for (n2 = 0; n2 < n; ++n2) {
                this.this$0.expressionHandler.columnName(n2, this.columnNames[n2 + this.dataOffset]);
                if (this.columnDescriptions != null) {
                    this.this$0.expressionHandler.columnMetaData(n2, 0, this.columnDescriptions[n2 + this.dataOffset]);
                    continue;
                }
                this.this$0.expressionHandler.columnMetaData(n2, 0, "");
            }
        }
    }

    @Override
    public final void header(String string, String[] stringArray) {
        if (string.equalsIgnoreCase("COLUMN_NAMES")) {
            this.columnNames = stringArray;
        } else if (string.equalsIgnoreCase("ROW_NAMES")) {
            this.rowNames = stringArray;
        } else if (string.equalsIgnoreCase("ROW_DESCRIPTIONS")) {
            this.rowDescriptions = stringArray;
        } else if (string.equalsIgnoreCase("COLUMN_DESCRIPTIONS")) {
            this.columnDescriptions = stringArray;
        } else if (string.equalsIgnoreCase("COLUMN_TYPES")) {
            this.columnTypes = stringArray;
        } else {
            throw new ParseException("Unknown header " + string);
        }
    }

    @Override
    public final void header(String string, String string2) {
        if (string.equalsIgnoreCase("DataLines")) {
            this.rows = Integer.parseInt(string2);
        } else if (string.equalsIgnoreCase("Model")) {
            if (!string2.equalsIgnoreCase("Dataset")) {
                throw new ParseException("Expecting an odf file with Model=Dataset.");
            }
            if (this.testOnly) {
                throw new OdfParserAdapter$EndParseException();
            }
        } else if (string.equalsIgnoreCase("RowNamesColumn")) {
            this.rowNamesColumn = this.parsePositiveInt(string, string2);
            this.rowNamesColumnSpecified = true;
        } else if (string.equalsIgnoreCase("RowDescriptionsColumn")) {
            this.rowDescriptionsColumn = this.parsePositiveInt(string, string2);
            this.rowDescriptionsColumnSpecified = true;
        } else {
            throw new ParseException("Unknown header " + string);
        }
    }

    private int parsePositiveInt(String string, String string2) {
        try {
            int n = Integer.parseInt(string2);
            if (n < 0) {
                throw new ParseException(string + " must be >= 0.");
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(string + " keyword is not an integer.");
        }
    }
}

