/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.plot;

import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.menu.jfree.JFreeMenuBar;
import org.genepattern.menu.jfree.JFreeUtil;
import org.genepattern.plot.ProfilePlot$1;
import org.genepattern.uiutil.CenteredDialog;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ProfilePlot {
    IExpressionData expressionData;
    JFreeChart chart;
    ChartPanel chartPanel;
    JDialog dialog;

    public ProfilePlot(Frame frame, IExpressionData iExpressionData) {
        this.expressionData = iExpressionData;
        this.chart = ChartFactory.createScatterPlot("", "Column", "Value", null, PlotOrientation.VERTICAL, false, false, false);
        this.chartPanel = new ChartPanel(this.chart, false, false, false, false, false);
        this.chartPanel.setMouseZoomable(true, false);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)this.chart.getXYPlot().getRenderer();
        xYLineAndShapeRenderer.setLinesVisible(true);
        String[] stringArray = new String[iExpressionData.getColumnCount()];
        int n = iExpressionData.getColumnCount();
        for (int i2 = 0; i2 < n; ++i2) {
            stringArray[i2] = iExpressionData.getColumnName(i2);
        }
        SymbolAxis symbolAxis = new SymbolAxis("Column", stringArray);
        symbolAxis.setVerticalTickLabels(true);
        this.chart.getXYPlot().setDomainAxis(symbolAxis);
        this.dialog = new CenteredDialog(frame);
        this.dialog.setTitle("Profile");
        this.dialog.getContentPane().add(this.chartPanel);
        this.dialog.setJMenuBar(new JFreeMenuBar(this.chartPanel, frame));
    }

    public final void plot(String[] stringArray) {
        int[] nArray = null;
        if (stringArray != null) {
            nArray = new int[stringArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = this.expressionData.getRowIndex(stringArray[i2]);
                if (nArray[i2] != -1) continue;
                throw new IllegalArgumentException("Feature " + stringArray[i2] + " was not found in the loaded dataset.");
            }
        }
        this.plot(nArray);
    }

    public final void plot(int[] nArray) {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        int n = nArray != null ? nArray.length : this.expressionData.getRowCount();
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = nArray != null ? nArray[i2] : i2;
            XYSeries xYSeries = new XYSeries((Comparable)((Object)this.expressionData.getRowName(n2)));
            for (int i3 = 0; i3 < this.expressionData.getColumnCount(); ++i3) {
                xYSeries.add((double)i3, this.expressionData.getValue(n2, i3));
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        this.chart.getXYPlot().setDataset(xYSeriesCollection);
        if (nArray != null && nArray.length <= 5) {
            JFreeUtil.createLegend(this.chart);
        } else {
            this.chart.clearSubtitles();
        }
        ProfilePlot$1 profilePlot$1 = new ProfilePlot$1(this);
        if (SwingUtilities.isEventDispatchThread()) {
            ((Thread)profilePlot$1).run();
        } else {
            SwingUtilities.invokeLater(profilePlot$1);
        }
    }
}

