/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.uiutil;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class FileChooser {
    static JFileChooser fileChooser;
    public static boolean RUNNING_ON_MAC;

    private FileChooser() {
    }

    private static File showFileDialog(Frame frame, int n, File file, String string) {
        string = string == null ? "GenePattern" : "GenePattern - " + string;
        FileDialog fileDialog = new FileDialog(frame, string, n);
        if (file != null) {
            fileDialog.setDirectory(file.getPath());
            fileDialog.setFile(file.getName());
        }
        fileDialog.setModal(true);
        fileDialog.setVisible(true);
        String string2 = fileDialog.getFile();
        String string3 = fileDialog.getDirectory();
        if (string2 != null) {
            File file2 = new File(string3, string2);
            return file2;
        }
        return null;
    }

    public static final File showOpenDialog(Frame frame) {
        return FileChooser.showOpenDialog(frame, null);
    }

    public static final File showOpenDialog(Frame frame, String string) {
        if (RUNNING_ON_MAC) {
            return FileChooser.showFileDialog(frame, 0, null, string);
        }
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        fileChooser.setDialogTitle(string);
        if (fileChooser.showOpenDialog(frame) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public static final File showSaveDialog(Frame frame) {
        return FileChooser.showSaveDialog(frame, null);
    }

    public static final File showSaveDialog(Frame frame, File file) {
        if (RUNNING_ON_MAC) {
            return FileChooser.showFileDialog(frame, 1, file, "GenePattern");
        }
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
        }
        fileChooser.setSelectedFile(file);
        if (fileChooser.showSaveDialog(frame) == 0) {
            File file2 = fileChooser.getSelectedFile();
            if (!FileChooser.overwriteFile(frame, file2)) {
                return null;
            }
            return file2;
        }
        return null;
    }

    public static final boolean overwriteFile(Component component, File file) {
        if (!file.exists()) {
            return true;
        }
        String string = "An item named " + file.getName() + " already exists in this location.\nDo you want to replace it with the one that you are saving?";
        return JOptionPane.showOptionDialog(component, string, null, 0, 2, null, new Object[]{"Replace", "Cancel"}, "Cancel") == 0;
    }

    static {
        RUNNING_ON_MAC = System.getProperty("mrj.version") != null && UIManager.getSystemLookAndFeelClassName().equals(UIManager.getLookAndFeel().getClass().getName());
    }
}

