/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.JaxenHandler;
import org.jaxen.NamespaceContext;
import org.jaxen.Navigator;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.jaxen.XPathFunctionContext;
import org.jaxen.XPathSyntaxException;
import org.jaxen.expr.Expr;
import org.jaxen.expr.XPathExpr;
import org.jaxen.function.BooleanFunction;
import org.jaxen.function.NumberFunction;
import org.jaxen.function.StringFunction;
import org.saxpath.SAXPathException;
import org.saxpath.XPathReader;
import org.saxpath.helpers.XPathReaderFactory;

public class BaseXPath
implements XPath,
Serializable {
    private XPathExpr xpath;
    private ContextSupport support;
    private Navigator navigator;

    protected BaseXPath(String string) {
        try {
            XPathReader xPathReader = XPathReaderFactory.createReader();
            JaxenHandler jaxenHandler = new JaxenHandler();
            xPathReader.setXPathHandler(jaxenHandler);
            xPathReader.parse(string);
            this.xpath = jaxenHandler.getXPathExpr();
        }
        catch (org.saxpath.XPathSyntaxException xPathSyntaxException) {
            throw new XPathSyntaxException(xPathSyntaxException.getXPath(), xPathSyntaxException.getPosition(), xPathSyntaxException.getMessage());
        }
        catch (SAXPathException sAXPathException) {
            throw new JaxenException(sAXPathException);
        }
    }

    public BaseXPath(String string, Navigator navigator) {
        this(string);
        this.navigator = navigator;
    }

    public void addNamespace(String string, String string2) {
        NamespaceContext namespaceContext = this.getNamespaceContext();
        if (namespaceContext instanceof SimpleNamespaceContext) {
            ((SimpleNamespaceContext)namespaceContext).addNamespace(string, string2);
            return;
        }
        throw new JaxenException("Operation not permitted while using a custom namespace context.");
    }

    public boolean booleanValueOf(Object object) {
        Context context = this.getContext(object);
        List list = this.selectNodesForContext(context);
        if (list == null) {
            return false;
        }
        return BooleanFunction.evaluate(list, context.getNavigator());
    }

    protected FunctionContext createFunctionContext() {
        return XPathFunctionContext.getInstance();
    }

    protected NamespaceContext createNamespaceContext() {
        return new SimpleNamespaceContext();
    }

    protected VariableContext createVariableContext() {
        return new SimpleVariableContext();
    }

    public String debug() {
        return this.xpath.toString();
    }

    public Object evaluate(Object object) {
        Object e2;
        List list = this.selectNodes(object);
        if (list != null && list.size() == 1 && ((e2 = list.get(0)) instanceof String || e2 instanceof Number || e2 instanceof Boolean)) {
            return e2;
        }
        return list;
    }

    protected Context getContext(Object object) {
        if (object instanceof Context) {
            return (Context)object;
        }
        Context context = new Context(this.getContextSupport());
        if (object instanceof List) {
            context.setNodeSet((List)object);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(object);
            context.setNodeSet(arrayList);
        }
        return context;
    }

    protected ContextSupport getContextSupport() {
        if (this.support == null) {
            this.support = new ContextSupport(this.createNamespaceContext(), this.createFunctionContext(), this.createVariableContext(), this.getNavigator());
        }
        return this.support;
    }

    public FunctionContext getFunctionContext() {
        FunctionContext functionContext = this.getContextSupport().getFunctionContext();
        if (functionContext == null) {
            functionContext = this.createFunctionContext();
            this.getContextSupport().setFunctionContext(functionContext);
        }
        return functionContext;
    }

    public NamespaceContext getNamespaceContext() {
        NamespaceContext namespaceContext = this.getContextSupport().getNamespaceContext();
        if (namespaceContext == null) {
            namespaceContext = this.createNamespaceContext();
            this.getContextSupport().setNamespaceContext(namespaceContext);
        }
        return namespaceContext;
    }

    public Navigator getNavigator() {
        return this.navigator;
    }

    public Expr getRootExpr() {
        return this.xpath.getRootExpr();
    }

    public VariableContext getVariableContext() {
        VariableContext variableContext = this.getContextSupport().getVariableContext();
        if (variableContext == null) {
            variableContext = this.createVariableContext();
            this.getContextSupport().setVariableContext(variableContext);
        }
        return variableContext;
    }

    public Number numberValueOf(Object object) {
        Context context = this.getContext(object);
        Object object2 = this.selectSingleNodeForContext(context);
        if (object2 == null) {
            return null;
        }
        return NumberFunction.evaluate(object2, context.getNavigator());
    }

    public List selectNodes(Object object) {
        Context context = this.getContext(object);
        return this.selectNodesForContext(context);
    }

    protected List selectNodesForContext(Context context) {
        return this.xpath.asList(context);
    }

    public Object selectSingleNode(Object object) {
        List list = this.selectNodes(object);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    protected Object selectSingleNodeForContext(Context context) {
        List list = this.selectNodesForContext(context);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public void setFunctionContext(FunctionContext functionContext) {
        this.getContextSupport().setFunctionContext(functionContext);
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.getContextSupport().setNamespaceContext(namespaceContext);
    }

    public void setVariableContext(VariableContext variableContext) {
        this.getContextSupport().setVariableContext(variableContext);
    }

    public String stringValueOf(Object object) {
        Context context = this.getContext(object);
        Object object2 = this.selectSingleNodeForContext(context);
        if (object2 == null) {
            return "";
        }
        return StringFunction.evaluate(object2, context.getNavigator());
    }

    public String toString() {
        return this.xpath.getText();
    }

    public String valueOf(Object object) {
        return this.stringValueOf(object);
    }
}

