/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jaxen.Navigator;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.util.DescendantOrSelfAxisIterator;

public class FollowingAxisIterator
implements Iterator {
    private static final Iterator EMPTY_ITERATOR = Collections.EMPTY_LIST.iterator();
    private Object contextNode;
    private Navigator navigator;
    private Iterator siblings;
    private Iterator currentSibling;

    public FollowingAxisIterator(Object object, Navigator navigator) {
        this.contextNode = object;
        this.navigator = navigator;
        this.siblings = navigator.getFollowingSiblingAxisIterator(object);
        this.currentSibling = EMPTY_ITERATOR;
    }

    private boolean goForward() {
        while (!this.siblings.hasNext()) {
            if (this.goUp()) continue;
            return false;
        }
        Object e2 = this.siblings.next();
        this.currentSibling = new DescendantOrSelfAxisIterator(e2, this.navigator);
        return true;
    }

    private boolean goUp() {
        if (this.contextNode == null || this.navigator.isDocument(this.contextNode)) {
            return false;
        }
        try {
            this.contextNode = this.navigator.getParentNode(this.contextNode);
            if (this.contextNode != null && !this.navigator.isDocument(this.contextNode)) {
                this.siblings = this.navigator.getFollowingSiblingAxisIterator(this.contextNode);
                return true;
            }
            return false;
        }
        catch (UnsupportedAxisException unsupportedAxisException) {
            return false;
        }
    }

    public final boolean hasNext() {
        while (!this.currentSibling.hasNext()) {
            if (this.goForward()) continue;
            return false;
        }
        return true;
    }

    public final Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentSibling.next();
    }

    public final void remove() {
        throw new UnsupportedOperationException();
    }
}

