/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.modules;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.jfree.base.modules.AbstractModule$ReaderHelper;
import org.jfree.base.modules.DefaultModuleInfo;
import org.jfree.base.modules.Module;
import org.jfree.base.modules.ModuleInfo;
import org.jfree.base.modules.ModuleInitializeException;
import org.jfree.base.modules.ModuleInitializer;
import org.jfree.base.modules.SubSystem;
import org.jfree.util.ObjectUtilities;

public abstract class AbstractModule
extends DefaultModuleInfo
implements Module {
    private ModuleInfo[] requiredModules;
    private ModuleInfo[] optionalModules;
    private String name;
    private String description;
    private String producer;
    private String subsystem;

    public AbstractModule() {
        this.setModuleClass(this.getClass().getName());
    }

    public void configure(SubSystem subSystem) {
        InputStream inputStream = ObjectUtilities.getResourceRelativeAsStream("configuration.properties", this.getClass());
        if (inputStream == null) {
            return;
        }
        subSystem.getPackageManager().getPackageConfiguration().load(inputStream);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public ModuleInfo[] getOptionalModules() {
        ModuleInfo[] moduleInfoArray = new ModuleInfo[this.optionalModules.length];
        System.arraycopy(this.optionalModules, 0, moduleInfoArray, 0, this.optionalModules.length);
        return moduleInfoArray;
    }

    public String getProducer() {
        return this.producer;
    }

    public ModuleInfo[] getRequiredModules() {
        ModuleInfo[] moduleInfoArray = new ModuleInfo[this.requiredModules.length];
        System.arraycopy(this.requiredModules, 0, moduleInfoArray, 0, this.requiredModules.length);
        return moduleInfoArray;
    }

    public String getSubSystem() {
        if (this.subsystem == null) {
            return this.getName();
        }
        return this.subsystem;
    }

    public abstract void initialize(SubSystem var1);

    protected static final boolean isClassLoadable(String string) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isNextLineValueLine(AbstractModule$ReaderHelper abstractModule$ReaderHelper) {
        if (!abstractModule$ReaderHelper.hasNext()) {
            return false;
        }
        String string = abstractModule$ReaderHelper.next();
        if (string == null) {
            return false;
        }
        if (this.parseKey(string) != null) {
            abstractModule$ReaderHelper.pushBack(string);
            return false;
        }
        abstractModule$ReaderHelper.pushBack(string);
        return true;
    }

    protected final void loadModuleInfo() {
        InputStream inputStream = ObjectUtilities.getResourceRelativeAsStream("module.properties", this.getClass());
        if (inputStream == null) {
            throw new ModuleInitializeException("File 'module.properties' not found in module package.");
        }
        this.loadModuleInfo(inputStream);
    }

    protected final void loadModuleInfo(InputStream inputStream) {
        try {
            if (inputStream == null) {
                throw new NullPointerException("Given InputStream is null.");
            }
            AbstractModule$ReaderHelper abstractModule$ReaderHelper = new AbstractModule$ReaderHelper(new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1")));
            ArrayList<DefaultModuleInfo> arrayList = new ArrayList<DefaultModuleInfo>();
            ArrayList<DefaultModuleInfo> arrayList2 = new ArrayList<DefaultModuleInfo>();
            while (abstractModule$ReaderHelper.hasNext()) {
                String string = abstractModule$ReaderHelper.next();
                if (string.startsWith("module-info:")) {
                    this.readModuleInfo(abstractModule$ReaderHelper);
                    continue;
                }
                if (string.startsWith("depends:")) {
                    arrayList2.add(this.readExternalModule(abstractModule$ReaderHelper));
                    continue;
                }
                if (!string.startsWith("optional:")) continue;
                arrayList.add(this.readExternalModule(abstractModule$ReaderHelper));
            }
            abstractModule$ReaderHelper.close();
            this.optionalModules = arrayList.toArray(new ModuleInfo[arrayList.size()]);
            this.requiredModules = arrayList2.toArray(new ModuleInfo[arrayList2.size()]);
        }
        catch (IOException iOException) {
            throw new ModuleInitializeException("Failed to load properties", iOException);
        }
    }

    private String parseKey(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    private String parseValue(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        if (n + 1 == string.length()) {
            return "";
        }
        return string.substring(n + 1);
    }

    protected final void performExternalInitialize(String string) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
            ModuleInitializer moduleInitializer = (ModuleInitializer)clazz.newInstance();
            moduleInitializer.performInit();
        }
        catch (ModuleInitializeException moduleInitializeException) {
            throw moduleInitializeException;
        }
        catch (Exception exception) {
            throw new ModuleInitializeException("Failed to load specified initializer class.", exception);
        }
    }

    private DefaultModuleInfo readExternalModule(AbstractModule$ReaderHelper abstractModule$ReaderHelper) {
        DefaultModuleInfo defaultModuleInfo = new DefaultModuleInfo();
        while (abstractModule$ReaderHelper.hasNext()) {
            String string = abstractModule$ReaderHelper.next();
            if (!Character.isWhitespace(string.charAt(0))) {
                abstractModule$ReaderHelper.pushBack(string);
                return defaultModuleInfo;
            }
            String string2 = string.trim();
            String string3 = this.parseKey(string2);
            if (string3 == null) continue;
            String string4 = this.readValue(abstractModule$ReaderHelper, this.parseValue(string2));
            if (string3.equals("module")) {
                defaultModuleInfo.setModuleClass(string4);
                continue;
            }
            if (string3.equals("version.major")) {
                defaultModuleInfo.setMajorVersion(string4);
                continue;
            }
            if (string3.equals("version.minor")) {
                defaultModuleInfo.setMinorVersion(string4);
                continue;
            }
            if (!string3.equals("version.patchlevel")) continue;
            defaultModuleInfo.setPatchLevel(string4);
        }
        return defaultModuleInfo;
    }

    private void readModuleInfo(AbstractModule$ReaderHelper abstractModule$ReaderHelper) {
        while (abstractModule$ReaderHelper.hasNext()) {
            String string = abstractModule$ReaderHelper.next();
            if (!Character.isWhitespace(string.charAt(0))) {
                abstractModule$ReaderHelper.pushBack(string);
                return;
            }
            String string2 = string.trim();
            String string3 = this.parseKey(string2);
            if (string3 == null) continue;
            String string4 = this.readValue(abstractModule$ReaderHelper, this.parseValue(string2.trim()));
            if (string3.equals("name")) {
                this.setName(string4);
                continue;
            }
            if (string3.equals("producer")) {
                this.setProducer(string4);
                continue;
            }
            if (string3.equals("description")) {
                this.setDescription(string4);
                continue;
            }
            if (string3.equals("subsystem")) {
                this.setSubSystem(string4);
                continue;
            }
            if (string3.equals("version.major")) {
                this.setMajorVersion(string4);
                continue;
            }
            if (string3.equals("version.minor")) {
                this.setMinorVersion(string4);
                continue;
            }
            if (!string3.equals("version.patchlevel")) continue;
            this.setPatchLevel(string4);
        }
    }

    private String readValue(AbstractModule$ReaderHelper abstractModule$ReaderHelper, String string) {
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        boolean bl = true;
        while (this.isNextLineValueLine(abstractModule$ReaderHelper)) {
            string = abstractModule$ReaderHelper.next();
            String string2 = string.trim();
            if (string2.length() == 0 && !bl) {
                stringBuffer.append("\n");
                bl = true;
                continue;
            }
            if (!bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.parseValue(string2));
            bl = false;
        }
        return stringBuffer.toString();
    }

    protected final void setDescription(String string) {
        this.description = string;
    }

    protected final void setName(String string) {
        this.name = string;
    }

    public final void setOptionalModules(ModuleInfo[] moduleInfoArray) {
        this.optionalModules = new ModuleInfo[moduleInfoArray.length];
        System.arraycopy(moduleInfoArray, 0, this.optionalModules, 0, moduleInfoArray.length);
    }

    protected final void setProducer(String string) {
        this.producer = string;
    }

    protected final void setRequiredModules(ModuleInfo[] moduleInfoArray) {
        this.requiredModules = new ModuleInfo[moduleInfoArray.length];
        System.arraycopy(moduleInfoArray, 0, this.requiredModules, 0, moduleInfoArray.length);
    }

    protected final void setSubSystem(String string) {
        this.subsystem = string;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Module : ");
        stringBuffer.append(this.getName());
        stringBuffer.append("\n");
        stringBuffer.append("ModuleClass : ");
        stringBuffer.append(this.getModuleClass());
        stringBuffer.append("\n");
        stringBuffer.append("Version: ");
        stringBuffer.append(this.getMajorVersion());
        stringBuffer.append(".");
        stringBuffer.append(this.getMinorVersion());
        stringBuffer.append(".");
        stringBuffer.append(this.getPatchLevel());
        stringBuffer.append("\n");
        stringBuffer.append("Producer: ");
        stringBuffer.append(this.getProducer());
        stringBuffer.append("\n");
        stringBuffer.append("Description: ");
        stringBuffer.append(this.getDescription());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

