/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.jfree.chart.axis.SegmentedTimeline$BaseTimelineSegmentRange;
import org.jfree.chart.axis.SegmentedTimeline$Segment;
import org.jfree.chart.axis.SegmentedTimeline$SegmentRange;
import org.jfree.chart.axis.Timeline;

public class SegmentedTimeline
implements Timeline,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1093779862539903110L;
    public static final long DAY_SEGMENT_SIZE = 86400000L;
    public static final long HOUR_SEGMENT_SIZE = 3600000L;
    public static final long FIFTEEN_MINUTE_SEGMENT_SIZE = 900000L;
    public static final long MINUTE_SEGMENT_SIZE = 60000L;
    public static long FIRST_MONDAY_AFTER_1900;
    public static TimeZone NO_DST_TIME_ZONE;
    public static TimeZone DEFAULT_TIME_ZONE;
    private Calendar workingCalendarNoDST = new GregorianCalendar(NO_DST_TIME_ZONE);
    private Calendar workingCalendar = Calendar.getInstance();
    private long segmentSize;
    private int segmentsIncluded;
    private int segmentsExcluded;
    private int groupSegmentCount;
    private long startTime;
    private long segmentsIncludedSize;
    private long segmentsExcludedSize;
    private long segmentsGroupSize;
    private List exceptionSegments = new ArrayList();
    private SegmentedTimeline baseTimeline;
    private boolean adjustForDaylightSaving = false;

    public SegmentedTimeline(long l2, int n, int n2) {
        this.segmentSize = l2;
        this.segmentsIncluded = n;
        this.segmentsExcluded = n2;
        this.groupSegmentCount = this.segmentsIncluded + this.segmentsExcluded;
        this.segmentsIncludedSize = (long)this.segmentsIncluded * this.segmentSize;
        this.segmentsExcludedSize = (long)this.segmentsExcluded * this.segmentSize;
        this.segmentsGroupSize = this.segmentsIncludedSize + this.segmentsExcludedSize;
    }

    public static SegmentedTimeline newMondayThroughFridayTimeline() {
        SegmentedTimeline segmentedTimeline = new SegmentedTimeline(86400000L, 5, 2);
        segmentedTimeline.setStartTime(FIRST_MONDAY_AFTER_1900);
        return segmentedTimeline;
    }

    public static SegmentedTimeline newFifteenMinuteTimeline() {
        SegmentedTimeline segmentedTimeline = new SegmentedTimeline(900000L, 28, 68);
        segmentedTimeline.setStartTime(FIRST_MONDAY_AFTER_1900 + 36L * segmentedTimeline.getSegmentSize());
        segmentedTimeline.setBaseTimeline(SegmentedTimeline.newMondayThroughFridayTimeline());
        return segmentedTimeline;
    }

    public boolean getAdjustForDaylightSaving() {
        return this.adjustForDaylightSaving;
    }

    public void setAdjustForDaylightSaving(boolean bl) {
        this.adjustForDaylightSaving = bl;
    }

    public void setStartTime(long l2) {
        this.startTime = l2;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getSegmentsExcluded() {
        return this.segmentsExcluded;
    }

    public long getSegmentsExcludedSize() {
        return this.segmentsExcludedSize;
    }

    public int getGroupSegmentCount() {
        return this.groupSegmentCount;
    }

    public long getSegmentsGroupSize() {
        return this.segmentsGroupSize;
    }

    public int getSegmentsIncluded() {
        return this.segmentsIncluded;
    }

    public long getSegmentsIncludedSize() {
        return this.segmentsIncludedSize;
    }

    public long getSegmentSize() {
        return this.segmentSize;
    }

    public List getExceptionSegments() {
        return Collections.unmodifiableList(this.exceptionSegments);
    }

    public void setExceptionSegments(List list) {
        this.exceptionSegments = list;
    }

    public SegmentedTimeline getBaseTimeline() {
        return this.baseTimeline;
    }

    public void setBaseTimeline(SegmentedTimeline segmentedTimeline) {
        if (segmentedTimeline != null) {
            if (segmentedTimeline.getSegmentSize() < this.segmentSize) {
                throw new IllegalArgumentException("baseTimeline.getSegmentSize() is smaller than segmentSize");
            }
            if (segmentedTimeline.getStartTime() > this.startTime) {
                throw new IllegalArgumentException("baseTimeline.getStartTime() is after startTime");
            }
            if (segmentedTimeline.getSegmentSize() % this.segmentSize != 0L) {
                throw new IllegalArgumentException("baseTimeline.getSegmentSize() is not multiple of segmentSize");
            }
            if ((this.startTime - segmentedTimeline.getStartTime()) % this.segmentSize != 0L) {
                throw new IllegalArgumentException("baseTimeline is not aligned");
            }
        }
        this.baseTimeline = segmentedTimeline;
    }

    public long toTimelineValue(long l2) {
        long l3;
        long l4 = l2 - this.startTime;
        long l5 = l4 % this.segmentsGroupSize;
        long l6 = l4 / this.segmentsGroupSize;
        if (l5 >= this.segmentsIncludedSize) {
            l3 = this.toTimelineValue(this.startTime + this.segmentsGroupSize * (l6 + 1L));
        } else {
            SegmentedTimeline$Segment segmentedTimeline$Segment = this.getSegment(l2);
            if (segmentedTimeline$Segment.inExceptionSegments()) {
                l3 = this.toTimelineValue(segmentedTimeline$Segment.getSegmentEnd() + 1L);
            } else {
                long l7 = l2 - this.startTime;
                long l8 = l7 % this.segmentsGroupSize;
                long l9 = l7 / this.segmentsGroupSize;
                long l10 = this.getExceptionSegmentCount(this.startTime, l2 - 1L);
                l3 = l8 < this.segmentsIncludedSize ? this.segmentsIncludedSize * l9 + l8 - l10 * this.segmentSize : this.segmentsIncludedSize * (l9 + 1L) - l10 * this.segmentSize;
            }
        }
        return l3;
    }

    public long toTimelineValue(Date date) {
        return this.toTimelineValue(this.getTime(date));
    }

    public long toMillisecond(long l2) {
        SegmentedTimeline$Segment segmentedTimeline$Segment = new SegmentedTimeline$Segment(this, this.startTime + l2 + l2 / this.segmentsIncludedSize * this.segmentsExcludedSize);
        for (long i2 = this.startTime; i2 <= segmentedTimeline$Segment.segmentStart; ++i2) {
            long l3;
            while ((l3 = this.getExceptionSegmentCount(i2, segmentedTimeline$Segment.millisecond / this.segmentSize * this.segmentSize - 1L)) > 0L) {
                i2 = segmentedTimeline$Segment.segmentStart;
                int n = 0;
                while ((long)n < l3) {
                    do {
                        segmentedTimeline$Segment.inc();
                    } while (segmentedTimeline$Segment.inExcludeSegments());
                    ++n;
                }
            }
            i2 = segmentedTimeline$Segment.segmentStart;
            while (segmentedTimeline$Segment.inExceptionSegments() || segmentedTimeline$Segment.inExcludeSegments()) {
                segmentedTimeline$Segment.inc();
                i2 += this.segmentSize;
            }
        }
        return this.getTimeFromLong(segmentedTimeline$Segment.millisecond);
    }

    public long getTimeFromLong(long l2) {
        long l3 = l2;
        if (this.adjustForDaylightSaving) {
            this.workingCalendarNoDST.setTime(new Date(l2));
            this.workingCalendar.set(this.workingCalendarNoDST.get(1), this.workingCalendarNoDST.get(2), this.workingCalendarNoDST.get(5), this.workingCalendarNoDST.get(11), this.workingCalendarNoDST.get(12), this.workingCalendarNoDST.get(13));
            this.workingCalendar.set(14, this.workingCalendarNoDST.get(14));
            l3 = this.workingCalendar.getTime().getTime();
        }
        return l3;
    }

    public boolean containsDomainValue(long l2) {
        SegmentedTimeline$Segment segmentedTimeline$Segment = this.getSegment(l2);
        return segmentedTimeline$Segment.inIncludeSegments();
    }

    public boolean containsDomainValue(Date date) {
        return this.containsDomainValue(this.getTime(date));
    }

    public boolean containsDomainRange(long l2, long l3) {
        if (l3 < l2) {
            throw new IllegalArgumentException("domainValueEnd (" + l3 + ") < domainValueStart (" + l2 + ")");
        }
        SegmentedTimeline$Segment segmentedTimeline$Segment = this.getSegment(l2);
        boolean bl = true;
        do {
            bl = segmentedTimeline$Segment.inIncludeSegments();
            if (segmentedTimeline$Segment.contains(l3)) break;
            segmentedTimeline$Segment.inc();
        } while (bl);
        return bl;
    }

    public boolean containsDomainRange(Date date, Date date2) {
        return this.containsDomainRange(this.getTime(date), this.getTime(date2));
    }

    public void addException(long l2) {
        this.addException(new SegmentedTimeline$Segment(this, l2));
    }

    public void addException(long l2, long l3) {
        this.addException(new SegmentedTimeline$SegmentRange(this, l2, l3));
    }

    public void addException(Date date) {
        this.addException(this.getTime(date));
    }

    public void addExceptions(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addException((Date)iterator.next());
        }
    }

    private void addException(SegmentedTimeline$Segment segmentedTimeline$Segment) {
        if (segmentedTimeline$Segment.inIncludeSegments()) {
            int n = this.binarySearchExceptionSegments(segmentedTimeline$Segment);
            this.exceptionSegments.add(-(n + 1), segmentedTimeline$Segment);
        }
    }

    public void addBaseTimelineException(long l2) {
        SegmentedTimeline$Segment segmentedTimeline$Segment = this.baseTimeline.getSegment(l2);
        if (segmentedTimeline$Segment.inIncludeSegments()) {
            SegmentedTimeline$Segment segmentedTimeline$Segment2 = this.getSegment(segmentedTimeline$Segment.getSegmentStart());
            while (segmentedTimeline$Segment2.getSegmentStart() <= segmentedTimeline$Segment.getSegmentEnd()) {
                if (segmentedTimeline$Segment2.inIncludeSegments()) {
                    long l3;
                    long l4 = segmentedTimeline$Segment2.getSegmentStart();
                    do {
                        l3 = segmentedTimeline$Segment2.getSegmentEnd();
                        segmentedTimeline$Segment2.inc();
                    } while (segmentedTimeline$Segment2.inIncludeSegments());
                    this.addException(l4, l3);
                    continue;
                }
                segmentedTimeline$Segment2.inc();
            }
        }
    }

    public void addBaseTimelineException(Date date) {
        this.addBaseTimelineException(this.getTime(date));
    }

    public void addBaseTimelineExclusions(long l2, long l3) {
        SegmentedTimeline$Segment segmentedTimeline$Segment = this.baseTimeline.getSegment(l2);
        while (segmentedTimeline$Segment.getSegmentStart() <= l3 && !segmentedTimeline$Segment.inExcludeSegments()) {
            segmentedTimeline$Segment.inc();
        }
        while (segmentedTimeline$Segment.getSegmentStart() <= l3) {
            long l4 = segmentedTimeline$Segment.getSegmentStart() + (long)this.baseTimeline.getSegmentsExcluded() * this.baseTimeline.getSegmentSize() - 1L;
            SegmentedTimeline$Segment segmentedTimeline$Segment2 = this.getSegment(segmentedTimeline$Segment.getSegmentStart());
            while (segmentedTimeline$Segment2.getSegmentStart() <= l4) {
                if (segmentedTimeline$Segment2.inIncludeSegments()) {
                    long l5;
                    long l6 = segmentedTimeline$Segment2.getSegmentStart();
                    do {
                        l5 = segmentedTimeline$Segment2.getSegmentEnd();
                        segmentedTimeline$Segment2.inc();
                    } while (segmentedTimeline$Segment2.inIncludeSegments());
                    this.addException(new SegmentedTimeline$BaseTimelineSegmentRange(this, l6, l5));
                    continue;
                }
                segmentedTimeline$Segment2.inc();
            }
            segmentedTimeline$Segment.inc(this.baseTimeline.getGroupSegmentCount());
        }
    }

    public long getExceptionSegmentCount(long l2, long l3) {
        if (l3 < l2) {
            return 0L;
        }
        int n = 0;
        Iterator iterator = this.exceptionSegments.iterator();
        while (iterator.hasNext()) {
            SegmentedTimeline$Segment segmentedTimeline$Segment = (SegmentedTimeline$Segment)iterator.next();
            SegmentedTimeline$Segment segmentedTimeline$Segment2 = segmentedTimeline$Segment.intersect(l2, l3);
            if (segmentedTimeline$Segment2 == null) continue;
            n = (int)((long)n + segmentedTimeline$Segment2.getSegmentCount());
        }
        return n;
    }

    public SegmentedTimeline$Segment getSegment(long l2) {
        return new SegmentedTimeline$Segment(this, l2);
    }

    public SegmentedTimeline$Segment getSegment(Date date) {
        return this.getSegment(this.getTime(date));
    }

    private boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public boolean equals(Object object) {
        if (object instanceof SegmentedTimeline) {
            SegmentedTimeline segmentedTimeline = (SegmentedTimeline)object;
            boolean bl = this.segmentSize == segmentedTimeline.getSegmentSize();
            boolean bl2 = this.segmentsIncluded == segmentedTimeline.getSegmentsIncluded();
            boolean bl3 = this.segmentsExcluded == segmentedTimeline.getSegmentsExcluded();
            boolean bl4 = this.startTime == segmentedTimeline.getStartTime();
            boolean bl5 = this.equals(this.exceptionSegments, segmentedTimeline.getExceptionSegments());
            return bl && bl2 && bl3 && bl4 && bl5;
        }
        return false;
    }

    public int hashCode() {
        int n = 19;
        n = 37 * n + (int)(this.segmentSize ^ this.segmentSize >>> 32);
        n = 37 * n + (int)(this.startTime ^ this.startTime >>> 32);
        return n;
    }

    private int binarySearchExceptionSegments(SegmentedTimeline$Segment segmentedTimeline$Segment) {
        int n = 0;
        int n2 = this.exceptionSegments.size() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            SegmentedTimeline$Segment segmentedTimeline$Segment2 = (SegmentedTimeline$Segment)this.exceptionSegments.get(n3);
            if (segmentedTimeline$Segment.contains(segmentedTimeline$Segment2) || segmentedTimeline$Segment2.contains(segmentedTimeline$Segment)) {
                return n3;
            }
            if (segmentedTimeline$Segment2.before(segmentedTimeline$Segment)) {
                n = n3 + 1;
                continue;
            }
            if (segmentedTimeline$Segment2.after(segmentedTimeline$Segment)) {
                n2 = n3 - 1;
                continue;
            }
            throw new IllegalStateException("Invalid condition.");
        }
        return -(n + 1);
    }

    public long getTime(Date date) {
        long l2 = date.getTime();
        if (this.adjustForDaylightSaving) {
            this.workingCalendar.setTime(date);
            this.workingCalendarNoDST.set(this.workingCalendar.get(1), this.workingCalendar.get(2), this.workingCalendar.get(5), this.workingCalendar.get(11), this.workingCalendar.get(12), this.workingCalendar.get(13));
            this.workingCalendarNoDST.set(14, this.workingCalendar.get(14));
            Date date2 = this.workingCalendarNoDST.getTime();
            l2 = date2.getTime();
        }
        return l2;
    }

    public Date getDate(long l2) {
        this.workingCalendarNoDST.setTime(new Date(l2));
        return this.workingCalendarNoDST.getTime();
    }

    public Object clone() {
        SegmentedTimeline segmentedTimeline = (SegmentedTimeline)super.clone();
        return segmentedTimeline;
    }

    static long access$000(SegmentedTimeline segmentedTimeline) {
        return segmentedTimeline.startTime;
    }

    static long access$100(SegmentedTimeline segmentedTimeline) {
        return segmentedTimeline.segmentSize;
    }

    static int access$200(SegmentedTimeline segmentedTimeline) {
        return segmentedTimeline.segmentsIncluded;
    }

    static int access$300(SegmentedTimeline segmentedTimeline) {
        return segmentedTimeline.groupSegmentCount;
    }

    static int access$400(SegmentedTimeline segmentedTimeline, SegmentedTimeline$Segment segmentedTimeline$Segment) {
        return segmentedTimeline.binarySearchExceptionSegments(segmentedTimeline$Segment);
    }

    static {
        DEFAULT_TIME_ZONE = TimeZone.getDefault();
        int n = TimeZone.getDefault().getRawOffset();
        NO_DST_TIME_ZONE = new SimpleTimeZone(n, "UTC-" + n);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(NO_DST_TIME_ZONE);
        gregorianCalendar.set(1900, 0, 1, 0, 0, 0);
        gregorianCalendar.set(14, 0);
        while (gregorianCalendar.get(7) != 2) {
            ((Calendar)gregorianCalendar).add(5, 1);
        }
        FIRST_MONDAY_AFTER_1900 = gregorianCalendar.getTime().getTime();
    }
}

