/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.encoders;

import com.keypoint.PngEncoder;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import org.jfree.chart.encoders.ImageEncoder;

public class KeypointPNGEncoderAdapter
implements ImageEncoder {
    private int quality = 9;
    private boolean encodingAlpha = false;

    public final float getQuality() {
        return this.quality;
    }

    public final void setQuality(float f2) {
        this.quality = (int)f2;
    }

    public final boolean isEncodingAlpha() {
        return this.encodingAlpha;
    }

    public final void setEncodingAlpha(boolean bl) {
        this.encodingAlpha = bl;
    }

    public final byte[] encode(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("Null 'image' argument.");
        }
        PngEncoder pngEncoder = new PngEncoder(bufferedImage, this.encodingAlpha, 0, this.quality);
        return pngEncoder.pngEncode();
    }

    public final void encode(BufferedImage bufferedImage, OutputStream outputStream) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("Null 'image' argument.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("Null 'outputStream' argument.");
        }
        PngEncoder pngEncoder = new PngEncoder(bufferedImage, this.encodingAlpha, 0, this.quality);
        outputStream.write(pngEncoder.pngEncode());
    }
}

