/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.Zoomable;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class CombinedRangeXYPlot
extends XYPlot
implements Zoomable,
Cloneable,
PublicCloneable,
Serializable,
PlotChangeListener {
    private static final long serialVersionUID = -5177814085082031168L;
    private List subplots = new ArrayList();
    private int totalWeight = 0;
    private double gap = 5.0;
    private transient Rectangle2D[] subplotAreas;

    public CombinedRangeXYPlot() {
        this(new NumberAxis());
    }

    public CombinedRangeXYPlot(ValueAxis valueAxis) {
        super(null, null, valueAxis, null);
    }

    public String getPlotType() {
        return localizationResources.getString("Combined_Range_XYPlot");
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double d2) {
        this.gap = d2;
    }

    public void add(XYPlot xYPlot) {
        this.add(xYPlot, 1);
    }

    public void add(XYPlot xYPlot, int n) {
        if (n <= 0) {
            String string = "The 'weight' must be positive.";
            throw new IllegalArgumentException(string);
        }
        xYPlot.setParent(this);
        xYPlot.setWeight(n);
        xYPlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        xYPlot.setRangeAxis(null);
        xYPlot.addChangeListener(this);
        this.subplots.add(xYPlot);
        this.totalWeight += n;
        this.configureRangeAxes();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void remove(XYPlot xYPlot) {
        if (xYPlot == null) {
            throw new IllegalArgumentException(" Null 'subplot' argument.");
        }
        int n = -1;
        int n2 = this.subplots.size();
        for (int i2 = 0; n == -1 && i2 < n2; ++i2) {
            if (this.subplots.get(i2) != xYPlot) continue;
            n = i2;
        }
        if (n != -1) {
            xYPlot.setParent(null);
            xYPlot.removeChangeListener(this);
            this.totalWeight -= xYPlot.getWeight();
            this.configureRangeAxes();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public List getSubplots() {
        return Collections.unmodifiableList(this.subplots);
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Cloneable cloneable;
        AxisSpace axisSpace = new AxisSpace();
        PlotOrientation plotOrientation = this.getOrientation();
        AxisSpace axisSpace2 = this.getFixedRangeAxisSpace();
        if (axisSpace2 != null) {
            if (plotOrientation == PlotOrientation.VERTICAL) {
                axisSpace.setLeft(axisSpace2.getLeft());
                axisSpace.setRight(axisSpace2.getRight());
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                axisSpace.setTop(axisSpace2.getTop());
                axisSpace.setBottom(axisSpace2.getBottom());
            }
        } else {
            cloneable = this.getRangeAxis();
            RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), plotOrientation);
            if (cloneable != null) {
                axisSpace = ((ValueAxis)cloneable).reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        cloneable = axisSpace.shrink(rectangle2D, null);
        int n = this.subplots.size();
        this.subplotAreas = new Rectangle2D[n];
        double d2 = ((RectangularShape)cloneable).getX();
        double d3 = ((RectangularShape)cloneable).getY();
        double d4 = 0.0;
        if (plotOrientation == PlotOrientation.VERTICAL) {
            d4 = ((RectangularShape)cloneable).getWidth() - this.gap * (double)(n - 1);
        } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d4 = ((RectangularShape)cloneable).getHeight() - this.gap * (double)(n - 1);
        }
        for (int i2 = 0; i2 < n; ++i2) {
            XYPlot xYPlot = (XYPlot)this.subplots.get(i2);
            if (plotOrientation == PlotOrientation.VERTICAL) {
                double d5 = d4 * (double)xYPlot.getWeight() / (double)this.totalWeight;
                this.subplotAreas[i2] = new Rectangle2D.Double(d2, d3, d5, ((RectangularShape)cloneable).getHeight());
                d2 = d2 + d5 + this.gap;
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double d6 = d4 * (double)xYPlot.getWeight() / (double)this.totalWeight;
                this.subplotAreas[i2] = new Rectangle2D.Double(d2, d3, ((RectangularShape)cloneable).getWidth(), d6);
                d3 = d3 + d6 + this.gap;
            }
            AxisSpace axisSpace3 = xYPlot.calculateDomainAxisSpace(graphics2D, this.subplotAreas[i2], null);
            axisSpace.ensureAtLeast(axisSpace3);
        }
        return axisSpace;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.setFixedDomainAxisSpaceForSubplots(axisSpace);
        ValueAxis valueAxis = this.getRangeAxis();
        RectangleEdge rectangleEdge = this.getRangeAxisEdge();
        double d2 = RectangleEdge.coordinate(rectangle2D2, rectangleEdge);
        AxisState axisState = valueAxis.draw(graphics2D, d2, rectangle2D, rectangle2D2, rectangleEdge, plotRenderingInfo);
        if (plotState == null) {
            plotState = new PlotState();
        }
        plotState.getSharedAxisStates().put(valueAxis, axisState);
        for (int i2 = 0; i2 < this.subplots.size(); ++i2) {
            XYPlot xYPlot = (XYPlot)this.subplots.get(i2);
            PlotRenderingInfo plotRenderingInfo2 = null;
            if (plotRenderingInfo != null) {
                plotRenderingInfo2 = new PlotRenderingInfo(plotRenderingInfo.getOwner());
                plotRenderingInfo.addSubplotInfo(plotRenderingInfo2);
            }
            xYPlot.draw(graphics2D, this.subplotAreas[i2], point2D, plotState, plotRenderingInfo2);
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = this.getFixedLegendItems();
        if (legendItemCollection == null) {
            legendItemCollection = new LegendItemCollection();
            if (this.subplots != null) {
                Iterator iterator = this.subplots.iterator();
                while (iterator.hasNext()) {
                    XYPlot xYPlot = (XYPlot)iterator.next();
                    LegendItemCollection legendItemCollection2 = xYPlot.getLegendItems();
                    legendItemCollection.addAll(legendItemCollection2);
                }
            }
        }
        return legendItemCollection;
    }

    public void zoomDomainAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        XYPlot xYPlot = this.findSubplot(plotRenderingInfo, point2D);
        if (xYPlot != null) {
            xYPlot.zoomDomainAxes(d2, plotRenderingInfo, point2D);
        }
    }

    public void zoomDomainAxes(double d2, double d3, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        XYPlot xYPlot = this.findSubplot(plotRenderingInfo, point2D);
        if (xYPlot != null) {
            xYPlot.zoomDomainAxes(d2, d3, plotRenderingInfo, point2D);
        }
    }

    public XYPlot findSubplot(PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        XYPlot xYPlot = null;
        int n = plotRenderingInfo.getSubplotIndex(point2D);
        if (n >= 0) {
            xYPlot = (XYPlot)this.subplots.get(n);
        }
        return xYPlot;
    }

    public void setRenderer(XYItemRenderer xYItemRenderer) {
        super.setRenderer(xYItemRenderer);
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot xYPlot = (XYPlot)iterator.next();
            xYPlot.setRenderer(xYItemRenderer);
        }
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        super.setOrientation(plotOrientation);
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot xYPlot = (XYPlot)iterator.next();
            xYPlot.setOrientation(plotOrientation);
        }
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot xYPlot = (XYPlot)iterator.next();
                range = Range.combine(range, xYPlot.getDataRange(valueAxis));
            }
        }
        return range;
    }

    protected void setFixedDomainAxisSpaceForSubplots(AxisSpace axisSpace) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot xYPlot = (XYPlot)iterator.next();
            xYPlot.setFixedDomainAxisSpace(axisSpace);
        }
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n, n2)) {
            for (int i2 = 0; i2 < this.subplots.size(); ++i2) {
                XYPlot xYPlot = (XYPlot)this.subplots.get(i2);
                PlotRenderingInfo plotRenderingInfo2 = plotRenderingInfo.getSubplotInfo(i2);
                xYPlot.handleClick(n, n2, plotRenderingInfo2);
            }
        }
    }

    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        this.notifyListeners(plotChangeEvent);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CombinedRangeXYPlot)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        CombinedRangeXYPlot combinedRangeXYPlot = (CombinedRangeXYPlot)object;
        if (!ObjectUtilities.equal(this.subplots, combinedRangeXYPlot.subplots)) {
            return false;
        }
        if (this.totalWeight != combinedRangeXYPlot.totalWeight) {
            return false;
        }
        return this.gap == combinedRangeXYPlot.gap;
    }

    public Object clone() {
        CombinedRangeXYPlot combinedRangeXYPlot = (CombinedRangeXYPlot)super.clone();
        combinedRangeXYPlot.subplots = (List)ObjectUtilities.deepClone(this.subplots);
        Object object = combinedRangeXYPlot.subplots.iterator();
        while (object.hasNext()) {
            Plot plot = (Plot)object.next();
            plot.setParent(combinedRangeXYPlot);
        }
        object = combinedRangeXYPlot.getRangeAxis();
        if (object != null) {
            ((Axis)object).configure();
        }
        return combinedRangeXYPlot;
    }
}

