/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class StackedAreaRenderer
extends AreaRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -3595635038460823663L;

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        return DatasetUtilities.findStackedRangeBounds(categoryDataset);
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Object object;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d2 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d3 = 0.0;
        double d4 = number.doubleValue();
        graphics2D.setPaint(this.getItemPaint(n, n2));
        graphics2D.setStroke(this.getItemStroke(n, n2));
        if (n2 != 0 && (object = categoryDataset.getValue(n, n2 - 1)) != null) {
            double d5 = categoryAxis.getCategoryMiddle(n2 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d6 = ((Number)object).doubleValue();
            double d7 = this.getPreviousHeight(categoryDataset, n, n2 - 1);
            double d8 = this.getPreviousHeight(categoryDataset, n, n2);
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            double d9 = valueAxis.valueToJava2D(d7, rectangle2D, rectangleEdge);
            double d10 = valueAxis.valueToJava2D(d8, rectangle2D, rectangleEdge);
            double d11 = valueAxis.valueToJava2D(d6 += d7, rectangle2D, rectangleEdge);
            d3 = valueAxis.valueToJava2D(d4 += d8, rectangle2D, rectangleEdge);
            Polygon polygon = null;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                polygon = new Polygon();
                polygon.addPoint((int)d11, (int)d5);
                polygon.addPoint((int)d3, (int)d2);
                polygon.addPoint((int)d10, (int)d2);
                polygon.addPoint((int)d9, (int)d5);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                polygon = new Polygon();
                polygon.addPoint((int)d5, (int)d11);
                polygon.addPoint((int)d2, (int)d3);
                polygon.addPoint((int)d2, (int)d10);
                polygon.addPoint((int)d5, (int)d9);
            }
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.fill(polygon);
        }
        if ((object = categoryItemRendererState.getEntityCollection()) != null) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2 - 3.0, d3 - 3.0, 6.0, 6.0);
            this.addItemEntity((EntityCollection)object, categoryDataset, n, n2, double_);
        }
    }

    protected double getPreviousHeight(CategoryDataset categoryDataset, int n, int n2) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < n; ++i2) {
            Number number = categoryDataset.getValue(i2, n2);
            if (number == null) continue;
            d2 += number.doubleValue();
        }
        return d2;
    }
}

