/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.DataUtilities;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PublicCloneable;

public class StackedBarRenderer
extends BarRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    static final long serialVersionUID = 6402943811500067531L;
    private boolean renderAsPercentages;

    public StackedBarRenderer() {
        this(false);
    }

    public StackedBarRenderer(boolean bl) {
        this.renderAsPercentages = bl;
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER);
        this.setBasePositiveItemLabelPosition(itemLabelPosition);
        this.setBaseNegativeItemLabelPosition(itemLabelPosition);
        this.setPositiveItemLabelPositionFallback(null);
        this.setNegativeItemLabelPositionFallback(null);
    }

    public boolean getRenderAsPercentages() {
        return this.renderAsPercentages;
    }

    public void setRenderAsPercentages(boolean bl) {
        this.renderAsPercentages = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public int getPassCount() {
        return 2;
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        if (this.renderAsPercentages) {
            return new Range(0.0, 1.0);
        }
        return DatasetUtilities.findStackedRangeBounds(categoryDataset, this.getBase());
    }

    protected void calculateBarWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, int n, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = categoryPlot.getDomainAxisForDataset(n);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        if (categoryDataset != null) {
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d2 = 0.0;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d2 = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d2 = rectangle2D.getWidth();
            }
            double d3 = d2 * this.getMaximumBarWidth();
            int n2 = categoryDataset.getColumnCount();
            double d4 = 0.0;
            if (n2 > 1) {
                d4 = categoryAxis.getCategoryMargin();
            }
            double d5 = d2 * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d4);
            if (n2 > 0) {
                categoryItemRendererState.setBarWidth(Math.min(d5 / (double)n2, d3));
            } else {
                categoryItemRendererState.setBarWidth(Math.min(d5, d3));
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        double d2;
        double d3;
        double d4;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d5 = number.doubleValue();
        double d6 = 0.0;
        if (this.renderAsPercentages) {
            d6 = DataUtilities.calculateColumnTotal(categoryDataset, n2);
            d5 /= d6;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d7 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        double d8 = d4 = this.getBase();
        for (int i2 = 0; i2 < n; ++i2) {
            Number number2 = categoryDataset.getValue(i2, n2);
            if (number2 == null) continue;
            d3 = number2.doubleValue();
            if (this.renderAsPercentages) {
                d3 /= d6;
            }
            if (d3 > 0.0) {
                d4 += d3;
                continue;
            }
            d8 += d3;
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        if (d5 >= 0.0) {
            d2 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge);
            d3 = valueAxis.valueToJava2D(d4 + d5, rectangle2D, rectangleEdge);
        } else {
            d2 = valueAxis.valueToJava2D(d8, rectangle2D, rectangleEdge);
            d3 = valueAxis.valueToJava2D(d8 + d5, rectangle2D, rectangleEdge);
        }
        double d9 = Math.min(d2, d3);
        double d10 = Math.max(Math.abs(d3 - d2), this.getMinimumBarLength());
        Rectangle2D.Double double_ = null;
        double_ = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d9, d7, d10, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d7, d9, categoryItemRendererState.getBarWidth(), d10);
        if (n3 == 0) {
            EntityCollection entityCollection;
            Paint paint = this.getItemPaint(n, n2);
            GradientPaintTransformer gradientPaintTransformer = this.getGradientPaintTransformer();
            if (gradientPaintTransformer != null && paint instanceof GradientPaint) {
                paint = gradientPaintTransformer.transform((GradientPaint)paint, double_);
            }
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_);
            }
            if ((entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
                this.addItemEntity(entityCollection, categoryDataset, n, n2, double_);
            }
        } else if (n3 == 1 && (categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_, d5 < 0.0);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackedBarRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        StackedBarRenderer stackedBarRenderer = (StackedBarRenderer)object;
        return this.renderAsPercentages == stackedBarRenderer.renderAsPercentages;
    }
}

