/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer$State;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtilities;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class XYLineAndShapeRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -7435246895986425885L;
    private Boolean linesVisible = null;
    private BooleanList seriesLinesVisible = new BooleanList();
    private boolean baseLinesVisible;
    private transient Shape legendLine;
    private Boolean shapesVisible;
    private BooleanList seriesShapesVisible;
    private boolean baseShapesVisible;
    private Boolean shapesFilled;
    private BooleanList seriesShapesFilled;
    private boolean baseShapesFilled;
    private boolean drawOutlines;
    private boolean useFillPaint;
    private boolean useOutlinePaint;
    private boolean drawSeriesLineAsPath;

    public XYLineAndShapeRenderer() {
        this(true, true);
    }

    public XYLineAndShapeRenderer(boolean bl, boolean bl2) {
        this.baseLinesVisible = bl;
        this.legendLine = new Line2D.Double(-7.0, 0.0, 7.0, 0.0);
        this.shapesVisible = null;
        this.seriesShapesVisible = new BooleanList();
        this.baseShapesVisible = bl2;
        this.shapesFilled = null;
        this.useFillPaint = false;
        this.seriesShapesFilled = new BooleanList();
        this.baseShapesFilled = true;
        this.drawOutlines = true;
        this.useOutlinePaint = false;
        this.drawSeriesLineAsPath = false;
    }

    public boolean getDrawSeriesLineAsPath() {
        return this.drawSeriesLineAsPath;
    }

    public void setDrawSeriesLineAsPath(boolean bl) {
        if (this.drawSeriesLineAsPath != bl) {
            this.drawSeriesLineAsPath = bl;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public int getPassCount() {
        return 2;
    }

    public boolean getItemLineVisible(int n, int n2) {
        Boolean bl = this.linesVisible;
        if (bl == null) {
            bl = this.getSeriesLinesVisible(n);
        }
        if (bl != null) {
            return bl;
        }
        return this.baseLinesVisible;
    }

    public Boolean getLinesVisible() {
        return this.linesVisible;
    }

    public void setLinesVisible(Boolean bl) {
        this.linesVisible = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setLinesVisible(boolean bl) {
        this.setLinesVisible(BooleanUtilities.valueOf(bl));
    }

    public Boolean getSeriesLinesVisible(int n) {
        return this.seriesLinesVisible.getBoolean(n);
    }

    public void setSeriesLinesVisible(int n, Boolean bl) {
        this.seriesLinesVisible.setBoolean(n, bl);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setSeriesLinesVisible(int n, boolean bl) {
        this.setSeriesLinesVisible(n, BooleanUtilities.valueOf(bl));
    }

    public boolean getBaseLinesVisible() {
        return this.baseLinesVisible;
    }

    public void setBaseLinesVisible(boolean bl) {
        this.baseLinesVisible = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Shape getLegendLine() {
        return this.legendLine;
    }

    public void setLegendLine(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'line' argument.");
        }
        this.legendLine = shape;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getItemShapeVisible(int n, int n2) {
        Boolean bl = this.shapesVisible;
        if (bl == null) {
            bl = this.getSeriesShapesVisible(n);
        }
        if (bl != null) {
            return bl;
        }
        return this.baseShapesVisible;
    }

    public Boolean getShapesVisible() {
        return this.shapesVisible;
    }

    public void setShapesVisible(Boolean bl) {
        this.shapesVisible = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void setShapesVisible(boolean bl) {
        this.setShapesVisible(BooleanUtilities.valueOf(bl));
    }

    public Boolean getSeriesShapesVisible(int n) {
        return this.seriesShapesVisible.getBoolean(n);
    }

    public void setSeriesShapesVisible(int n, boolean bl) {
        this.setSeriesShapesVisible(n, BooleanUtilities.valueOf(bl));
    }

    public void setSeriesShapesVisible(int n, Boolean bl) {
        this.seriesShapesVisible.setBoolean(n, bl);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getBaseShapesVisible() {
        return this.baseShapesVisible;
    }

    public void setBaseShapesVisible(boolean bl) {
        this.baseShapesVisible = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getItemShapeFilled(int n, int n2) {
        Boolean bl = this.shapesFilled;
        if (bl == null) {
            bl = this.getSeriesShapesFilled(n);
        }
        if (bl != null) {
            return bl;
        }
        return this.baseShapesFilled;
    }

    public void setShapesFilled(boolean bl) {
        this.setShapesFilled(BooleanUtilities.valueOf(bl));
    }

    public void setShapesFilled(Boolean bl) {
        this.shapesFilled = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Boolean getSeriesShapesFilled(int n) {
        return this.seriesShapesFilled.getBoolean(n);
    }

    public void setSeriesShapesFilled(int n, boolean bl) {
        this.setSeriesShapesFilled(n, BooleanUtilities.valueOf(bl));
    }

    public void setSeriesShapesFilled(int n, Boolean bl) {
        this.seriesShapesFilled.setBoolean(n, bl);
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getBaseShapesFilled() {
        return this.baseShapesFilled;
    }

    public void setBaseShapesFilled(boolean bl) {
        this.baseShapesFilled = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getDrawOutlines() {
        return this.drawOutlines;
    }

    public void setDrawOutlines(boolean bl) {
        this.drawOutlines = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getUseFillPaint() {
        return this.useFillPaint;
    }

    public void setUseFillPaint(boolean bl) {
        this.useFillPaint = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getUseOutlinePaint() {
        return this.useOutlinePaint;
    }

    public void setUseOutlinePaint(boolean bl) {
        this.useOutlinePaint = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYLineAndShapeRenderer$State xYLineAndShapeRenderer$State = new XYLineAndShapeRenderer$State(plotRenderingInfo);
        xYLineAndShapeRenderer$State.seriesPath = new GeneralPath();
        return xYLineAndShapeRenderer$State;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        if (this.isLinePass(n3)) {
            if (n2 == 0 && this.drawSeriesLineAsPath) {
                XYLineAndShapeRenderer$State xYLineAndShapeRenderer$State = (XYLineAndShapeRenderer$State)xYItemRendererState;
                xYLineAndShapeRenderer$State.seriesPath.reset();
                XYLineAndShapeRenderer$State.access$002(xYLineAndShapeRenderer$State, false);
            }
            if (this.getItemLineVisible(n, n2)) {
                if (this.drawSeriesLineAsPath) {
                    this.drawPrimaryLineAsPath(xYItemRendererState, graphics2D, xYPlot, xYDataset, n3, n, n2, valueAxis, valueAxis2, rectangle2D);
                } else {
                    this.drawPrimaryLine(xYItemRendererState, graphics2D, xYPlot, xYDataset, n3, n, n2, valueAxis, valueAxis2, rectangle2D);
                }
            }
        } else if (this.isItemPass(n3)) {
            EntityCollection entityCollection = null;
            if (plotRenderingInfo != null) {
                entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
            }
            this.drawSecondaryPass(graphics2D, xYPlot, xYDataset, n3, n, n2, valueAxis, rectangle2D, valueAxis2, crosshairState, entityCollection);
        }
    }

    protected boolean isLinePass(int n) {
        return n == 0;
    }

    protected boolean isItemPass(int n) {
        return n == 1;
    }

    protected void drawPrimaryLine(XYItemRendererState xYItemRendererState, Graphics2D graphics2D, XYPlot xYPlot, XYDataset xYDataset, int n, int n2, int n3, ValueAxis valueAxis, ValueAxis valueAxis2, Rectangle2D rectangle2D) {
        if (n3 == 0) {
            return;
        }
        double d2 = xYDataset.getXValue(n2, n3);
        double d3 = xYDataset.getYValue(n2, n3);
        if (Double.isNaN(d3) || Double.isNaN(d2)) {
            return;
        }
        double d4 = xYDataset.getXValue(n2, n3 - 1);
        double d5 = xYDataset.getYValue(n2, n3 - 1);
        if (Double.isNaN(d5) || Double.isNaN(d4)) {
            return;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d6 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge);
        double d7 = valueAxis2.valueToJava2D(d5, rectangle2D, rectangleEdge2);
        double d8 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d9 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge2);
        if (Double.isNaN(d6) || Double.isNaN(d7) || Double.isNaN(d8) || Double.isNaN(d9)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            xYItemRendererState.workingLine.setLine(d7, d6, d9, d8);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            xYItemRendererState.workingLine.setLine(d6, d7, d8, d9);
        }
        if (xYItemRendererState.workingLine.intersects(rectangle2D)) {
            this.drawFirstPassShape(graphics2D, n, n2, n3, xYItemRendererState.workingLine);
        }
    }

    protected void drawFirstPassShape(Graphics2D graphics2D, int n, int n2, int n3, Shape shape) {
        graphics2D.setStroke(this.getItemStroke(n2, n3));
        graphics2D.setPaint(this.getItemPaint(n2, n3));
        graphics2D.draw(shape);
    }

    protected void drawPrimaryLineAsPath(XYItemRendererState xYItemRendererState, Graphics2D graphics2D, XYPlot xYPlot, XYDataset xYDataset, int n, int n2, int n3, ValueAxis valueAxis, ValueAxis valueAxis2, Rectangle2D rectangle2D) {
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d2 = xYDataset.getXValue(n2, n3);
        double d3 = xYDataset.getYValue(n2, n3);
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d5 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge2);
        XYLineAndShapeRenderer$State xYLineAndShapeRenderer$State = (XYLineAndShapeRenderer$State)xYItemRendererState;
        if (!Double.isNaN(d4) && !Double.isNaN(d5)) {
            float f2 = (float)d4;
            float f3 = (float)d5;
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                f2 = (float)d5;
                f3 = (float)d4;
            }
            if (xYLineAndShapeRenderer$State.isLastPointGood()) {
                xYLineAndShapeRenderer$State.seriesPath.lineTo(f2, f3);
            } else {
                xYLineAndShapeRenderer$State.seriesPath.moveTo(f2, f3);
            }
            xYLineAndShapeRenderer$State.setLastPointGood(true);
        } else {
            xYLineAndShapeRenderer$State.setLastPointGood(false);
        }
        if (n3 == xYDataset.getItemCount(n2) - 1) {
            this.drawFirstPassShape(graphics2D, n, n2, n3, xYLineAndShapeRenderer$State.seriesPath);
        }
    }

    protected void drawSecondaryPass(Graphics2D graphics2D, XYPlot xYPlot, XYDataset xYDataset, int n, int n2, int n3, ValueAxis valueAxis, Rectangle2D rectangle2D, ValueAxis valueAxis2, CrosshairState crosshairState, EntityCollection entityCollection) {
        Shape shape = null;
        double d2 = xYDataset.getXValue(n2, n3);
        double d3 = xYDataset.getYValue(n2, n3);
        if (Double.isNaN(d3) || Double.isNaN(d2)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d5 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge2);
        if (this.getItemShapeVisible(n2, n3)) {
            Shape shape2 = this.getItemShape(n2, n3);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                shape2 = ShapeUtilities.createTranslatedShape(shape2, d5, d4);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                shape2 = ShapeUtilities.createTranslatedShape(shape2, d4, d5);
            }
            shape = shape2;
            if (shape2.intersects(rectangle2D)) {
                if (this.getItemShapeFilled(n2, n3)) {
                    if (this.useFillPaint) {
                        graphics2D.setPaint(this.getItemFillPaint(n2, n3));
                    } else {
                        graphics2D.setPaint(this.getItemPaint(n2, n3));
                    }
                    graphics2D.fill(shape2);
                }
                if (this.drawOutlines) {
                    if (this.getUseOutlinePaint()) {
                        graphics2D.setPaint(this.getItemOutlinePaint(n2, n3));
                    } else {
                        graphics2D.setPaint(this.getItemPaint(n2, n3));
                    }
                    graphics2D.setStroke(this.getItemOutlineStroke(n2, n3));
                    graphics2D.draw(shape2);
                }
            }
        }
        if (this.isItemLabelVisible(n2, n3)) {
            double d6 = d4;
            double d7 = d5;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d6 = d5;
                d7 = d4;
            }
            this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n2, n3, d6, d7, d3 < 0.0);
        }
        this.updateCrosshairValues(crosshairState, d2, d3, d4, d5, xYPlot.getOrientation());
        if (entityCollection != null) {
            this.addEntity(entityCollection, shape, xYDataset, n2, n3, d4, d5);
        }
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYPlot xYPlot = this.getPlot();
        if (xYPlot == null) {
            return null;
        }
        LegendItem legendItem = null;
        XYDataset xYDataset = xYPlot.getDataset(n);
        if (xYDataset != null && this.getItemVisible(n2, 0)) {
            String string;
            String string2 = string = this.getLegendItemLabelGenerator().generateLabel(xYDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
            }
            boolean bl = this.getItemShapeVisible(n2, 0);
            Shape shape = this.getSeriesShape(n2);
            boolean bl2 = this.getItemShapeFilled(n2, 0);
            Paint paint = this.useFillPaint ? this.getSeriesFillPaint(n2) : this.getSeriesPaint(n2);
            boolean bl3 = this.drawOutlines;
            Paint paint2 = this.useOutlinePaint ? this.getSeriesOutlinePaint(n2) : this.getSeriesPaint(n2);
            Stroke stroke = this.getSeriesOutlineStroke(n2);
            boolean bl4 = this.getItemLineVisible(n2, 0);
            Stroke stroke2 = this.getSeriesStroke(n2);
            Paint paint3 = this.getSeriesPaint(n2);
            legendItem = new LegendItem(string, string2, string3, string4, bl, shape, bl2, paint, bl3, paint2, stroke, bl4, this.legendLine, stroke2, paint3);
            legendItem.setSeriesIndex(n2);
            legendItem.setDatasetIndex(n);
        }
        return legendItem;
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYLineAndShapeRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)object;
        if (!ObjectUtilities.equal(this.linesVisible, xYLineAndShapeRenderer.linesVisible)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.seriesLinesVisible, xYLineAndShapeRenderer.seriesLinesVisible)) {
            return false;
        }
        if (this.baseLinesVisible != xYLineAndShapeRenderer.baseLinesVisible) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendLine, xYLineAndShapeRenderer.legendLine)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.shapesVisible, xYLineAndShapeRenderer.shapesVisible)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.seriesShapesVisible, xYLineAndShapeRenderer.seriesShapesVisible)) {
            return false;
        }
        if (this.baseShapesVisible != xYLineAndShapeRenderer.baseShapesVisible) {
            return false;
        }
        if (!ObjectUtilities.equal(this.shapesFilled, xYLineAndShapeRenderer.shapesFilled)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.seriesShapesFilled, xYLineAndShapeRenderer.seriesShapesFilled)) {
            return false;
        }
        if (this.baseShapesFilled != xYLineAndShapeRenderer.baseShapesFilled) {
            return false;
        }
        if (this.drawOutlines != xYLineAndShapeRenderer.drawOutlines) {
            return false;
        }
        return this.useOutlinePaint == xYLineAndShapeRenderer.useOutlinePaint;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.legendLine = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendLine, objectOutputStream);
    }
}

