/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.block.AbstractBlock;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.Size2D;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class LegendGraphic
extends AbstractBlock
implements Block,
PublicCloneable {
    private boolean shapeVisible;
    private transient Shape shape;
    private RectangleAnchor shapeLocation;
    private RectangleAnchor shapeAnchor;
    private boolean shapeFilled;
    private transient Paint fillPaint;
    private boolean shapeOutlineVisible;
    private transient Paint outlinePaint;
    private transient Stroke outlineStroke;
    private boolean lineVisible;
    private transient Shape line;
    private transient Stroke lineStroke;
    private transient Paint linePaint;

    public LegendGraphic(Shape shape, Paint paint) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'fillPaint' argument.");
        }
        this.shapeVisible = true;
        this.shape = shape;
        this.shapeAnchor = RectangleAnchor.CENTER;
        this.shapeLocation = RectangleAnchor.CENTER;
        this.shapeFilled = true;
        this.fillPaint = paint;
        this.setPadding(2.0, 2.0, 2.0, 2.0);
    }

    public final boolean isShapeVisible() {
        return this.shapeVisible;
    }

    public final void setShapeVisible(boolean bl) {
        this.shapeVisible = bl;
    }

    public final Shape getShape() {
        return this.shape;
    }

    public final void setShape(Shape shape) {
        this.shape = shape;
    }

    public final boolean isShapeFilled() {
        return this.shapeFilled;
    }

    public final void setShapeFilled(boolean bl) {
        this.shapeFilled = bl;
    }

    public final Paint getFillPaint() {
        return this.fillPaint;
    }

    public final void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }

    public final boolean isShapeOutlineVisible() {
        return this.shapeOutlineVisible;
    }

    public final void setShapeOutlineVisible(boolean bl) {
        this.shapeOutlineVisible = bl;
    }

    public final Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public final void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
    }

    public final Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public final void setOutlineStroke(Stroke stroke) {
        this.outlineStroke = stroke;
    }

    public final RectangleAnchor getShapeAnchor() {
        return this.shapeAnchor;
    }

    public final void setShapeAnchor(RectangleAnchor rectangleAnchor) {
        if (rectangleAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.shapeAnchor = rectangleAnchor;
    }

    public final RectangleAnchor getShapeLocation() {
        return this.shapeLocation;
    }

    public final void setShapeLocation(RectangleAnchor rectangleAnchor) {
        if (rectangleAnchor == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        this.shapeLocation = rectangleAnchor;
    }

    public final boolean isLineVisible() {
        return this.lineVisible;
    }

    public final void setLineVisible(boolean bl) {
        this.lineVisible = bl;
    }

    public final Shape getLine() {
        return this.line;
    }

    public final void setLine(Shape shape) {
        this.line = shape;
    }

    public final Paint getLinePaint() {
        return this.linePaint;
    }

    public final void setLinePaint(Paint paint) {
        this.linePaint = paint;
    }

    public final Stroke getLineStroke() {
        return this.lineStroke;
    }

    public final void setLineStroke(Stroke stroke) {
        this.lineStroke = stroke;
    }

    public final Size2D arrange(Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = this.toContentConstraint(rectangleConstraint);
        LengthConstraintType lengthConstraintType = rectangleConstraint2.getWidthConstraintType();
        LengthConstraintType lengthConstraintType2 = rectangleConstraint2.getHeightConstraintType();
        Size2D size2D = null;
        if (lengthConstraintType == LengthConstraintType.NONE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                size2D = this.arrangeNN(graphics2D);
            } else {
                if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                    throw new RuntimeException("Not yet implemented.");
                }
                if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        } else if (lengthConstraintType == LengthConstraintType.RANGE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not yet implemented.");
            }
        } else if (lengthConstraintType == LengthConstraintType.FIXED) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                size2D = new Size2D(rectangleConstraint2.getWidth(), rectangleConstraint2.getHeight());
            }
        }
        return new Size2D(this.calculateTotalWidth(size2D.getWidth()), this.calculateTotalHeight(size2D.getHeight()));
    }

    protected final Size2D arrangeNN(Graphics2D graphics2D) {
        Rectangle2D rectangle2D = new Rectangle2D.Double();
        if (this.line != null) {
            ((Rectangle2D)rectangle2D).setRect(this.line.getBounds2D());
        }
        if (this.shape != null) {
            rectangle2D = ((Rectangle2D)rectangle2D).createUnion(this.shape.getBounds2D());
        }
        return new Size2D(((RectangularShape)rectangle2D).getWidth(), ((RectangularShape)rectangle2D).getHeight());
    }

    public final void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Shape shape;
        Point2D point2D;
        rectangle2D = this.trimMargin(rectangle2D);
        this.drawBorder(graphics2D, rectangle2D);
        rectangle2D = this.trimBorder(rectangle2D);
        rectangle2D = this.trimPadding(rectangle2D);
        if (this.lineVisible) {
            point2D = RectangleAnchor.coordinates(rectangle2D, this.shapeLocation);
            shape = ShapeUtilities.createTranslatedShape(this.getLine(), this.shapeAnchor, point2D.getX(), point2D.getY());
            graphics2D.setPaint(this.linePaint);
            graphics2D.setStroke(this.lineStroke);
            graphics2D.draw(shape);
        }
        if (this.shapeVisible) {
            point2D = RectangleAnchor.coordinates(rectangle2D, this.shapeLocation);
            shape = ShapeUtilities.createTranslatedShape(this.shape, this.shapeAnchor, point2D.getX(), point2D.getY());
            if (this.shapeFilled) {
                graphics2D.setPaint(this.fillPaint);
                graphics2D.fill(shape);
            }
            if (this.shapeOutlineVisible) {
                graphics2D.setPaint(this.outlinePaint);
                graphics2D.setStroke(this.outlineStroke);
                graphics2D.draw(shape);
            }
        }
    }

    public final Object draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Object object) {
        this.draw(graphics2D, rectangle2D);
        return null;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof LegendGraphic)) {
            return false;
        }
        LegendGraphic legendGraphic = (LegendGraphic)object;
        if (this.shapeVisible != legendGraphic.shapeVisible) {
            return false;
        }
        if (!ShapeUtilities.equal(this.shape, legendGraphic.shape)) {
            return false;
        }
        if (this.shapeFilled != legendGraphic.shapeFilled) {
            return false;
        }
        if (!PaintUtilities.equal(this.fillPaint, legendGraphic.fillPaint)) {
            return false;
        }
        if (this.shapeOutlineVisible != legendGraphic.shapeOutlineVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.outlinePaint, legendGraphic.outlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlineStroke, legendGraphic.outlineStroke)) {
            return false;
        }
        if (this.shapeAnchor != legendGraphic.shapeAnchor) {
            return false;
        }
        if (this.shapeLocation != legendGraphic.shapeLocation) {
            return false;
        }
        if (this.lineVisible != legendGraphic.lineVisible) {
            return false;
        }
        if (!ShapeUtilities.equal(this.line, legendGraphic.line)) {
            return false;
        }
        if (!PaintUtilities.equal(this.linePaint, legendGraphic.linePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.lineStroke, legendGraphic.lineStroke)) {
            return false;
        }
        return super.equals(object);
    }

    public final Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.shape, objectOutputStream);
        SerialUtilities.writePaint(this.fillPaint, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.outlineStroke, objectOutputStream);
        SerialUtilities.writeShape(this.line, objectOutputStream);
        SerialUtilities.writePaint(this.linePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.lineStroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.shape = SerialUtilities.readShape(objectInputStream);
        this.fillPaint = SerialUtilities.readPaint(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.line = SerialUtilities.readShape(objectInputStream);
        this.linePaint = SerialUtilities.readPaint(objectInputStream);
        this.lineStroke = SerialUtilities.readStroke(objectInputStream);
    }
}

