/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.general.PieDataset;

public class StandardPieURLGenerator
implements PieURLGenerator,
Serializable {
    private static final long serialVersionUID = 1626966402065883419L;
    private String prefix = "index.html";
    private String categoryParameterName = "category";
    private String indexParameterName = "pieIndex";

    public StandardPieURLGenerator() {
    }

    public StandardPieURLGenerator(String string) {
        this.prefix = string;
    }

    public StandardPieURLGenerator(String string, String string2) {
        this.prefix = string;
        this.categoryParameterName = string2;
    }

    public StandardPieURLGenerator(String string, String string2, String string3) {
        this.prefix = string;
        this.categoryParameterName = string2;
        this.indexParameterName = string3;
    }

    public String generateURL(PieDataset pieDataset, Comparable comparable, int n) {
        String string = this.prefix;
        string = string.indexOf("?") > -1 ? string + "&amp;" + this.categoryParameterName + "=" + comparable.toString() : string + "?" + this.categoryParameterName + "=" + comparable.toString();
        if (this.indexParameterName != null) {
            string = string + "&amp;" + this.indexParameterName + "=" + String.valueOf(n);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardPieURLGenerator)) {
            return false;
        }
        StandardPieURLGenerator standardPieURLGenerator = (StandardPieURLGenerator)object;
        return this.categoryParameterName.equals(standardPieURLGenerator.categoryParameterName) && this.prefix.equals(standardPieURLGenerator.prefix);
    }
}

