/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.Values2D;

public abstract class DataUtilities {
    public static final double calculateColumnTotal(Values2D values2D, int n) {
        double d2 = 0.0;
        int n2 = values2D.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Number number = values2D.getValue(i2, n);
            if (number == null) continue;
            d2 += number.doubleValue();
        }
        return d2;
    }

    public static final double calculateRowTotal(Values2D values2D, int n) {
        double d2 = 0.0;
        int n2 = values2D.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Number number = values2D.getValue(n, i2);
            if (number == null) continue;
            d2 += number.doubleValue();
        }
        return d2;
    }

    public static final Number[] createNumberArray(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        Number[] numberArray = new Number[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            numberArray[i2] = new Double(dArray[i2]);
        }
        return numberArray;
    }

    public static final Number[][] createNumberArray2D(double[][] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        int n = dArray.length;
        Number[][] numberArray = new Number[n][];
        for (int i2 = 0; i2 < n; ++i2) {
            numberArray[i2] = DataUtilities.createNumberArray(dArray[i2]);
        }
        return numberArray;
    }

    public static final KeyedValues getCumulativePercentages(KeyedValues keyedValues) {
        if (keyedValues == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        double d2 = 0.0;
        for (int i2 = 0; i2 < keyedValues.getItemCount(); ++i2) {
            Number number = keyedValues.getValue(i2);
            if (number == null) continue;
            d2 += number.doubleValue();
        }
        double d3 = 0.0;
        for (int i3 = 0; i3 < keyedValues.getItemCount(); ++i3) {
            Number number = keyedValues.getValue(i3);
            if (number != null) {
                d3 += number.doubleValue();
            }
            defaultKeyedValues.addValue(keyedValues.getKey(i3), new Double(d3 / d2));
        }
        return defaultKeyedValues;
    }
}

