/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;

public strictfp class Range
implements Serializable {
    private static final long serialVersionUID = -906333695431863380L;
    private double lower;
    private double upper;

    public Range(double d2, double d3) {
        if (d2 > d3) {
            String string = "Range(double, double): require lower (" + d2 + ") <= upper (" + d3 + ").";
            throw new IllegalArgumentException(string);
        }
        this.lower = d2;
        this.upper = d3;
    }

    public double getLowerBound() {
        return this.lower;
    }

    public double getUpperBound() {
        return this.upper;
    }

    public double getLength() {
        return this.upper - this.lower;
    }

    public double getCentralValue() {
        return this.lower / 2.0 + this.upper / 2.0;
    }

    public boolean contains(double d2) {
        return d2 >= this.lower && d2 <= this.upper;
    }

    public boolean intersects(double d2, double d3) {
        if (d2 <= this.lower) {
            return d3 > this.lower;
        }
        return d2 < this.upper && d3 >= d2;
    }

    public double constrain(double d2) {
        double d3 = d2;
        if (!this.contains(d2)) {
            if (d2 > this.upper) {
                d3 = this.upper;
            } else if (d2 < this.lower) {
                d3 = this.lower;
            }
        }
        return d3;
    }

    public static Range combine(Range range, Range range2) {
        if (range == null) {
            return range2;
        }
        if (range2 == null) {
            return range;
        }
        double d2 = Math.min(range.getLowerBound(), range2.getLowerBound());
        double d3 = Math.max(range.getUpperBound(), range2.getUpperBound());
        return new Range(d2, d3);
    }

    public static Range expandToInclude(Range range, double d2) {
        if (range == null) {
            return new Range(d2, d2);
        }
        if (d2 < range.getLowerBound()) {
            return new Range(d2, range.getUpperBound());
        }
        if (d2 > range.getUpperBound()) {
            return new Range(range.getLowerBound(), d2);
        }
        return range;
    }

    public static Range expand(Range range, double d2, double d3) {
        if (range == null) {
            throw new IllegalArgumentException("Null 'range' argument.");
        }
        double d4 = range.getLength();
        double d5 = d4 * d2;
        double d6 = d4 * d3;
        return new Range(range.getLowerBound() - d5, range.getUpperBound() + d6);
    }

    public static Range shift(Range range, double d2) {
        return Range.shift(range, d2, false);
    }

    public static Range shift(Range range, double d2, boolean bl) {
        if (bl) {
            return new Range(range.getLowerBound() + d2, range.getUpperBound() + d2);
        }
        return new Range(Range.shiftWithNoZeroCrossing(range.getLowerBound(), d2), Range.shiftWithNoZeroCrossing(range.getUpperBound(), d2));
    }

    private static double shiftWithNoZeroCrossing(double d2, double d3) {
        if (d2 > 0.0) {
            return Math.max(d2 + d3, 0.0);
        }
        if (d2 < 0.0) {
            return Math.min(d2 + d3, 0.0);
        }
        return d2 + d3;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        if (this.lower != range.lower) {
            return false;
        }
        return this.upper == range.upper;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.lower);
        int n = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.upper);
        n = 29 * n + (int)(l2 ^ l2 >>> 32);
        return n;
    }

    public String toString() {
        return "Range[" + this.lower + "," + this.upper + "]";
    }
}

