/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.category;

import java.util.Collections;
import java.util.List;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.PieDataset;
import org.jfree.util.TableOrder;

public class CategoryToPieDataset
extends AbstractDataset
implements PieDataset,
DatasetChangeListener {
    static final long serialVersionUID = 5516396319762189617L;
    private CategoryDataset source;
    private TableOrder extract;
    private int index;

    public CategoryToPieDataset(CategoryDataset categoryDataset, TableOrder tableOrder, int n) {
        if (tableOrder == null) {
            throw new IllegalArgumentException("Null 'extract' argument.");
        }
        this.source = categoryDataset;
        if (this.source != null) {
            this.source.addChangeListener(this);
        }
        this.extract = tableOrder;
        this.index = n;
    }

    public final CategoryDataset getUnderlyingDataset() {
        return this.source;
    }

    public final TableOrder getExtractType() {
        return this.extract;
    }

    public final int getExtractIndex() {
        return this.index;
    }

    public final int getItemCount() {
        int n = 0;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                n = this.source.getColumnCount();
            } else if (this.extract == TableOrder.BY_COLUMN) {
                n = this.source.getRowCount();
            }
        }
        return n;
    }

    public final Number getValue(int n) {
        Number number = null;
        if (n < 0 || n >= this.getItemCount()) {
            throw new IndexOutOfBoundsException("The 'item' index is out of bounds.");
        }
        if (this.extract == TableOrder.BY_ROW) {
            number = this.source.getValue(this.index, n);
        } else if (this.extract == TableOrder.BY_COLUMN) {
            number = this.source.getValue(n, this.index);
        }
        return number;
    }

    public final Comparable getKey(int n) {
        Comparable comparable = null;
        if (n < 0 || n >= this.getItemCount()) {
            throw new IndexOutOfBoundsException("Invalid 'index': " + n);
        }
        if (this.extract == TableOrder.BY_ROW) {
            comparable = this.source.getColumnKey(n);
        } else if (this.extract == TableOrder.BY_COLUMN) {
            comparable = this.source.getRowKey(n);
        }
        return comparable;
    }

    public final int getIndex(Comparable comparable) {
        int n = -1;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                n = this.source.getColumnIndex(comparable);
            } else if (this.extract == TableOrder.BY_COLUMN) {
                n = this.source.getRowIndex(comparable);
            }
        }
        return n;
    }

    public final List getKeys() {
        List list = Collections.EMPTY_LIST;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                list = this.source.getColumnKeys();
            } else if (this.extract == TableOrder.BY_COLUMN) {
                list = this.source.getRowKeys();
            }
        }
        return list;
    }

    public final Number getValue(Comparable comparable) {
        Number number = null;
        int n = this.getIndex(comparable);
        if (n != -1) {
            if (this.extract == TableOrder.BY_ROW) {
                number = this.source.getValue(this.index, n);
            } else if (this.extract == TableOrder.BY_COLUMN) {
                number = this.source.getValue(n, this.index);
            }
        }
        return number;
    }

    public final void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.fireDatasetChanged();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PieDataset)) {
            return false;
        }
        PieDataset pieDataset = (PieDataset)object;
        int n = this.getItemCount();
        if (pieDataset.getItemCount() != n) {
            return false;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            Comparable comparable;
            Comparable comparable2 = this.getKey(i2);
            if (!comparable2.equals(comparable = pieDataset.getKey(i2))) {
                return false;
            }
            Number number = this.getValue(i2);
            Number number2 = pieDataset.getValue(i2);
            if (!(number == null ? number2 != null : !number.equals(number2))) continue;
            return false;
        }
        return true;
    }
}

