/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.DomainInfo;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.KeyedValues;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.function.Function2D;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.util.ArrayUtilities;

public final class DatasetUtilities {
    private DatasetUtilities() {
    }

    public static final double calculatePieDatasetTotal(PieDataset pieDataset) {
        if (pieDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        List list = pieDataset.getKeys();
        double d2 = 0.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Comparable comparable = (Comparable)iterator.next();
            if (comparable == null) continue;
            Number number = pieDataset.getValue(comparable);
            double d3 = 0.0;
            if (number != null) {
                d3 = number.doubleValue();
            }
            if (!(d3 > 0.0)) continue;
            d2 += d3;
        }
        return d2;
    }

    public static final PieDataset createPieDatasetForRow(CategoryDataset categoryDataset, Comparable comparable) {
        int n = categoryDataset.getRowIndex(comparable);
        return DatasetUtilities.createPieDatasetForRow(categoryDataset, n);
    }

    public static final PieDataset createPieDatasetForRow(CategoryDataset categoryDataset, int n) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        int n2 = categoryDataset.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Comparable comparable = categoryDataset.getColumnKey(i2);
            defaultPieDataset.setValue(comparable, categoryDataset.getValue(n, i2));
        }
        return defaultPieDataset;
    }

    public static final PieDataset createPieDatasetForColumn(CategoryDataset categoryDataset, Comparable comparable) {
        int n = categoryDataset.getColumnIndex(comparable);
        return DatasetUtilities.createPieDatasetForColumn(categoryDataset, n);
    }

    public static final PieDataset createPieDatasetForColumn(CategoryDataset categoryDataset, int n) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        int n2 = categoryDataset.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Comparable comparable = categoryDataset.getRowKey(i2);
            defaultPieDataset.setValue(comparable, categoryDataset.getValue(i2, n));
        }
        return defaultPieDataset;
    }

    public static final PieDataset createConsolidatedPieDataset(PieDataset pieDataset, Comparable comparable, double d2) {
        return DatasetUtilities.createConsolidatedPieDataset(pieDataset, comparable, d2, 2);
    }

    public static final PieDataset createConsolidatedPieDataset(PieDataset pieDataset, Comparable comparable, double d2, int n) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        double d3 = DatasetUtilities.calculatePieDatasetTotal(pieDataset);
        List list = pieDataset.getKeys();
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            double d4;
            Comparable comparable2 = (Comparable)iterator.next();
            Number number = pieDataset.getValue(comparable2);
            if (number == null || !((d4 = number.doubleValue()) / d3 < d2)) continue;
            arrayList.add(comparable2);
        }
        iterator = list.iterator();
        double d5 = 0.0;
        while (iterator.hasNext()) {
            Comparable comparable3 = (Comparable)iterator.next();
            Number number = pieDataset.getValue(comparable3);
            if (number == null) continue;
            if (arrayList.contains(comparable3) && arrayList.size() >= n) {
                d5 += number.doubleValue();
                continue;
            }
            defaultPieDataset.setValue(comparable3, number);
        }
        if (arrayList.size() >= n) {
            defaultPieDataset.setValue(comparable, d5);
        }
        return defaultPieDataset;
    }

    public static final CategoryDataset createCategoryDataset(String string, String string2, double[][] dArray) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            String string3 = string + (i2 + 1);
            for (int i3 = 0; i3 < dArray[i2].length; ++i3) {
                String string4 = string2 + (i3 + 1);
                defaultCategoryDataset.addValue(new Double(dArray[i2][i3]), (Comparable)((Object)string3), (Comparable)((Object)string4));
            }
        }
        return defaultCategoryDataset;
    }

    public static final CategoryDataset createCategoryDataset(String string, String string2, Number[][] numberArray) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i2 = 0; i2 < numberArray.length; ++i2) {
            String string3 = string + (i2 + 1);
            for (int i3 = 0; i3 < numberArray[i2].length; ++i3) {
                String string4 = string2 + (i3 + 1);
                defaultCategoryDataset.addValue(numberArray[i2][i3], (Comparable)((Object)string3), (Comparable)((Object)string4));
            }
        }
        return defaultCategoryDataset;
    }

    public static final CategoryDataset createCategoryDataset(Comparable[] comparableArray, Comparable[] comparableArray2, double[][] dArray) {
        if (comparableArray == null) {
            throw new IllegalArgumentException("Null 'rowKeys' argument.");
        }
        if (comparableArray2 == null) {
            throw new IllegalArgumentException("Null 'columnKeys' argument.");
        }
        if (ArrayUtilities.hasDuplicateItems(comparableArray)) {
            throw new IllegalArgumentException("Duplicate items in 'rowKeys'.");
        }
        if (ArrayUtilities.hasDuplicateItems(comparableArray2)) {
            throw new IllegalArgumentException("Duplicate items in 'columnKeys'.");
        }
        if (comparableArray.length != dArray.length) {
            throw new IllegalArgumentException("The number of row keys does not match the number of rows in the data array.");
        }
        int n = 0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            n = Math.max(n, dArray[i2].length);
        }
        if (comparableArray2.length != n) {
            throw new IllegalArgumentException("The number of column keys does not match the number of columns in the data array.");
        }
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i3 = 0; i3 < dArray.length; ++i3) {
            Comparable comparable = comparableArray[i3];
            for (int i4 = 0; i4 < dArray[i3].length; ++i4) {
                Comparable comparable2 = comparableArray2[i4];
                defaultCategoryDataset.addValue(new Double(dArray[i3][i4]), comparable, comparable2);
            }
        }
        return defaultCategoryDataset;
    }

    public static final CategoryDataset createCategoryDataset(Comparable comparable, KeyedValues keyedValues) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'rowKey' argument.");
        }
        if (keyedValues == null) {
            throw new IllegalArgumentException("Null 'rowData' argument.");
        }
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i2 = 0; i2 < keyedValues.getItemCount(); ++i2) {
            defaultCategoryDataset.addValue(keyedValues.getValue(i2), comparable, keyedValues.getKey(i2));
        }
        return defaultCategoryDataset;
    }

    public static final XYDataset sampleFunction2D(Function2D function2D, double d2, double d3, int n, Comparable comparable) {
        if (function2D == null) {
            throw new IllegalArgumentException("Null 'f' argument.");
        }
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'seriesKey' argument.");
        }
        if (d2 >= d3) {
            throw new IllegalArgumentException("Requires 'start' < 'end'.");
        }
        if (n < 2) {
            throw new IllegalArgumentException("Requires 'samples' > 1");
        }
        XYSeries xYSeries = new XYSeries(comparable);
        double d4 = (d3 - d2) / (double)n;
        for (int i2 = 0; i2 <= n; ++i2) {
            double d5 = d2 + d4 * (double)i2;
            xYSeries.add(d5, function2D.getValue(d5));
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        return xYSeriesCollection;
    }

    public static final boolean isEmptyOrNull(PieDataset pieDataset) {
        if (pieDataset == null) {
            return true;
        }
        int n = pieDataset.getItemCount();
        if (n == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            double d2;
            Number number = pieDataset.getValue(i2);
            if (number == null || !((d2 = number.doubleValue()) > 0.0)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isEmptyOrNull(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            return true;
        }
        int n = categoryDataset.getRowCount();
        int n2 = categoryDataset.getColumnCount();
        if (n == 0 || n2 == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (categoryDataset.getValue(i2, i3) == null) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean isEmptyOrNull(XYDataset xYDataset) {
        boolean bl = true;
        if (xYDataset != null) {
            for (int i2 = 0; i2 < xYDataset.getSeriesCount(); ++i2) {
                if (xYDataset.getItemCount(i2) <= 0) continue;
                bl = false;
            }
        }
        return bl;
    }

    public static final Range findDomainBounds(XYDataset xYDataset) {
        return DatasetUtilities.findDomainBounds(xYDataset, true);
    }

    public static final Range findDomainBounds(XYDataset xYDataset, boolean bl) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range range = null;
        if (xYDataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)xYDataset);
            range = domainInfo.getDomainBounds(bl);
        } else {
            range = DatasetUtilities.iterateDomainBounds(xYDataset, bl);
        }
        return range;
    }

    public static final Range iterateDomainBounds(XYDataset xYDataset) {
        return DatasetUtilities.iterateDomainBounds(xYDataset, true);
    }

    public static final Range iterateDomainBounds(XYDataset xYDataset, boolean bl) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        if (bl && xYDataset instanceof IntervalXYDataset) {
            IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
            for (int i2 = 0; i2 < n; ++i2) {
                int n2 = xYDataset.getItemCount(i2);
                for (int i3 = 0; i3 < n2; ++i3) {
                    double d4 = intervalXYDataset.getStartXValue(i2, i3);
                    double d5 = intervalXYDataset.getEndXValue(i2, i3);
                    d2 = Math.min(d2, d4);
                    d3 = Math.max(d3, d5);
                }
            }
        } else {
            for (int i4 = 0; i4 < n; ++i4) {
                int n3 = xYDataset.getItemCount(i4);
                for (int i5 = 0; i5 < n3; ++i5) {
                    double d6;
                    double d7 = d6 = xYDataset.getXValue(i4, i5);
                    d2 = Math.min(d2, d6);
                    d3 = Math.max(d3, d7);
                }
            }
        }
        if (d2 > d3) {
            return null;
        }
        return new Range(d2, d3);
    }

    public static final Range findRangeBounds(CategoryDataset categoryDataset) {
        return DatasetUtilities.findRangeBounds(categoryDataset, true);
    }

    public static final Range findRangeBounds(CategoryDataset categoryDataset, boolean bl) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range range = null;
        if (categoryDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)categoryDataset);
            range = rangeInfo.getRangeBounds(bl);
        } else {
            range = DatasetUtilities.iterateCategoryRangeBounds(categoryDataset, bl);
        }
        return range;
    }

    public static final Range findRangeBounds(XYDataset xYDataset) {
        return DatasetUtilities.findRangeBounds(xYDataset, true);
    }

    public static final Range findRangeBounds(XYDataset xYDataset, boolean bl) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range range = null;
        if (xYDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)xYDataset);
            range = rangeInfo.getRangeBounds(bl);
        } else {
            range = DatasetUtilities.iterateXYRangeBounds(xYDataset);
        }
        return range;
    }

    public static final Range iterateCategoryRangeBounds(CategoryDataset categoryDataset, boolean bl) {
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        boolean bl2 = bl && categoryDataset instanceof IntervalCategoryDataset;
        int n = categoryDataset.getRowCount();
        int n2 = categoryDataset.getColumnCount();
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                Number number;
                Number number2;
                if (bl2) {
                    IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
                    number2 = intervalCategoryDataset.getStartValue(i2, i3);
                    number = intervalCategoryDataset.getEndValue(i2, i3);
                } else {
                    number = number2 = categoryDataset.getValue(i2, i3);
                }
                if (number2 != null) {
                    d2 = Math.min(d2, number2.doubleValue());
                }
                if (number == null) continue;
                d3 = Math.max(d3, number.doubleValue());
            }
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d2, d3);
    }

    public static final Range iterateXYRangeBounds(XYDataset xYDataset) {
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = xYDataset.getItemCount(i2);
            for (int i3 = 0; i3 < n2; ++i3) {
                double d4;
                double d5;
                XYDataset xYDataset2;
                if (xYDataset instanceof IntervalXYDataset) {
                    xYDataset2 = (IntervalXYDataset)xYDataset;
                    d5 = xYDataset2.getStartYValue(i2, i3);
                    d4 = xYDataset2.getEndYValue(i2, i3);
                } else if (xYDataset instanceof OHLCDataset) {
                    xYDataset2 = (OHLCDataset)xYDataset;
                    d5 = xYDataset2.getLowValue(i2, i3);
                    d4 = xYDataset2.getHighValue(i2, i3);
                } else {
                    d4 = d5 = xYDataset.getYValue(i2, i3);
                }
                if (!Double.isNaN(d5)) {
                    d2 = Math.min(d2, d5);
                }
                if (Double.isNaN(d4)) continue;
                d3 = Math.max(d3, d4);
            }
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d2, d3);
    }

    public static final Number findMinimumDomainValue(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Double d2 = null;
        if (xYDataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)xYDataset);
            return new Double(domainInfo.getDomainLowerBound(true));
        }
        double d3 = Double.POSITIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = xYDataset.getItemCount(i2);
            for (int i3 = 0; i3 < n2; ++i3) {
                double d4;
                if (xYDataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
                    d4 = intervalXYDataset.getStartXValue(i2, i3);
                } else {
                    d4 = xYDataset.getXValue(i2, i3);
                }
                if (Double.isNaN(d4)) continue;
                d3 = Math.min(d3, d4);
            }
        }
        d2 = d3 == Double.POSITIVE_INFINITY ? null : new Double(d3);
        return d2;
    }

    public static final Number findMaximumDomainValue(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Double d2 = null;
        if (xYDataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)xYDataset);
            return new Double(domainInfo.getDomainUpperBound(true));
        }
        double d3 = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = xYDataset.getItemCount(i2);
            for (int i3 = 0; i3 < n2; ++i3) {
                double d4;
                if (xYDataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
                    d4 = intervalXYDataset.getEndXValue(i2, i3);
                } else {
                    d4 = xYDataset.getXValue(i2, i3);
                }
                if (Double.isNaN(d4)) continue;
                d3 = Math.max(d3, d4);
            }
        }
        d2 = d3 == Double.NEGATIVE_INFINITY ? null : new Double(d3);
        return d2;
    }

    public static final Number findMinimumRangeValue(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (categoryDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)categoryDataset);
            return new Double(rangeInfo.getRangeLowerBound(true));
        }
        double d2 = Double.POSITIVE_INFINITY;
        int n = categoryDataset.getRowCount();
        int n2 = categoryDataset.getColumnCount();
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                Number number;
                if (categoryDataset instanceof IntervalCategoryDataset) {
                    IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
                    number = intervalCategoryDataset.getStartValue(i2, i3);
                } else {
                    number = categoryDataset.getValue(i2, i3);
                }
                if (number == null) continue;
                d2 = Math.min(d2, number.doubleValue());
            }
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Double(d2);
    }

    public static final Number findMinimumRangeValue(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (xYDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)xYDataset);
            return new Double(rangeInfo.getRangeLowerBound(true));
        }
        double d2 = Double.POSITIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = xYDataset.getItemCount(i2);
            for (int i3 = 0; i3 < n2; ++i3) {
                double d3;
                XYDataset xYDataset2;
                if (xYDataset instanceof IntervalXYDataset) {
                    xYDataset2 = (IntervalXYDataset)xYDataset;
                    d3 = xYDataset2.getStartYValue(i2, i3);
                } else if (xYDataset instanceof OHLCDataset) {
                    xYDataset2 = (OHLCDataset)xYDataset;
                    d3 = xYDataset2.getLowValue(i2, i3);
                } else {
                    d3 = xYDataset.getYValue(i2, i3);
                }
                if (Double.isNaN(d3)) continue;
                d2 = Math.min(d2, d3);
            }
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Double(d2);
    }

    public static final Number findMaximumRangeValue(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (categoryDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)categoryDataset);
            return new Double(rangeInfo.getRangeUpperBound(true));
        }
        double d2 = Double.NEGATIVE_INFINITY;
        int n = categoryDataset.getRowCount();
        int n2 = categoryDataset.getColumnCount();
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                Number number;
                if (categoryDataset instanceof IntervalCategoryDataset) {
                    IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
                    number = intervalCategoryDataset.getEndValue(i2, i3);
                } else {
                    number = categoryDataset.getValue(i2, i3);
                }
                if (number == null) continue;
                d2 = Math.max(d2, number.doubleValue());
            }
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return new Double(d2);
    }

    public static final Number findMaximumRangeValue(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        if (xYDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)xYDataset);
            return new Double(rangeInfo.getRangeUpperBound(true));
        }
        double d2 = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        for (int i2 = 0; i2 < n; ++i2) {
            int n2 = xYDataset.getItemCount(i2);
            for (int i3 = 0; i3 < n2; ++i3) {
                double d3;
                XYDataset xYDataset2;
                if (xYDataset instanceof IntervalXYDataset) {
                    xYDataset2 = (IntervalXYDataset)xYDataset;
                    d3 = xYDataset2.getEndYValue(i2, i3);
                } else if (xYDataset instanceof OHLCDataset) {
                    xYDataset2 = (OHLCDataset)xYDataset;
                    d3 = xYDataset2.getHighValue(i2, i3);
                } else {
                    d3 = xYDataset.getYValue(i2, i3);
                }
                if (Double.isNaN(d3)) continue;
                d2 = Math.max(d2, d3);
            }
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return new Double(d2);
    }

    public static final Range findStackedRangeBounds(CategoryDataset categoryDataset) {
        return DatasetUtilities.findStackedRangeBounds(categoryDataset, 0.0);
    }

    public static final Range findStackedRangeBounds(CategoryDataset categoryDataset, double d2) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        Range range = null;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        int n = categoryDataset.getColumnCount();
        for (int i2 = 0; i2 < n; ++i2) {
            double d5 = d2;
            double d6 = d2;
            int n2 = categoryDataset.getRowCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                Number number = categoryDataset.getValue(i3, i2);
                if (number == null) continue;
                double d7 = number.doubleValue();
                if (d7 > 0.0) {
                    d5 += d7;
                }
                if (!(d7 < 0.0)) continue;
                d6 += d7;
            }
            d3 = Math.min(d3, d6);
            d4 = Math.max(d4, d5);
        }
        if (d3 <= d4) {
            range = new Range(d3, d4);
        }
        return range;
    }

    public static final Range findStackedRangeBounds(CategoryDataset categoryDataset, KeyToGroupMap keyToGroupMap) {
        Range range = null;
        if (categoryDataset != null) {
            int n;
            int n2;
            int[] nArray = new int[categoryDataset.getRowCount()];
            for (n2 = 0; n2 < categoryDataset.getRowCount(); ++n2) {
                nArray[n2] = keyToGroupMap.getGroupIndex(keyToGroupMap.getGroup(categoryDataset.getRowKey(n2)));
            }
            n2 = keyToGroupMap.getGroupCount();
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            int n3 = categoryDataset.getColumnCount();
            for (n = 0; n < n3; ++n) {
                int n4;
                double[] dArray3 = new double[n2];
                double[] dArray4 = new double[n2];
                int n5 = categoryDataset.getRowCount();
                for (n4 = 0; n4 < n5; ++n4) {
                    Number number = categoryDataset.getValue(n4, n);
                    if (number == null) continue;
                    double d2 = number.doubleValue();
                    if (d2 > 0.0) {
                        dArray3[nArray[n4]] = dArray3[nArray[n4]] + d2;
                    }
                    if (!(d2 < 0.0)) continue;
                    dArray4[nArray[n4]] = dArray4[nArray[n4]] + d2;
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    dArray[n4] = Math.min(dArray[n4], dArray4[n4]);
                    dArray2[n4] = Math.max(dArray2[n4], dArray3[n4]);
                }
            }
            for (n = 0; n < n2; ++n) {
                range = Range.combine(range, new Range(dArray[n], dArray2[n]));
            }
        }
        return range;
    }

    public static final Number findMinimumStackedRangeValue(CategoryDataset categoryDataset) {
        Double d2 = null;
        if (categoryDataset != null) {
            double d3 = 0.0;
            int n = categoryDataset.getRowCount();
            for (int i2 = 0; i2 < n; ++i2) {
                double d4 = 0.0;
                int n2 = categoryDataset.getColumnCount();
                for (int i3 = 0; i3 < n2; ++i3) {
                    double d5;
                    Number number = categoryDataset.getValue(i3, i2);
                    if (number == null || !((d5 = number.doubleValue()) < 0.0)) continue;
                    d4 += d5;
                }
                d3 = Math.min(d3, d4);
            }
            d2 = new Double(d3);
        }
        return d2;
    }

    public static final Number findMaximumStackedRangeValue(CategoryDataset categoryDataset) {
        Double d2 = null;
        if (categoryDataset != null) {
            double d3 = 0.0;
            int n = categoryDataset.getColumnCount();
            for (int i2 = 0; i2 < n; ++i2) {
                double d4 = 0.0;
                int n2 = categoryDataset.getRowCount();
                for (int i3 = 0; i3 < n2; ++i3) {
                    double d5;
                    Number number = categoryDataset.getValue(i3, i2);
                    if (number == null || !((d5 = number.doubleValue()) > 0.0)) continue;
                    d4 += d5;
                }
                d3 = Math.max(d3, d4);
            }
            d2 = new Double(d3);
        }
        return d2;
    }

    public static final Range findStackedRangeBounds(TableXYDataset tableXYDataset) {
        return DatasetUtilities.findStackedRangeBounds(tableXYDataset, 0.0);
    }

    public static final Range findStackedRangeBounds(TableXYDataset tableXYDataset, double d2) {
        if (tableXYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double d3 = d2;
        double d4 = d2;
        for (int i2 = 0; i2 < tableXYDataset.getItemCount(); ++i2) {
            double d5 = d2;
            double d6 = d2;
            int n = tableXYDataset.getSeriesCount();
            for (int i3 = 0; i3 < n; ++i3) {
                double d7 = tableXYDataset.getYValue(i3, i2);
                if (Double.isNaN(d7)) continue;
                if (d7 > 0.0) {
                    d5 += d7;
                    continue;
                }
                d6 += d7;
            }
            if (d5 > d4) {
                d4 = d5;
            }
            if (!(d6 < d3)) continue;
            d3 = d6;
        }
        if (d3 <= d4) {
            return new Range(d3, d4);
        }
        return null;
    }

    public static final Range findCumulativeRangeBounds(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        boolean bl = true;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < categoryDataset.getRowCount(); ++i2) {
            double d4 = 0.0;
            for (int i3 = 0; i3 < categoryDataset.getColumnCount() - 1; ++i3) {
                Number number = categoryDataset.getValue(i2, i3);
                if (number == null) continue;
                bl = false;
                double d5 = number.doubleValue();
                d2 = Math.min(d2, d4 += d5);
                d3 = Math.max(d3, d4);
            }
        }
        if (!bl) {
            return new Range(d2, d3);
        }
        return null;
    }
}

