/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.util.Set;
import java.util.TreeSet;
import org.jfree.data.DefaultKeyedValues2D;
import org.jfree.data.general.AbstractDataset;

public class WaferMapDataset
extends AbstractDataset {
    private DefaultKeyedValues2D data;
    private int maxChipX;
    private int maxChipY;
    private double chipSpace;
    private Double maxValue = new Double(Double.NEGATIVE_INFINITY);
    private Double minValue = new Double(Double.POSITIVE_INFINITY);
    private static final double DEFAULT_CHIP_SPACE = 1.0;

    public WaferMapDataset(int n, int n2) {
        this(n, n2, null);
    }

    public WaferMapDataset(int n, int n2, Number number) {
        this.data = new DefaultKeyedValues2D();
        this.maxChipX = n;
        this.maxChipY = n2;
        this.chipSpace = number == null ? 1.0 : number.doubleValue();
    }

    public final void addValue(Number number, Comparable comparable, Comparable comparable2) {
        this.setValue(number, comparable, comparable2);
    }

    public final void addValue(int n, int n2, int n3) {
        this.setValue(new Double(n), new Integer(n2), new Integer(n3));
    }

    public final void setValue(Number number, Comparable comparable, Comparable comparable2) {
        this.data.setValue(number, comparable, comparable2);
        if (this.isMaxValue(number)) {
            this.maxValue = (Double)number;
        }
        if (this.isMinValue(number)) {
            this.minValue = (Double)number;
        }
    }

    public final int getUniqueValueCount() {
        return this.getUniqueValues().size();
    }

    public final Set getUniqueValues() {
        TreeSet<Number> treeSet = new TreeSet<Number>();
        for (int i2 = 0; i2 < this.data.getRowCount(); ++i2) {
            for (int i3 = 0; i3 < this.data.getColumnCount(); ++i3) {
                Number number = this.data.getValue(i2, i3);
                if (number == null) continue;
                treeSet.add(number);
            }
        }
        return treeSet;
    }

    public final Number getChipValue(int n, int n2) {
        return this.getChipValue(new Integer(n), new Integer(n2));
    }

    public final Number getChipValue(Comparable comparable, Comparable comparable2) {
        int n = this.data.getRowIndex(comparable);
        if (n < 0) {
            return null;
        }
        int n2 = this.data.getColumnIndex(comparable2);
        if (n2 < 0) {
            return null;
        }
        return this.data.getValue(n, n2);
    }

    public final boolean isMaxValue(Number number) {
        return number.doubleValue() > this.maxValue;
    }

    public final boolean isMinValue(Number number) {
        return number.doubleValue() < this.minValue;
    }

    public final Number getMaxValue() {
        return this.maxValue;
    }

    public final Number getMinValue() {
        return this.minValue;
    }

    public final int getMaxChipX() {
        return this.maxChipX;
    }

    public final void setMaxChipX(int n) {
        this.maxChipX = n;
    }

    public final int getMaxChipY() {
        return this.maxChipY;
    }

    public final void setMaxChipY(int n) {
        this.maxChipY = n;
    }

    public final double getChipSpace() {
        return this.chipSpace;
    }

    public final void setChipSpace(double d2) {
        this.chipSpace = d2;
    }
}

