/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.io.Serializable;

public class HistogramBin
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7614685080015589931L;
    private int count;
    private double startBoundary;
    private double endBoundary;

    public HistogramBin(double d2, double d3) {
        if (d2 > d3) {
            throw new IllegalArgumentException("HistogramBin():  startBoundary > endBoundary.");
        }
        this.count = 0;
        this.startBoundary = d2;
        this.endBoundary = d3;
    }

    public int getCount() {
        return this.count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public double getStartBoundary() {
        return this.startBoundary;
    }

    public double getEndBoundary() {
        return this.endBoundary;
    }

    public double getBinWidth() {
        return this.endBoundary - this.startBoundary;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof HistogramBin) {
            HistogramBin histogramBin = (HistogramBin)object;
            boolean bl = histogramBin.startBoundary == this.startBoundary;
            boolean bl2 = histogramBin.endBoundary == this.endBoundary;
            boolean bl3 = histogramBin.count == this.count;
            return bl && bl2 && bl3;
        }
        return false;
    }

    public Object clone() {
        return super.clone();
    }
}

