/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.statistics.HistogramBin;
import org.jfree.data.statistics.HistogramType;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class HistogramDataset
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -6341668077370231153L;
    private List list = new ArrayList();
    private HistogramType type = HistogramType.FREQUENCY;

    public HistogramType getType() {
        return this.type;
    }

    public void setType(HistogramType histogramType) {
        if (histogramType == null) {
            throw new IllegalArgumentException("Null 'type' argument");
        }
        this.type = histogramType;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    public void addSeries(Comparable comparable, double[] dArray, int n) {
        double d2 = this.getMinimum(dArray);
        double d3 = this.getMaximum(dArray);
        this.addSeries(comparable, dArray, n, d2, d3);
    }

    public void addSeries(Comparable comparable, double[] dArray, int n, double d2, double d3) {
        int n2;
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        if (dArray == null) {
            throw new IllegalArgumentException("Null 'values' argument.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("The 'bins' value must be at least 1.");
        }
        double d4 = (d3 - d2) / (double)n;
        double d5 = d2;
        ArrayList<HistogramBin> arrayList = new ArrayList<HistogramBin>(n);
        for (n2 = 0; n2 < n; ++n2) {
            HistogramBin histogramBin;
            if (n2 == n - 1) {
                histogramBin = new HistogramBin(d5, d3);
            } else {
                double d6 = d2 + (double)(n2 + 1) * d4;
                histogramBin = new HistogramBin(d5, d6);
                d5 = d6;
            }
            arrayList.add(histogramBin);
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            int n3 = n - 1;
            if (dArray[n2] < d3) {
                double d7 = (dArray[n2] - d2) / (d3 - d2);
                if (d7 < 0.0) {
                    d7 = 0.0;
                }
                n3 = (int)(d7 * (double)n);
            }
            HistogramBin histogramBin = (HistogramBin)arrayList.get(n3);
            histogramBin.incrementCount();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("key", comparable);
        hashMap.put("bins", arrayList);
        hashMap.put("values.length", new Integer(dArray.length));
        hashMap.put("bin width", new Double(d4));
        this.list.add(hashMap);
    }

    private double getMinimum(double[] dArray) {
        if (dArray == null || dArray.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double d2 = Double.MAX_VALUE;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(dArray[i2] < d2)) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    private double getMaximum(double[] dArray) {
        if (dArray == null || dArray.length < 1) {
            throw new IllegalArgumentException("Null or zero length 'values' argument.");
        }
        double d2 = -1.7976931348623157E308;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(dArray[i2] > d2)) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    List getBins(int n) {
        Map map = (Map)this.list.get(n);
        return (List)map.get("bins");
    }

    private int getTotal(int n) {
        Map map = (Map)this.list.get(n);
        return (Integer)map.get("values.length");
    }

    private double getBinWidth(int n) {
        Map map = (Map)this.list.get(n);
        return (Double)map.get("bin width");
    }

    public int getSeriesCount() {
        return this.list.size();
    }

    public Comparable getSeriesKey(int n) {
        Map map = (Map)this.list.get(n);
        return (Comparable)map.get("key");
    }

    public int getItemCount(int n) {
        return this.getBins(n).size();
    }

    public Number getX(int n, int n2) {
        List list = this.getBins(n);
        HistogramBin histogramBin = (HistogramBin)list.get(n2);
        double d2 = (histogramBin.getStartBoundary() + histogramBin.getEndBoundary()) / 2.0;
        return new Double(d2);
    }

    public Number getY(int n, int n2) {
        List list = this.getBins(n);
        HistogramBin histogramBin = (HistogramBin)list.get(n2);
        double d2 = this.getTotal(n);
        double d3 = this.getBinWidth(n);
        if (this.type == HistogramType.FREQUENCY) {
            return new Double(histogramBin.getCount());
        }
        if (this.type == HistogramType.RELATIVE_FREQUENCY) {
            return new Double((double)histogramBin.getCount() / d2);
        }
        if (this.type == HistogramType.SCALE_AREA_TO_1) {
            return new Double((double)histogramBin.getCount() / (d3 * d2));
        }
        throw new IllegalStateException();
    }

    public Number getStartX(int n, int n2) {
        List list = this.getBins(n);
        HistogramBin histogramBin = (HistogramBin)list.get(n2);
        return new Double(histogramBin.getStartBoundary());
    }

    public Number getEndX(int n, int n2) {
        List list = this.getBins(n);
        HistogramBin histogramBin = (HistogramBin)list.get(n2);
        return new Double(histogramBin.getEndBoundary());
    }

    public Number getStartY(int n, int n2) {
        return this.getY(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.getY(n, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HistogramDataset)) {
            return false;
        }
        HistogramDataset histogramDataset = (HistogramDataset)object;
        if (!ObjectUtilities.equal(this.type, histogramDataset.type)) {
            return false;
        }
        return ObjectUtilities.equal(this.list, histogramDataset.list);
    }

    public Object clone() {
        return super.clone();
    }
}

