/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class LCBLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -2531780832406163833L;
    private static final int COLUMNS = 3;
    private int[] colWidth = new int[3];
    private int[] rowHeight;
    private int labelGap = 10;
    private int buttonGap = 6;
    private int vGap = 2;

    public LCBLayout(int n) {
        this.rowHeight = new int[n];
    }

    public void addLayoutComponent(Component component) {
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            Insets insets = container.getInsets();
            int n2 = container.getComponentCount();
            int n3 = n2 / 3;
            int n4 = 0;
            while (n4 < 3) {
                n = 0;
                while (n < n3) {
                    Component component = container.getComponent(n * 3 + n4);
                    Dimension dimension = component.getPreferredSize();
                    if (this.colWidth[n4] < dimension.width) {
                        this.colWidth[n4] = dimension.width;
                    }
                    if (this.rowHeight[n] < dimension.height) {
                        this.rowHeight[n] = dimension.height;
                    }
                    ++n;
                }
                ++n4;
            }
            n = this.vGap * (n3 - 1);
            int n5 = 0;
            while (n5 < n3) {
                n += this.rowHeight[n5];
                ++n5;
            }
            int n6 = this.colWidth[0] + this.colWidth[1] + this.colWidth[2];
            int n7 = container.getWidth() - insets.left - insets.right - this.labelGap - this.buttonGap;
            this.colWidth[1] = this.colWidth[1] + (n7 - n6);
            int n8 = insets.left;
            int n9 = 0;
            while (n9 < 3) {
                int n10 = insets.top;
                int n11 = 0;
                while (n11 < n3) {
                    int n12 = n11 * 3 + n9;
                    if (n12 < n2) {
                        Component component = container.getComponent(n12);
                        Dimension dimension = component.getPreferredSize();
                        int n13 = dimension.height;
                        int n14 = (this.rowHeight[n11] - n13) / 2;
                        container.getComponent(n12).setBounds(n8, n10 + n14, this.colWidth[n9], n13);
                    }
                    n10 = n10 + this.rowHeight[n11] + this.vGap;
                    ++n11;
                }
                n8 += this.colWidth[n9];
                if (n9 == 0) {
                    n8 += this.labelGap;
                }
                if (n9 == 1) {
                    n8 += this.buttonGap;
                }
                ++n9;
            }
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            Insets insets = container.getInsets();
            int n2 = container.getComponentCount();
            int n3 = n2 / 3;
            int n4 = 0;
            while (n4 < 3) {
                n = 0;
                while (n < n3) {
                    Component component = container.getComponent(n * 3 + n4);
                    Dimension dimension = component.getMinimumSize();
                    if (this.colWidth[n4] < dimension.width) {
                        this.colWidth[n4] = dimension.width;
                    }
                    if (this.rowHeight[n] < dimension.height) {
                        this.rowHeight[n] = dimension.height;
                    }
                    ++n;
                }
                ++n4;
            }
            n = this.vGap * (n3 - 1);
            int n5 = 0;
            while (n5 < n3) {
                n += this.rowHeight[n5];
                ++n5;
            }
            int n6 = this.colWidth[0] + this.labelGap + this.colWidth[1] + this.buttonGap + this.colWidth[2];
            Dimension dimension = new Dimension(insets.left + insets.right + n6 + this.labelGap + this.buttonGap, insets.top + insets.bottom + n + this.vGap);
            Object var4_13 = null;
            return dimension;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            Insets insets = container.getInsets();
            int n2 = container.getComponentCount();
            int n3 = n2 / 3;
            int n4 = 0;
            while (n4 < 3) {
                n = 0;
                while (n < n3) {
                    Component component = container.getComponent(n * 3 + n4);
                    Dimension dimension = component.getPreferredSize();
                    if (this.colWidth[n4] < dimension.width) {
                        this.colWidth[n4] = dimension.width;
                    }
                    if (this.rowHeight[n] < dimension.height) {
                        this.rowHeight[n] = dimension.height;
                    }
                    ++n;
                }
                ++n4;
            }
            n = this.vGap * (n3 - 1);
            int n5 = 0;
            while (n5 < n3) {
                n += this.rowHeight[n5];
                ++n5;
            }
            int n6 = this.colWidth[0] + this.labelGap + this.colWidth[1] + this.buttonGap + this.colWidth[2];
            Dimension dimension = new Dimension(insets.left + insets.right + n6 + this.labelGap + this.buttonGap, insets.top + insets.bottom + n + this.vGap);
            Object var4_13 = null;
            return dimension;
        }
    }

    public void removeLayoutComponent(Component component) {
    }

    public void removeLayoutComponent(String string, Component component) {
    }
}

