/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.jfree.util.ObjectUtilities;

public class AbstractObjectList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7789833772597351595L;
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    private transient Object[] objects;
    private int size = 0;
    private int increment = 8;

    protected AbstractObjectList() {
        this(8);
    }

    protected AbstractObjectList(int n) {
        this(n, n);
    }

    protected AbstractObjectList(int n, int n2) {
        this.objects = new Object[n];
        this.increment = n2;
    }

    public void clear() {
        Arrays.fill(this.objects, null);
        this.size = 0;
    }

    public Object clone() {
        AbstractObjectList abstractObjectList = (AbstractObjectList)super.clone();
        if (this.objects != null) {
            abstractObjectList.objects = new Object[this.objects.length];
            System.arraycopy(this.objects, 0, abstractObjectList.objects, 0, this.objects.length);
        }
        return abstractObjectList;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractObjectList)) {
            return false;
        }
        AbstractObjectList abstractObjectList = (AbstractObjectList)object;
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            if (!ObjectUtilities.equal(this.get(n2), abstractObjectList.get(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected Object get(int n) {
        Object object = null;
        if (n >= 0 && n < this.size) {
            object = this.objects[n];
        }
        return object;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected int indexOf(Object object) {
        int n = 0;
        while (n < this.size) {
            if (this.objects[n] == object) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.objects = new Object[this.size];
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            int n3 = objectInputStream.readInt();
            if (n3 != -1) {
                this.set(n3, objectInputStream.readObject());
            }
            ++n2;
        }
    }

    protected void set(int n, Object object) {
        if (n < 0) {
            throw new IllegalArgumentException("Requires index >= 0.");
        }
        if (n >= this.objects.length) {
            Object[] objectArray = new Object[n + this.increment];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            this.objects = objectArray;
        }
        this.objects[n] = object;
        this.size = Math.max(this.size, n + 1);
    }

    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        int n = this.size();
        objectOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            Object object = this.get(n2);
            if (object != null && object instanceof Serializable) {
                objectOutputStream.writeInt(n2);
                objectOutputStream.writeObject(object);
            } else {
                objectOutputStream.writeInt(-1);
            }
            ++n2;
        }
    }
}

