/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jfree.util.LogContext;
import org.jfree.util.LogTarget;

public class Log {
    private int debuglevel = 100;
    private LogTarget[] logTargets;
    private HashMap logContexts = new HashMap();
    private static Log singleton;

    protected Log() {
        this.logTargets = new LogTarget[0];
    }

    public synchronized void addTarget(LogTarget logTarget) {
        if (logTarget == null) {
            throw new NullPointerException();
        }
        LogTarget[] logTargetArray = new LogTarget[this.logTargets.length + 1];
        System.arraycopy(this.logTargets, 0, logTargetArray, 0, this.logTargets.length);
        logTargetArray[this.logTargets.length] = logTarget;
        this.logTargets = logTargetArray;
    }

    public static final LogContext createContext(Class clazz) {
        return Log.createContext(clazz.getName());
    }

    public static final LogContext createContext(String string) {
        return Log.getInstance().internalCreateContext(string);
    }

    public static final void debug(Object object) {
        Log.log(3, object);
    }

    public static final void debug(Object object, Exception exception) {
        Log.log(3, object, exception);
    }

    protected static final synchronized void defineLog(Log log) {
        singleton = log;
    }

    protected final void doLog(int n, Object object) {
        if (n > 3) {
            n = 3;
        }
        if (n <= this.debuglevel) {
            int n2 = 0;
            while (n2 < this.logTargets.length) {
                LogTarget logTarget = this.logTargets[n2];
                logTarget.log(n, object);
                ++n2;
            }
        }
    }

    protected final void doLog(int n, Object object, Exception exception) {
        if (n > 3) {
            n = 3;
        }
        if (n <= this.debuglevel) {
            int n2 = 0;
            while (n2 < this.logTargets.length) {
                LogTarget logTarget = this.logTargets[n2];
                logTarget.log(n, object, exception);
                ++n2;
            }
        }
    }

    public static final void error(Object object) {
        Log.log(0, object);
    }

    public static final void error(Object object, Exception exception) {
        Log.log(0, object, exception);
    }

    public final int getDebuglevel() {
        return this.debuglevel;
    }

    public static final synchronized Log getInstance() {
        if (singleton == null) {
            singleton = new Log();
        }
        return singleton;
    }

    public final LogTarget[] getTargets() {
        return (LogTarget[])this.logTargets.clone();
    }

    public static final void info(Object object) {
        Log.log(2, object);
    }

    public static final void info(Object object, Exception exception) {
        Log.log(2, object, exception);
    }

    public void init() {
    }

    protected final LogContext internalCreateContext(String string) {
        Log log = this;
        synchronized (log) {
            LogContext logContext = (LogContext)this.logContexts.get(string);
            if (logContext == null) {
                logContext = new LogContext(string);
                this.logContexts.put(string, logContext);
            }
            LogContext logContext2 = logContext;
            Object var4_5 = null;
            return logContext2;
        }
    }

    public static final boolean isDebugEnabled() {
        return Log.getInstance().getDebuglevel() >= 3;
    }

    public static final boolean isErrorEnabled() {
        return Log.getInstance().getDebuglevel() >= 0;
    }

    public static final boolean isInfoEnabled() {
        return Log.getInstance().getDebuglevel() >= 2;
    }

    public static final boolean isWarningEnabled() {
        return Log.getInstance().getDebuglevel() >= 1;
    }

    public static final void log(int n, Object object) {
        Log.getInstance().doLog(n, object);
    }

    public static final void log(int n, Object object, Exception exception) {
        Log.getInstance().doLog(n, object, exception);
    }

    public final synchronized void removeTarget(LogTarget logTarget) {
        if (logTarget == null) {
            throw new NullPointerException();
        }
        ArrayList<LogTarget> arrayList = new ArrayList<LogTarget>();
        arrayList.addAll(Arrays.asList(this.logTargets));
        ((AbstractCollection)arrayList).remove(logTarget);
        LogTarget[] logTargetArray = new LogTarget[arrayList.size()];
        this.logTargets = arrayList.toArray(logTargetArray);
    }

    public final synchronized void replaceTargets(LogTarget logTarget) {
        if (logTarget == null) {
            throw new NullPointerException();
        }
        this.logTargets = new LogTarget[]{logTarget};
    }

    protected final void setDebuglevel(int n) {
        this.debuglevel = n;
    }

    public static final void warn(Object object) {
        Log.log(1, object);
    }

    public static final void warn(Object object, Exception exception) {
        Log.log(1, object, exception);
    }
}

