/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.jfree.util.ArrayUtilities;
import org.jfree.util.Log;
import org.jfree.util.PublicCloneable;

public final class ObjectUtilities {
    public static final String THREAD_CONTEXT = "ThreadContext";
    public static final String CLASS_CONTEXT = "ClassContext";
    private static String classLoaderSource = "ThreadContext";
    private static ClassLoader classLoader;
    static Class class$org$jfree$util$ObjectUtilities;

    private ObjectUtilities() {
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final Object clone(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null 'object' argument.");
        }
        if (object instanceof PublicCloneable) {
            PublicCloneable publicCloneable = (PublicCloneable)object;
            return publicCloneable.clone();
        }
        try {
            Method method = object.getClass().getMethod("clone", null);
            if (Modifier.isPublic(method.getModifiers())) {
                return method.invoke(object, null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.warn("Object without clone() method is impossible.");
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.warn("Object.clone(): unable to call method.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.warn("Object without clone() method is impossible.");
        }
        throw new CloneNotSupportedException("Failed to clone.");
    }

    /*
     * Unable to fully structure code
     */
    private static String convertName(String var0, Class var1_1) {
        if (!var0.startsWith("/")) ** GOTO lbl4
        return var0.substring(1);
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.getComponentType();
lbl4:
            // 2 sources

            ** while (var1_1.isArray())
        }
lbl5:
        // 1 sources

        var2_2 = var1_1.getName();
        var3_3 = var2_2.lastIndexOf(46);
        if (var3_3 == -1) {
            return var0;
        }
        var4_4 = var2_2.substring(0, var3_3);
        return String.valueOf(var4_4.replace('.', '/')) + "/" + var0;
    }

    public static final Collection deepClone(Collection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Null 'collection' argument.");
        }
        Collection collection2 = (Collection)ObjectUtilities.clone(collection);
        collection2.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 != null) {
                collection2.add(ObjectUtilities.clone(e2));
                continue;
            }
            collection2.add(null);
        }
        return collection2;
    }

    public static final boolean equal(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object != null) {
            return object.equals(object2);
        }
        return false;
    }

    public static final ClassLoader getClassLoader() {
        return classLoader;
    }

    public static final synchronized ClassLoader getClassLoader(Class clazz) {
        ClassLoader classLoader;
        if (ObjectUtilities.classLoader != null) {
            return ObjectUtilities.classLoader;
        }
        if (THREAD_CONTEXT.equals(classLoaderSource) && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return classLoader;
        }
        classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static final String getClassLoaderSource() {
        return classLoaderSource;
    }

    public static final URL getResource(String string, Class clazz) {
        ClassLoader classLoader = ObjectUtilities.getClassLoader(clazz);
        if (classLoader == null) {
            return null;
        }
        return classLoader.getResource(string);
    }

    public static final InputStream getResourceAsStream(String string, Class clazz) {
        URL uRL = ObjectUtilities.getResource(string, clazz);
        if (uRL == null) {
            return null;
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static final URL getResourceRelative(String string, Class clazz) {
        ClassLoader classLoader = ObjectUtilities.getClassLoader(clazz);
        String string2 = ObjectUtilities.convertName(string, clazz);
        if (classLoader == null) {
            return null;
        }
        return classLoader.getResource(string2);
    }

    public static final InputStream getResourceRelativeAsStream(String string, Class clazz) {
        URL uRL = ObjectUtilities.getResourceRelative(string, clazz);
        if (uRL == null) {
            return null;
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static final int hashCode(Object object) {
        int n = 0;
        if (object != null) {
            n = object.hashCode();
        }
        return n;
    }

    public static final boolean isJDK14() {
        ClassLoader classLoader = ObjectUtilities.getClassLoader(class$org$jfree$util$ObjectUtilities != null ? class$org$jfree$util$ObjectUtilities : (class$org$jfree$util$ObjectUtilities = ObjectUtilities.class$("org.jfree.util.ObjectUtilities")));
        if (classLoader != null) {
            try {
                classLoader.loadClass("java.util.RandomAccess");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
            catch (Exception exception) {}
        }
        try {
            String string = System.getProperty("java.vm.specification.version");
            if (string == null) {
                return false;
            }
            String[] stringArray = ObjectUtilities.parseVersions(string);
            String[] stringArray2 = new String[]{"1", "4"};
            return ArrayUtilities.compareVersionArrays((Comparable[])stringArray, (Comparable[])stringArray2) >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final Object loadAndInstantiate(String string, Class clazz) {
        try {
            ClassLoader classLoader = ObjectUtilities.getClassLoader(clazz);
            Class<?> clazz2 = classLoader.loadClass(string);
            return clazz2.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String[] parseVersions(String string) {
        if (string == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static final synchronized void setClassLoader(ClassLoader classLoader) {
        ObjectUtilities.classLoader = classLoader;
    }

    public static final void setClassLoaderSource(String string) {
        classLoaderSource = string;
    }
}

