/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import org.tigr.util.FloatMatrix;

public class ExperimentUtil {
    public static final float distance(FloatMatrix floatMatrix, int n, int n2, int n3, float f2, boolean bl) {
        float f3 = Float.NaN;
        switch (n3) {
            case 1: {
                f3 = ExperimentUtil.pearson(floatMatrix, n, n2, f2);
                f2 *= -1.0f;
                break;
            }
            case 2: {
                f3 = ExperimentUtil.cosine(floatMatrix, n, n2, f2);
                f2 *= -1.0f;
                break;
            }
            case 3: {
                f3 = ExperimentUtil.covariance(floatMatrix, n, n2, f2);
                f2 *= -1.0f;
                break;
            }
            case 4: {
                f3 = ExperimentUtil.euclidian(floatMatrix, n, n2, f2);
                break;
            }
            case 5: {
                f3 = ExperimentUtil.dotProduct(floatMatrix, n, n2, f2);
                f2 *= -1.0f;
                break;
            }
            case 6: {
                f3 = ExperimentUtil.pearsonUncentered(floatMatrix, n, n2, f2);
                f2 *= -1.0f;
                break;
            }
            case 7: {
                f3 = (float)Math.pow(ExperimentUtil.pearsonUncentered(floatMatrix, n, n2, f2), 2.0);
                f2 *= -1.0f;
                break;
            }
            case 8: {
                f3 = ExperimentUtil.manhattan(floatMatrix, n, n2, f2);
                break;
            }
            case 9: {
                f3 = ExperimentUtil.spearmanRank(floatMatrix, n, n2, f2);
                f2 *= -1.0f;
                break;
            }
            case 10: {
                f3 = ExperimentUtil.kendallsTau(floatMatrix, n, n2, f2);
                f2 *= -1.0f;
                break;
            }
            case 11: {
                f3 = ExperimentUtil.mutualInformation(floatMatrix, n, n2, f2);
                break;
            }
        }
        if (bl) {
            f3 = Math.abs(f3);
        }
        return f3 * f2;
    }

    public static final float geneDistance(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, int n3, float f2, boolean bl) {
        float f3 = Float.NaN;
        switch (n3) {
            case 1: {
                f3 = ExperimentUtil.genePearson(floatMatrix, floatMatrix2, n, n2, f2);
                f2 *= -1.0f;
                break;
            }
            case 2: {
                f3 = ExperimentUtil.geneCosine(floatMatrix, floatMatrix2, n, n2, f2);
                f2 *= -1.0f;
                break;
            }
            case 3: {
                f3 = ExperimentUtil.geneCovariance(floatMatrix, floatMatrix2, n, n2, f2);
                f2 *= -1.0f;
                break;
            }
            case 4: {
                f3 = ExperimentUtil.geneEuclidianDistance(floatMatrix, floatMatrix2, n, n2, f2);
                break;
            }
            case 5: {
                f3 = ExperimentUtil.geneDotProduct(floatMatrix, floatMatrix2, n, n2, f2);
                f2 *= -1.0f;
                break;
            }
            case 6: {
                f3 = ExperimentUtil.genePearsonUncentered(floatMatrix, floatMatrix2, n, n2, f2);
                f2 *= -1.0f;
                break;
            }
            case 7: {
                f3 = (float)Math.pow(ExperimentUtil.genePearsonUncentered(floatMatrix, floatMatrix2, n, n2, f2), 2.0) * f2;
                f2 *= -1.0f;
                break;
            }
            case 8: {
                f3 = ExperimentUtil.geneManhattan(floatMatrix, floatMatrix2, n, n2, f2);
                break;
            }
            case 9: {
                f3 = ExperimentUtil.geneSpearmanRank(floatMatrix, floatMatrix2, n, n2, f2);
                f2 *= -1.0f;
                break;
            }
            case 10: {
                f3 = ExperimentUtil.geneKendallsTau(floatMatrix, floatMatrix2, n, n2, f2);
                f2 *= -1.0f;
                break;
            }
            case 11: {
                f3 = ExperimentUtil.geneMutualInformation(floatMatrix, floatMatrix2, n, n2, f2);
                break;
            }
        }
        if (bl) {
            f3 = Math.abs(f3);
        }
        return f3 * f2;
    }

    public static final float genePearsonOld(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f2) {
        int n3;
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        float f3 = Float.MIN_VALUE;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n4 = floatMatrix.getColumnDimension();
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n, n3)) || Float.isNaN(floatMatrix2.get(n2, n3))) continue;
            d5 += (double)floatMatrix.get(n, n3);
            d6 += (double)floatMatrix2.get(n2, n3);
            ++n5;
        }
        d5 /= (double)n5;
        d6 /= (double)n5;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n, n3)) || Float.isNaN(floatMatrix2.get(n2, n3))) continue;
            double d7 = (double)floatMatrix.get(n, n3) - d5;
            double d8 = (double)floatMatrix2.get(n2, n3) - d6;
            d2 += d7 * d7;
            d3 += d8 * d8;
            d4 += d7 * d8;
        }
        return (float)(d4 / (Math.sqrt(d2 * d3) + (double)f3) * (double)f2);
    }

    public static final float genePearson(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f2) {
        int n3;
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        float[] fArray = floatMatrix.A[n];
        float[] fArray2 = floatMatrix2.A[n2];
        int n4 = floatMatrix.getColumnDimension();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            double d7 = fArray[n3];
            double d8 = fArray2[n3];
            if (Double.isNaN(d7) || Double.isNaN(d8)) continue;
            ++n5;
            d2 += d7 * d8;
            d4 += d7 * d7;
            d6 += d8 * d8;
            d3 += d7;
            d5 += d8;
        }
        if (n5 == 0) {
            return 0.0f;
        }
        n3 = 0;
        for (int i2 = 1; i2 < n4; ++i2) {
            if (Float.isNaN(fArray[i2]) || Float.isNaN(fArray2[i2])) continue;
            if (fArray[i2] != fArray[i2 - 1]) {
                n3 = 1;
                break;
            }
            if (fArray2[i2] == fArray2[i2 - 1]) continue;
            n3 = 1;
            break;
        }
        if (n3 == 0) {
            return 1.0f;
        }
        double d9 = d3 / (double)n5;
        double d10 = d5 / (double)n5;
        double d11 = d2 - d3 * d10 - d9 * d5 + d9 * d10 * (double)n5;
        double d12 = d4 - d9 * d3 * 2.0 + d9 * d9 * (double)n5;
        double d13 = d6 - d10 * d5 * 2.0 + d10 * d10 * (double)n5;
        double d14 = d12 * d13;
        return (float)(d11 / (Math.sqrt(d14) + Double.MIN_VALUE) * (double)f2);
    }

    public static final float geneCosine(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f2) {
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n3 = floatMatrix.getColumnDimension();
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (Float.isNaN(floatMatrix.get(n, i2)) || Float.isNaN(floatMatrix2.get(n2, i2))) continue;
            d5 = floatMatrix.get(n, i2);
            d6 = floatMatrix2.get(n2, i2);
            d2 += d5 * d6;
            d3 += d5 * d5;
            d4 += d6 * d6;
            ++n4;
        }
        return (float)(d2 / (Math.sqrt(d3) * Math.sqrt(d4)) * (double)f2);
    }

    public static final float geneCovariance(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f2) {
        int n3;
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = floatMatrix.getColumnDimension();
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n, n3)) || Float.isNaN(floatMatrix2.get(n2, n3))) continue;
            d3 += (double)floatMatrix.get(n, n3);
            d4 += (double)floatMatrix2.get(n2, n3);
            ++n5;
        }
        d3 /= (double)n5;
        d4 /= (double)n5;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n, n3)) || Float.isNaN(floatMatrix2.get(n2, n3))) continue;
            double d5 = (double)floatMatrix.get(n, n3) - d3;
            double d6 = (double)floatMatrix2.get(n2, n3) - d4;
            d2 += d5 * d6;
        }
        return (float)(d2 / ((double)(n5 - 1) * 1.0) * (double)f2);
    }

    public static final float geneEuclidianDistance(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f2) {
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        int n3 = floatMatrix.getColumnDimension();
        int n4 = 0;
        double d2 = 0.0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (Float.isNaN(floatMatrix.get(n, i2)) || Float.isNaN(floatMatrix2.get(n2, i2))) continue;
            d2 += Math.pow(floatMatrix.get(n, i2) - floatMatrix2.get(n2, i2), 2.0);
            ++n4;
        }
        return (float)(Math.sqrt(d2) * (double)f2);
    }

    public static final float geneDotProduct(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f2) {
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        int n3 = floatMatrix.getColumnDimension();
        int n4 = 0;
        double d2 = 0.0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (Float.isNaN(floatMatrix.get(n, i2)) || Float.isNaN(floatMatrix2.get(n2, i2))) continue;
            d2 += (double)(floatMatrix.get(n, i2) * floatMatrix2.get(n2, i2));
            ++n4;
        }
        return (float)(d2 / (double)n4 * (double)f2);
    }

    public static final float genePearsonUncentered(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f2) {
        int n3;
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        float f3 = Float.MIN_VALUE;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n4 = floatMatrix.getColumnDimension();
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n, n3)) || Float.isNaN(floatMatrix2.get(n2, n3))) continue;
            d5 += (double)floatMatrix.get(n, n3);
            d6 += (double)floatMatrix2.get(n2, n3);
            ++n5;
        }
        d5 /= (double)n5;
        d6 /= (double)n5;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n, n3)) || Float.isNaN(floatMatrix2.get(n2, n3))) continue;
            double d7 = floatMatrix.get(n, n3);
            double d8 = floatMatrix2.get(n2, n3);
            d2 += d7 * d7;
            d3 += d8 * d8;
            d4 += d7 * d8;
        }
        return (float)(d4 / (Math.sqrt(d2 * d3) + (double)f3) * (double)f2);
    }

    public static final float geneManhattan(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f2) {
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        double d2 = 0.0;
        int n3 = floatMatrix.getColumnDimension();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (Float.isNaN(floatMatrix.get(n, i2)) || Float.isNaN(floatMatrix2.get(n2, i2))) continue;
            d2 += (double)Math.abs(floatMatrix.get(n, i2) - floatMatrix.get(n2, i2));
        }
        return (float)(d2 * (double)f2);
    }

    public static final float geneSpearmanRank(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f2) {
        int n3;
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        int n4 = floatMatrix.getColumnDimension();
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = floatMatrix.get(n, n3);
            dArray2[n3] = floatMatrix2.get(n2, n3);
        }
        ExperimentUtil.sort2(dArray, dArray2);
        double d2 = ExperimentUtil.crank(dArray);
        ExperimentUtil.sort2(dArray2, dArray);
        double d3 = ExperimentUtil.crank(dArray2);
        double d4 = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            d4 += Math.pow(dArray[n3] - dArray2[n3], 2.0);
        }
        double d5 = n4;
        double d6 = d5 * d5 * d5 - d5;
        double d7 = d6 / 6.0 - (d2 + d3) / 12.0;
        double d8 = (1.0 - d2 / d6) * (1.0 - d3 / d6);
        double d9 = (d5 - 1.0) * d5 * d5 * Math.pow(d5 + 1.0, 2.0) / 36.0 * d8;
        return (float)((1.0 - 6.0 / d6 * (d4 + (d2 + d3) / 12.0)) / Math.sqrt(d8) * (double)f2);
    }

    public static final float geneKendallsTau(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f2) {
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        float f3 = Float.MIN_VALUE;
        int n3 = floatMatrix.getColumnDimension();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i2 = 0; i2 < n3 - 1; ++i2) {
            for (int i3 = i2 + 1; i3 < n3; ++i3) {
                double d2;
                double d3 = floatMatrix.get(n, i2) - floatMatrix.get(n, i3);
                double d4 = d3 * (d2 = (double)(floatMatrix2.get(n2, i2) - floatMatrix2.get(n2, i3)));
                if (d4 != 0.0) {
                    ++n5;
                    ++n4;
                    if (d4 > 0.0) {
                        ++n6;
                        continue;
                    }
                    --n6;
                    continue;
                }
                if (d3 != 0.0) {
                    ++n5;
                }
                if (d2 == 0.0) continue;
                ++n4;
            }
        }
        return (float)((double)n6 / (Math.sqrt(n5) * Math.sqrt(n4) + (double)f3) * (double)f2);
    }

    public static final float geneMutualInformation(FloatMatrix floatMatrix, FloatMatrix floatMatrix2, int n, int n2, float f2) {
        int n3;
        if (floatMatrix2 == null) {
            floatMatrix2 = floatMatrix;
        }
        int n4 = floatMatrix2.getColumnDimension();
        int n5 = (int)Math.floor(Math.log(n4) / Math.log(2.0));
        int n6 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (Float.isNaN(floatMatrix.get(n, i2)) || Float.isNaN(floatMatrix2.get(n2, i2))) continue;
            ++n6;
        }
        FloatMatrix floatMatrix3 = new FloatMatrix(n6, 1);
        FloatMatrix floatMatrix4 = new FloatMatrix(n6, 1);
        int n7 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            if (Float.isNaN(floatMatrix.get(n, i3)) || Float.isNaN(floatMatrix.get(n2, i3))) continue;
            floatMatrix3.set(n7, 0, floatMatrix.get(n, i3));
            floatMatrix4.set(n7, 0, floatMatrix2.get(n2, i3));
            ++n7;
        }
        n4 = n6;
        ExperimentUtil.makeDigitalExperiment(floatMatrix3, 0);
        ExperimentUtil.makeDigitalExperiment(floatMatrix4, 0);
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        double[][] dArray3 = new double[n5][n5];
        for (n3 = 0; n3 < n4; ++n3) {
            int n8 = (int)floatMatrix3.get(0, n3) - 1;
            dArray[n8] = dArray[n8] + 1.0;
            int n9 = (int)floatMatrix4.get(0, n3) - 1;
            dArray2[n9] = dArray2[n9] + 1.0;
            double[] dArray4 = dArray3[(int)floatMatrix3.get(0, n3) - 1];
            int n10 = (int)floatMatrix4.get(0, n3) - 1;
            dArray4[n10] = dArray4[n10] + 1.0;
        }
        for (n3 = 0; n3 < dArray.length; ++n3) {
            int n11 = n3;
            dArray[n11] = dArray[n11] / (double)n4;
            int n12 = n3;
            dArray2[n12] = dArray2[n12] / (double)n4;
            int n13 = 0;
            while (n13 < dArray.length) {
                double[] dArray5 = dArray3[n3];
                int n14 = n13++;
                dArray5[n14] = dArray5[n14] / (double)n4;
            }
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i4 = 0; i4 < dArray.length; ++i4) {
            if (dArray[i4] != 0.0) {
                d2 += dArray[i4] * Math.log(dArray[i4]) / Math.log(2.0);
            }
            if (dArray2[i4] != 0.0) {
                d3 += dArray2[i4] * Math.log(dArray2[i4]) / Math.log(2.0);
            }
            for (int i5 = 0; i5 < dArray2.length; ++i5) {
                if (dArray3[i4][i5] == 0.0) continue;
                d4 += dArray3[i4][i5] * Math.log(dArray3[i4][i5]) / Math.log(2.0);
            }
        }
        d2 = -d2;
        d3 = -d3;
        d4 = -d4;
        d5 = (d2 + d3 - d4) / Math.max(d2, d3);
        return (float)((1.0 - d5) * (double)f2);
    }

    public static final float pearson(FloatMatrix floatMatrix, int n, int n2, float f2) {
        int n3;
        float f3 = Float.MIN_VALUE;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n4 = floatMatrix.getRowDimension();
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n3, n)) || Float.isNaN(floatMatrix.get(n3, n2))) continue;
            d5 += (double)floatMatrix.get(n3, n);
            d6 += (double)floatMatrix.get(n3, n2);
            ++n5;
        }
        d5 /= (double)n5;
        d6 /= (double)n5;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n3, n)) || Float.isNaN(floatMatrix.get(n3, n2))) continue;
            double d7 = (double)floatMatrix.get(n3, n) - d5;
            double d8 = (double)floatMatrix.get(n3, n2) - d6;
            d2 += d7 * d7;
            d3 += d8 * d8;
            d4 += d7 * d8;
        }
        return (float)(d4 / (Math.sqrt(d2 * d3) + (double)f3) * (double)f2);
    }

    public static final float cosine(FloatMatrix floatMatrix, int n, int n2, float f2) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n3 = floatMatrix.getRowDimension();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (Float.isNaN(floatMatrix.get(i2, n)) || Float.isNaN(floatMatrix.get(i2, n2))) continue;
            d5 = floatMatrix.get(i2, n);
            d6 = floatMatrix.get(i2, n2);
            d2 += d5 * d6;
            d3 += d5 * d5;
            d4 += d6 * d6;
        }
        return (float)(d2 / (Math.sqrt(d3) * Math.sqrt(d4)) * (double)f2);
    }

    public static final float covariance(FloatMatrix floatMatrix, int n, int n2, float f2) {
        int n3;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = floatMatrix.getRowDimension();
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n3, n)) || Float.isNaN(floatMatrix.get(n3, n2))) continue;
            d3 += (double)floatMatrix.get(n3, n);
            d4 += (double)floatMatrix.get(n3, n2);
            ++n5;
        }
        d3 /= (double)n5;
        d4 /= (double)n5;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n3, n)) || Float.isNaN(floatMatrix.get(n3, n2))) continue;
            double d5 = (double)floatMatrix.get(n3, n) - d3;
            double d6 = (double)floatMatrix.get(n3, n2) - d4;
            d2 += d5 * d6;
        }
        return (float)(d2 / (double)((float)(n5 - 1) * 1.0f) * (double)f2);
    }

    public static final float euclidian(FloatMatrix floatMatrix, int n, int n2, float f2) {
        int n3 = floatMatrix.getRowDimension();
        double d2 = 0.0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (Float.isNaN(floatMatrix.get(i2, n)) || Float.isNaN(floatMatrix.get(i2, n2))) continue;
            d2 += Math.pow(floatMatrix.get(i2, n) - floatMatrix.get(i2, n2), 2.0);
        }
        return (float)(Math.sqrt(d2) * (double)f2);
    }

    public static final float dotProduct(FloatMatrix floatMatrix, int n, int n2, float f2) {
        int n3 = floatMatrix.getRowDimension();
        double d2 = 0.0;
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (Float.isNaN(floatMatrix.get(i2, n)) || Float.isNaN(floatMatrix.get(i2, n2))) continue;
            d2 += (double)(floatMatrix.get(i2, n) * floatMatrix.get(i2, n2));
            ++n4;
        }
        return (float)(d2 / (double)n4 * (double)f2);
    }

    public static final float pearsonUncentered(FloatMatrix floatMatrix, int n, int n2, float f2) {
        int n3;
        float f3 = Float.MIN_VALUE;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n4 = floatMatrix.getRowDimension();
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n3, n)) || Float.isNaN(floatMatrix.get(n3, n2))) continue;
            d5 += (double)floatMatrix.get(n3, n);
            d6 += (double)floatMatrix.get(n3, n2);
            ++n5;
        }
        d5 /= (double)n5;
        d6 /= (double)n5;
        for (n3 = 0; n3 < n4; ++n3) {
            if (Float.isNaN(floatMatrix.get(n3, n)) || Float.isNaN(floatMatrix.get(n3, n2))) continue;
            double d7 = floatMatrix.get(n3, n);
            double d8 = floatMatrix.get(n3, n2);
            d2 += d7 * d7;
            d3 += d8 * d8;
            d4 += d7 * d8;
        }
        return (float)(d4 / (Math.sqrt(d2 * d3) + (double)f3) * (double)f2);
    }

    public static final float manhattan(FloatMatrix floatMatrix, int n, int n2, float f2) {
        double d2 = 0.0;
        int n3 = floatMatrix.getRowDimension();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (Float.isNaN(floatMatrix.get(i2, n)) || Float.isNaN(floatMatrix.get(i2, n2))) continue;
            d2 += (double)Math.abs(floatMatrix.get(i2, n) - floatMatrix.get(i2, n2));
        }
        return (float)(d2 * (double)f2);
    }

    public static final float spearmanRank(FloatMatrix floatMatrix, int n, int n2, float f2) {
        int n3;
        int n4 = floatMatrix.getRowDimension();
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = floatMatrix.get(n3, n);
            dArray2[n3] = floatMatrix.get(n3, n2);
        }
        ExperimentUtil.sort2(dArray, dArray2);
        double d2 = ExperimentUtil.crank(dArray);
        ExperimentUtil.sort2(dArray2, dArray);
        double d3 = ExperimentUtil.crank(dArray2);
        double d4 = 0.0;
        for (n3 = 0; n3 < n4; ++n3) {
            d4 += Math.pow(dArray[n3] - dArray2[n3], 2.0);
        }
        double d5 = n4;
        double d6 = d5 * d5 * d5 - d5;
        double d7 = d6 / 6.0 - (d2 + d3) / 12.0;
        double d8 = (1.0 - d2 / d6) * (1.0 - d3 / d6);
        double d9 = (d5 - 1.0) * d5 * d5 * Math.pow(d5 + 1.0, 2.0) / 36.0 * d8;
        return (float)((1.0 - 6.0 / d6 * (d4 + (d2 + d3) / 12.0)) / Math.sqrt(d8) * (double)f2);
    }

    public static final float kendallsTau(FloatMatrix floatMatrix, int n, int n2, float f2) {
        float f3 = Float.MIN_VALUE;
        int n3 = floatMatrix.getRowDimension();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i2 = 0; i2 < n3 - 1; ++i2) {
            for (int i3 = i2 + 1; i3 < n3; ++i3) {
                double d2;
                double d3 = floatMatrix.get(i2, n) - floatMatrix.get(i3, n);
                double d4 = d3 * (d2 = (double)(floatMatrix.get(i2, n2) - floatMatrix.get(i3, n2)));
                if (d4 != 0.0) {
                    ++n5;
                    ++n4;
                    if (d4 > 0.0) {
                        ++n6;
                        continue;
                    }
                    --n6;
                    continue;
                }
                if (d3 != 0.0) {
                    ++n5;
                }
                if (d2 == 0.0) continue;
                ++n4;
            }
        }
        return (float)((double)n6 / (Math.sqrt(n5) * Math.sqrt(n4) + (double)f3) * (double)f2);
    }

    public static final float mutualInformation(FloatMatrix floatMatrix, int n, int n2, float f2) {
        int n3;
        int n4 = floatMatrix.getRowDimension();
        int n5 = (int)Math.floor(Math.log(n4) / Math.log(2.0));
        int n6 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (Float.isNaN(floatMatrix.get(i2, n)) || Float.isNaN(floatMatrix.get(i2, n2))) continue;
            ++n6;
        }
        FloatMatrix floatMatrix2 = new FloatMatrix(1, n6);
        FloatMatrix floatMatrix3 = new FloatMatrix(1, n6);
        int n7 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            if (Float.isNaN(floatMatrix.get(i3, n)) || Float.isNaN(floatMatrix.get(i3, n2))) continue;
            floatMatrix2.set(n7, 0, floatMatrix.get(i3, n));
            floatMatrix3.set(n7, 0, floatMatrix.get(i3, n2));
            ++n7;
        }
        n4 = n6;
        ExperimentUtil.makeDigitalExperiment(floatMatrix2, 0);
        ExperimentUtil.makeDigitalExperiment(floatMatrix3, 0);
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        double[][] dArray3 = new double[n5][n5];
        for (n3 = 0; n3 < n4; ++n3) {
            int n8 = (int)floatMatrix2.get(n3, 0) - 1;
            dArray[n8] = dArray[n8] + 1.0;
            int n9 = (int)floatMatrix3.get(n3, 0) - 1;
            dArray2[n9] = dArray2[n9] + 1.0;
            double[] dArray4 = dArray3[(int)floatMatrix2.get(n3, 0) - 1];
            int n10 = (int)floatMatrix3.get(n3, 0) - 1;
            dArray4[n10] = dArray4[n10] + 1.0;
        }
        for (n3 = 0; n3 < dArray.length; ++n3) {
            int n11 = n3;
            dArray[n11] = dArray[n11] / (double)n4;
            int n12 = n3;
            dArray2[n12] = dArray2[n12] / (double)n4;
            int n13 = 0;
            while (n13 < dArray.length) {
                double[] dArray5 = dArray3[n3];
                int n14 = n13++;
                dArray5[n14] = dArray5[n14] / (double)n4;
            }
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i4 = 0; i4 < dArray.length; ++i4) {
            if (dArray[i4] != 0.0) {
                d2 += dArray[i4] * Math.log(dArray[i4]) / Math.log(2.0);
            }
            if (dArray2[i4] != 0.0) {
                d3 += dArray2[i4] * Math.log(dArray2[i4]) / Math.log(2.0);
            }
            for (int i5 = 0; i5 < dArray2.length; ++i5) {
                if (dArray3[i4][i5] == 0.0) continue;
                d4 += dArray3[i4][i5] * Math.log(dArray3[i4][i5]) / Math.log(2.0);
            }
        }
        d2 = -d2;
        d3 = -d3;
        d4 = -d4;
        d5 = Math.max(d2, d3) != 0.0 ? (d2 + d3 - d4) / Math.max(d2, d3) : d2 + d3 - d4;
        return (float)((1.0 - d5) * (double)f2);
    }

    public static final void makeDigitalExperiment(FloatMatrix floatMatrix, int n) {
        int n2;
        int n3 = floatMatrix.getRowDimension();
        int n4 = (int)Math.floor(Math.log(n3) / Math.log(2.0));
        int n5 = 1000000 / n4;
        float f2 = Float.MAX_VALUE;
        float f3 = 0.0f;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!(floatMatrix.get(n2, n) < f2)) continue;
            f2 = floatMatrix.get(n2, n);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            floatMatrix.set(n2, n, floatMatrix.get(n2, n) - f2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (!(floatMatrix.get(n2, n) > f3)) continue;
            f3 = floatMatrix.get(n2, n);
        }
        if (f3 != 0.0f) {
            for (n2 = 0; n2 < n3; ++n2) {
                floatMatrix.set(n2, n, floatMatrix.get(n2, n) / f3);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if ((double)floatMatrix.get(n2, n) == 1.0) {
                floatMatrix.set(n2, n, n4);
                continue;
            }
            floatMatrix.set(n2, n, (float)(Math.floor(floatMatrix.get(n2, n) * 1000000.0f / (float)n5) + 1.0));
        }
    }

    public static final double crank(double[] dArray) {
        int n = 0;
        double d2 = 0.0;
        int n2 = dArray.length;
        while (n < n2 - 1) {
            int n3;
            if (dArray[n + 1] != dArray[n]) {
                dArray[n] = n;
                ++n;
                continue;
            }
            for (n3 = n + 1; n3 < n2 && dArray[n3] == dArray[n]; ++n3) {
            }
            double d3 = 0.5 * (double)(n + n3 - 1);
            for (int i2 = n; i2 <= n3 - 1; ++i2) {
                dArray[i2] = d3;
            }
            double d4 = n3 - n;
            d2 += d4 * d4 * d4 - d4;
            n = n3;
        }
        if (n == n2 - 1) {
            dArray[n2 - 1] = n2 - 1;
        }
        return d2;
    }

    public static final void sort2(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = n - 1;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[50];
        while (true) {
            int n5;
            double d2;
            double d3;
            int n6;
            if (n2 - n3 < 7) {
                for (n6 = n3 + 1; n6 <= n2; ++n6) {
                    d3 = dArray[n6];
                    d2 = dArray2[n6];
                    for (n5 = n6 - 1; n5 >= n3 && !(dArray[n5] <= d3); --n5) {
                        dArray[n5 + 1] = dArray[n5];
                        dArray2[n5 + 1] = dArray2[n5];
                    }
                    dArray[n5 + 1] = d3;
                    dArray2[n5 + 1] = d2;
                }
                if (n4 == 0) {
                    nArray = null;
                    return;
                }
                n2 = nArray[n4];
                n3 = nArray[n4 - 1];
                n4 -= 2;
                continue;
            }
            int n7 = n3 + n2 >> 1;
            double d4 = dArray[n7];
            dArray[n7] = dArray[n3 + 1];
            dArray[n3 + 1] = dArray[n7];
            d4 = dArray2[n7];
            dArray2[n7] = dArray2[n3 + 1];
            dArray2[n3 + 1] = dArray2[n7];
            if (dArray[n3] > dArray[n2]) {
                d4 = dArray[n3];
                dArray[n3] = dArray[n2];
                dArray[n2] = d4;
                d4 = dArray2[n3];
                dArray2[n3] = dArray2[n2];
                dArray2[n2] = d4;
            }
            if (dArray[n3 + 1] > dArray[n2]) {
                d4 = dArray[n3 + 1];
                dArray[n3 + 1] = dArray[n2];
                dArray[n2] = d4;
                d4 = dArray2[n3 + 1];
                dArray2[n3 + 1] = dArray2[n2];
                dArray2[n2] = d4;
            }
            if (dArray[n3] > dArray[n3 + 1]) {
                d4 = dArray[n3];
                dArray[n3] = dArray[n3 + 1];
                dArray[n3 + 1] = d4;
                d4 = dArray2[n3];
                dArray2[n3] = dArray2[n3 + 1];
                dArray2[n3 + 1] = d4;
            }
            n5 = n3 + 1;
            n6 = n2;
            d3 = dArray[n3 + 1];
            d2 = dArray2[n3 + 1];
            while (true) {
                if (dArray[++n5] < d3) {
                    continue;
                }
                while (dArray[--n6] > d3) {
                }
                if (n6 < n5) break;
                d4 = dArray[n5];
                dArray[n5] = dArray[n6];
                dArray[n6] = d4;
                d4 = dArray2[n5];
                dArray2[n5] = dArray2[n6];
                dArray2[n6] = d4;
            }
            dArray[n3 + 1] = dArray[n6];
            dArray[n6] = d3;
            dArray2[n3 + 1] = dArray2[n6];
            dArray2[n6] = d2;
            if ((n4 += 2) > 50) {
                System.out.println("NSTACK too small in sort2.");
            }
            if (n2 - n5 + 1 >= n6 - n3) {
                nArray[n4] = n2;
                nArray[n4 - 1] = n5;
                n2 = n6 - 1;
                continue;
            }
            nArray[n4] = n6 - 1;
            nArray[n4 - 1] = n3;
            n3 = n5;
        }
    }
}

