/*
 * Decompiled with CFR 0.152.
 */
package xapps.gsea;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jidesoft.grid.QuickFilterPane;
import com.jidesoft.grid.QuickTableFilterField;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.JideTitledBorder;
import com.jidesoft.swing.PartialEtchedBorder;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.models.NumberedProxyModel;
import edu.mit.broad.genome.models.StringDataframeModel;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.reports.EnrichmentReports;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.fields.GDirFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.viewers.AbstractViewer;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import org.apache.log4j.Logger;
import xapps.api.vtools.ParamSetFormForAFew;
import xapps.gsea.LeadingEdgeReportViewer$1;
import xapps.gsea.LeadingEdgeReportViewer$2;
import xapps.gsea.LeadingEdgeReportViewer$3;
import xapps.gsea.LeadingEdgeReportViewer$ESRenderer;
import xtools.api.param.DirParam;
import xtools.api.param.Param;
import xtools.api.param.ReportCacheChooserParam;

public class LeadingEdgeReportViewer
extends AbstractViewer {
    public static final String NAME = "LeadingEdgeReportWidget";
    public static final Icon ICON = JarResources.getIcon("Lev16_b.gif");
    private ReportCacheChooserParam fReportParam;
    private DirParam fDirParam;
    private SortableTable sortableTable;
    private File curr_gseaResultDir;
    private EnrichmentDb curr_edb;
    private JComponent fFiller;
    private Component tableComponent;
    private LeadingEdgeReportViewer fInstance = this;
    private JideTabbedPane sharedTabbedPane;

    public LeadingEdgeReportViewer() {
        super(NAME, ICON, "Leading edge analysis");
        this.jbInit();
    }

    private void jbInit() {
        JButton jButton = new JButton("Load GSEA Results");
        jButton.addActionListener(new LeadingEdgeReportViewer$1(this));
        this.fReportParam = new ReportCacheChooserParam("Select a GSEA result from the application cache", false);
        this.fDirParam = new DirParam("dir", "[ OR ] Locate a GSEA result folder from the file system", "[ OR ] Locate a GSEA report folder from the file system", false);
        Param[] paramArray = new Param[]{this.fReportParam, this.fDirParam};
        StringBuffer stringBuffer = LeadingEdgeReportViewer._createColStr();
        StringBuffer stringBuffer2 = LeadingEdgeReportViewer._createRowStr(paramArray);
        PanelBuilder panelBuilder = ParamSetFormForAFew.createPanelBuilder(stringBuffer, stringBuffer2);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 3;
        for (int i2 = 0; i2 < paramArray.length; ++i2) {
            GFieldPlusChooser gFieldPlusChooser = paramArray[i2].getSelectionComponent();
            if (paramArray[i2].isFileBased() && gFieldPlusChooser instanceof GDirFieldPlusChooser) {
                ((GDirFieldPlusChooser)gFieldPlusChooser).getTextField().setBackground(ParamSetFormForAFew.LIGHT_GREEN);
            }
            JLabel jLabel = new JLabel(paramArray[i2].getHtmlLabel_v3());
            ParamSetFormForAFew.enableToolTips(jLabel, paramArray[i2]);
            panelBuilder.add((Component)jLabel, cellConstraints.xy(1, n));
            panelBuilder.add((Component)gFieldPlusChooser.getComponent(), cellConstraints.xy(3, n));
            n += 2;
        }
        panelBuilder.add((Component)new JLabel(""), cellConstraints.xy(1, n));
        panelBuilder.add((Component)jButton, cellConstraints.xy(3, n));
        JPanel jPanel = panelBuilder.getPanel();
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)jPanel, "North");
        this.fFiller = GuiHelper.createWaitingPlaceholder();
        this.add((Component)this.fFiller, "Center");
        this.revalidate();
    }

    public final String[] getSelectedResultNames() {
        int[] nArray = this.sortableTable.getSelectedRows();
        String[] stringArray = new String[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringArray[i2] = this.sortableTable.getModel().getValueAt(nArray[i2], 1).toString();
        }
        return stringArray;
    }

    public final int getNumSelectedRows() {
        return this.sortableTable.getSelectedRows().length;
    }

    private Component createViewAndSearchComponent(EnrichmentDb enrichmentDb, String string) {
        StringDataframe stringDataframe = EnrichmentReports.createGseaLikeReport_sdf(enrichmentDb, string);
        THashSet tHashSet = new THashSet();
        tHashSet.add("SIZE");
        tHashSet.add("ES");
        tHashSet.add("NES");
        tHashSet.add("NOM p-val");
        tHashSet.add("FDR q-val");
        tHashSet.add("FWER p-val");
        StringDataframeModel stringDataframeModel = new StringDataframeModel(stringDataframe, tHashSet);
        stringDataframeModel.setFeatureName("GENE SET");
        NumberedProxyModel numberedProxyModel = new NumberedProxyModel(stringDataframeModel);
        QuickFilterPane quickFilterPane = new QuickFilterPane(new SortableTableModel(numberedProxyModel), new int[]{1});
        JPanel jPanel = new JPanel(new FlowLayout(3));
        QuickTableFilterField quickTableFilterField = new QuickTableFilterField(quickFilterPane.getDisplayTableModel(), new int[]{1});
        jPanel.add(quickTableFilterField);
        jPanel.setBorder(new JideTitledBorder(new PartialEtchedBorder(1, 1), "", 4, 1));
        JideSplitPane jideSplitPane = new JideSplitPane(0);
        JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(new JideTitledBorder(new PartialEtchedBorder(1, 1), "Filtered result List", 4, 1), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        JLabel jLabel = new JLabel(quickTableFilterField.getDisplayTableModel().getRowCount() + " out of " + numberedProxyModel.getRowCount() + " gene sets");
        jLabel.setHorizontalAlignment(0);
        jLabel.setForeground(GuiHelper.COLOR_DARK_GREEN);
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.sortableTable = new SortableTable(quickTableFilterField.getDisplayTableModel());
        this.sortableTable.setDefaultRenderer(String.class, new LeadingEdgeReportViewer$ESRenderer(this, stringDataframeModel));
        ListSelectionModel listSelectionModel = this.sortableTable.getSelectionModel();
        listSelectionModel.setSelectionMode(2);
        listSelectionModel.addListSelectionListener(new LeadingEdgeReportViewer$2(this));
        this.sortableTable.setAutoResizeMode(0);
        quickTableFilterField.setTable(this.sortableTable);
        JScrollPane jScrollPane = new JScrollPane(this.sortableTable, 22, 30);
        quickTableFilterField.getDisplayTableModel().addTableModelListener(new LeadingEdgeReportViewer$3(this, jLabel, numberedProxyModel));
        jPanel2.add((Component)jLabel, "First");
        jPanel2.add(jScrollPane);
        jideSplitPane.addPane(jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout(3, 3));
        jPanel3.add((Component)jPanel, "First");
        jPanel3.add(jideSplitPane);
        return jPanel3;
    }

    private static StringBuffer _createColStr() {
        return new StringBuffer("220dlu,      4dlu,        250dlu,   4dlu,  40dlu");
    }

    private static StringBuffer _createRowStr(Param[] paramArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("pref, 10dlu,");
        for (int i2 = 0; i2 < paramArray.length + 1; ++i2) {
            stringBuffer.append("pref, 5dlu");
            if (paramArray.length == i2 - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer;
    }

    @Override
    public final JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }

    static final /* synthetic */ ReportCacheChooserParam access$000(LeadingEdgeReportViewer leadingEdgeReportViewer) {
        return leadingEdgeReportViewer.fReportParam;
    }

    static final /* synthetic */ DirParam access$100(LeadingEdgeReportViewer leadingEdgeReportViewer) {
        return leadingEdgeReportViewer.fDirParam;
    }

    static final /* synthetic */ File access$202(LeadingEdgeReportViewer leadingEdgeReportViewer, File file) {
        leadingEdgeReportViewer.curr_gseaResultDir = file;
        return leadingEdgeReportViewer.curr_gseaResultDir;
    }

    static final /* synthetic */ File access$200(LeadingEdgeReportViewer leadingEdgeReportViewer) {
        return leadingEdgeReportViewer.curr_gseaResultDir;
    }

    static final /* synthetic */ Logger access$300(LeadingEdgeReportViewer leadingEdgeReportViewer) {
        return leadingEdgeReportViewer.log;
    }

    static final /* synthetic */ EnrichmentDb access$402(LeadingEdgeReportViewer leadingEdgeReportViewer, EnrichmentDb enrichmentDb) {
        leadingEdgeReportViewer.curr_edb = enrichmentDb;
        return leadingEdgeReportViewer.curr_edb;
    }

    static final /* synthetic */ JideTabbedPane access$500(LeadingEdgeReportViewer leadingEdgeReportViewer) {
        return leadingEdgeReportViewer.sharedTabbedPane;
    }

    static final /* synthetic */ JideTabbedPane access$502(LeadingEdgeReportViewer leadingEdgeReportViewer, JideTabbedPane jideTabbedPane) {
        leadingEdgeReportViewer.sharedTabbedPane = jideTabbedPane;
        return leadingEdgeReportViewer.sharedTabbedPane;
    }

    static final /* synthetic */ JComponent access$600(LeadingEdgeReportViewer leadingEdgeReportViewer) {
        return leadingEdgeReportViewer.fFiller;
    }

    static final /* synthetic */ LeadingEdgeReportViewer access$700(LeadingEdgeReportViewer leadingEdgeReportViewer) {
        return leadingEdgeReportViewer.fInstance;
    }

    static final /* synthetic */ SortableTable access$800(LeadingEdgeReportViewer leadingEdgeReportViewer) {
        return leadingEdgeReportViewer.sortableTable;
    }
}

