/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.utils.ClassUtils;
import javax.swing.Action;
import org.apache.log4j.Logger;
import xtools.api.param.Param;

public abstract class AbstractParam
implements Param {
    protected static final Logger klog = XLogger.getLogger(AbstractParam.class);
    protected Logger log;
    private String fName;
    private Class[] fClassTypes;
    private String fDesc;
    private String fNameEnglish;
    private StringBuffer fHtmlLabel_v2;
    private StringBuffer fHtmlLabel_v3;
    private StringBuffer fHtmlLabel;
    private boolean fReqd;
    private Object fValue;
    private Object[] fHints;
    private Object fDefault;
    private Param.Type fType;
    protected StringBuffer fLongDesc;

    protected AbstractParam() {
    }

    protected AbstractParam(String string, Class[] classArray, String string2, Object[] objectArray, boolean bl) {
        this(string, (String)null, classArray, string2, objectArray, bl);
    }

    protected AbstractParam(String string, Class clazz, String string2, Object[] objectArray, boolean bl) {
        this(string, (String)null, new Class[]{clazz}, string2, objectArray, bl);
    }

    protected AbstractParam(String string, Class[] classArray, String string2, Object object, boolean bl) {
        if (object == null) {
            throw new IllegalArgumentException("def_andonly_hint param cannot be null");
        }
        this.init(string, null, classArray, string2, new Object[]{object}, object, bl, null);
    }

    protected AbstractParam(String string, Class clazz, String string2, Object object, boolean bl) {
        this(string, null, new Class[]{clazz}, string2, object, bl);
    }

    protected AbstractParam(String string, Class[] classArray, String string2, Object object, Object[] objectArray, boolean bl) {
        this.init(string, null, classArray, string2, objectArray, object, bl, null);
    }

    protected AbstractParam(String string, Class clazz, String string2, Object object, Object[] objectArray, boolean bl) {
        this(string, null, new Class[]{clazz}, string2, object, objectArray, bl);
    }

    protected AbstractParam(String string, String string2, Class[] classArray, String string3, Object[] objectArray, boolean bl) {
        if (objectArray == null) {
            throw new IllegalArgumentException("hint param cannot be null");
        }
        Object object = objectArray.length > 0 ? objectArray[0] : null;
        this.init(string, string2, classArray, string3, objectArray, object, bl, null);
    }

    protected AbstractParam(String string, String string2, Class clazz, String string3, Object[] objectArray, boolean bl) {
        this(string, string2, new Class[]{clazz}, string3, objectArray, bl);
    }

    protected AbstractParam(String string, String string2, Class[] classArray, String string3, Object object, boolean bl) {
        if (object == null) {
            throw new IllegalArgumentException("def_andonly_hint param cannot be null");
        }
        this.init(string, string2, classArray, string3, new Object[]{object}, object, bl, null);
    }

    protected AbstractParam(String string, String string2, Class clazz, String string3, Object object, boolean bl) {
        this(string, string2, new Class[]{clazz}, string3, object, bl);
    }

    protected AbstractParam(String string, String string2, Class clazz, String string3, Object object, boolean bl, Param.Type type) {
        this.init(string, string2, new Class[]{clazz}, string3, new Object[]{object}, object, bl, type);
    }

    protected AbstractParam(String string, String string2, Class[] classArray, String string3, Object object, Object[] objectArray, boolean bl) {
        this.init(string, string2, classArray, string3, objectArray, object, bl, null);
    }

    protected AbstractParam(String string, String string2, Class[] classArray, String string3, Object object, Object[] objectArray, boolean bl, Param.Type type) {
        this.init(string, string2, classArray, string3, objectArray, object, bl, type);
    }

    protected AbstractParam(String string, String string2, Class clazz, String string3, Object object, Object[] objectArray, boolean bl) {
        this(string, string2, new Class[]{clazz}, string3, object, objectArray, bl);
    }

    protected AbstractParam(String string, String string2, Class clazz, String string3, Object object, Object[] objectArray, boolean bl, Param.Type type) {
        this(string, string2, new Class[]{clazz}, string3, object, objectArray, bl, type);
    }

    protected final void init(String string, String string2, Class[] classArray, String string3, Object[] objectArray, Object object, boolean bl, Param.Type type) {
        if (string == null) {
            throw new IllegalArgumentException("name param cannot be null");
        }
        if (classArray == null) {
            throw new IllegalArgumentException("types param cannot be null");
        }
        if (classArray.length == 0) {
            throw new IllegalArgumentException("types param cannot be empty");
        }
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (classArray[i2] != null) continue;
            throw new IllegalArgumentException("types param cannot be null at: " + i2);
        }
        if (string3 == null) {
            throw new IllegalArgumentException("desc param cannot be null");
        }
        if (objectArray == null) {
            throw new IllegalArgumentException("hint param cannot be null");
        }
        if (string.indexOf(" ") != -1) {
            throw new IllegalArgumentException("Programmatic error: param name cannot contain whitespace");
        }
        if (string.indexOf("'") != -1) {
            throw new IllegalArgumentException("Programmatic error: param name cannot contain quote '");
        }
        if (string.indexOf("\"") != -1) {
            throw new IllegalArgumentException("Programmatic error: param name cannot contain quote \"");
        }
        this.fName = string;
        this.fNameEnglish = string2;
        this.fClassTypes = classArray;
        this.fDesc = string3;
        this.fHints = objectArray;
        this.fReqd = bl;
        this.fDefault = object;
        this.fType = type;
        this.log = XLogger.getLogger(this.getClass());
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getHelpURL() {
        return JarResources.getHelpURL(this.getName());
    }

    protected final Action createHelpAction() {
        return JarResources.createHelpAction(this.getName());
    }

    @Override
    public Param.Type getType() {
        if (this.fType != null) {
            return this.fType;
        }
        if (this.fReqd) {
            return Param.REQUIRED;
        }
        return Param.BASIC;
    }

    @Override
    public void setType(Param.Type type) {
        this.fType = type;
    }

    @Override
    public String getHtmlLabel() {
        if (this.fHtmlLabel == null) {
            this.fHtmlLabel = new StringBuffer("<Html><body><b>").append(this.getNameEnglish()).append("</b>");
            this.fHtmlLabel.append("&nbsp(<u><font color=\"#0000FF\">").append(this.getName()).append("</font></u>)</body></Html>");
        }
        return this.fHtmlLabel.toString();
    }

    @Override
    public String getHtmlLabel_v2() {
        if (this.fHtmlLabel_v2 == null) {
            this.fHtmlLabel_v2 = new StringBuffer("<Html><body><b>").append(this.getNameEnglish()).append("</b></body></Html>");
        }
        return this.fHtmlLabel_v2.toString();
    }

    @Override
    public String getHtmlLabel_v3() {
        if (this.fHtmlLabel_v3 == null) {
            this.fHtmlLabel_v3 = new StringBuffer("<Html><body><b>").append(this.getNameEnglish()).append("</b>");
            if (this.isReqd() || this.getType() == Param.PSEUDO_REQUIRED) {
                this.fHtmlLabel_v3.append("<font color=\"red\">*</font>");
            }
            this.fHtmlLabel_v3.append("</body></Html>");
        }
        return this.fHtmlLabel_v3.toString();
    }

    @Override
    public String getDesc() {
        return this.fDesc;
    }

    @Override
    public String getNameEnglish() {
        if (this.fNameEnglish == null) {
            return this.fName;
        }
        return this.fNameEnglish;
    }

    @Override
    public String getLongDesc() {
        if (this.fLongDesc != null) {
            return this.fLongDesc.toString();
        }
        return this.fDesc;
    }

    @Override
    public Class[] getTypes() {
        return this.fClassTypes;
    }

    @Override
    public String formatForCmdLine() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "na";
        if (this.fClassTypes != null && this.fClassTypes.length > 0) {
            string = ClassUtils.shorten(this.fClassTypes[0]);
        }
        stringBuffer.append("-").append(this.fName).append(' ').append('<').append(string).append('>').append("\n");
        stringBuffer.append("\t").append(this.fDesc).append("\n");
        String string2 = AbstractParam._getCmdLineVersion(this.fDefault);
        if (string2 != null) {
            stringBuffer.append("\tDefault: ");
            stringBuffer.append(string2.toString());
        }
        boolean bl = false;
        if (this.fHints != null && this.fHints.length > 0) {
            for (int i2 = 0; i2 < this.fHints.length; ++i2) {
                String string3 = AbstractParam._getCmdLineVersion(this.fHints[i2]);
                if (string3 == null) continue;
                if (!bl) {
                    stringBuffer.append("\n\t");
                    stringBuffer.append("Hints  : ");
                    bl = true;
                }
                stringBuffer.append(string3);
                if (i2 == this.fHints.length - 1) continue;
                stringBuffer.append(',');
            }
        }
        if (bl) {
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private static String _getCmdLineVersion(Object object) {
        String string = null;
        if (object instanceof PersistentObject) {
            string = ((PersistentObject)object).getName();
        } else if (object != null) {
            if (object instanceof PersistentObject[]) {
                PersistentObject[] persistentObjectArray = (PersistentObject[])object;
                if (persistentObjectArray.length > 0) {
                    string = persistentObjectArray[0].getName();
                }
            } else if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                if (objectArray.length > 0) {
                    string = objectArray[0].toString();
                }
            } else {
                string = object.toString();
            }
        }
        return string;
    }

    @Override
    public void printf() {
        System.out.println(this.toString());
    }

    @Override
    public boolean isReqd() {
        return this.fReqd;
    }

    public final boolean equals(Object object) {
        return object instanceof AbstractParam && this.fName.equals(((AbstractParam)object).fName);
    }

    public final int hashCode() {
        return this.fName.hashCode();
    }

    @Override
    public void setValue(Object object) {
        this.fValue = object;
    }

    @Override
    public Object getValue() {
        if (this.fValue != null) {
            return this.fValue;
        }
        return this.fDefault;
    }

    @Override
    public String getValueStringRepresentation(boolean bl) {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    @Override
    public Object[] getHints() {
        return this.fHints;
    }

    protected final void setHints(Object[] objectArray) {
        this.fHints = objectArray;
    }

    @Override
    public Object getDefault() {
        return this.fDefault;
    }

    @Override
    public boolean isSpecified() {
        boolean bl;
        Object object = this.getDefault();
        if (object != null) {
            bl = true;
            if (object instanceof Object[] && ((Object[])object).length == 0) {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (this.fValue == null && !bl) {
            return false;
        }
        if (this.fValue != null && this.fValue instanceof Object[] && ((Object[])this.fValue).length != 0) {
            return true;
        }
        return this.fValue == null || this.fValue.toString().length() != 0 || bl;
    }

    protected static final Float[] toFloats(float[] fArray) {
        Float[] floatArray = new Float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            floatArray[i2] = new Float(fArray[i2]);
        }
        return floatArray;
    }

    protected static final Integer[] toInts(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            integerArray[i2] = new Integer(nArray[i2]);
        }
        return integerArray;
    }
}

