/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import xtools.api.AbstractTool;
import xtools.api.param.DatasetChooserAbstractParam;
import xtools.api.param.GeneSetOptParam;

public class DatasetOptParam
extends DatasetChooserAbstractParam {
    public DatasetOptParam(String string, String string2) {
        super(string, string2, false, false);
    }

    public DatasetOptParam(String string) {
        this(string, "Expression dataset - with rows as genes and columns as samples (for instance: res, gct, pcl files)");
    }

    public DatasetOptParam() {
        this("res");
    }

    @Override
    public final void setValue(Dataset dataset) {
        super.setValue(dataset);
    }

    public final Dataset getDataset() {
        Dataset[] datasetArray = this._getDatasets();
        if (datasetArray.length != 1) {
            throw new IllegalStateException("Program error - too many dss expected 1, got: " + datasetArray.length);
        }
        return datasetArray[0];
    }

    public final Dataset getDataset(SampleAnnot sampleAnnot, GeneSetOptParam geneSetOptParam) {
        Dataset dataset = this.getDataset(sampleAnnot);
        if (geneSetOptParam != null && geneSetOptParam.isSpecified()) {
            dataset = new DatasetGenerators().extractRows(dataset, geneSetOptParam.getGeneSet());
        }
        this.log.debug(dataset.getQuickInfo());
        return dataset;
    }

    public final Dataset getDataset(SampleAnnot sampleAnnot) {
        Dataset dataset = this.getDataset();
        AbstractTool.setChip(dataset, sampleAnnot.getChip(dataset));
        AbstractTool.setSampleAnnot(dataset, sampleAnnot);
        this.log.debug("fullDs: " + dataset.getQuickInfo() + " " + sampleAnnot.getNumSamples());
        if (dataset.getNumCol() != sampleAnnot.getNumSamples()) {
            throw new IllegalStateException();
        }
        return dataset;
    }
}

