/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.alg.GeneSetGenerators;
import edu.mit.broad.genome.io.FTPUtils;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.map.Chip2ChipMapperSymbol;
import edu.mit.broad.vdb.map.MGeneSet;
import edu.mit.broad.vdb.map.MGeneSetMatrix;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import xtools.api.param.AbstractParam;
import xtools.api.param.ChipOptParam;
import xtools.api.param.DatasetMultiChooserParam;
import xtools.api.param.DatasetOptParam;
import xtools.api.param.DatasetReqdParam;
import xtools.api.param.FeatureSpaceReqdParam;
import xtools.api.param.GeneSetMatrixChooserAbstractParam$GeneSetsStruc;
import xtools.api.param.GeneSetMatrixChooserAbstractParam$MyPobActionListener;
import xtools.api.param.IntegerParam;
import xtools.api.param.ParamHelper;
import xtools.api.ui.GeneSetMatrixChooserUI;

abstract class GeneSetMatrixChooserAbstractParam
extends AbstractParam {
    private boolean fMultipleAllowed = true;
    private GeneSetMatrixChooserAbstractParam$MyPobActionListener fAl;
    protected GeneSetMatrixChooserUI fChooser;
    private boolean fIncludeGmx = true;

    GeneSetMatrixChooserAbstractParam(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        super(string, string2, GeneSetMatrix[].class, string3, (Object)new GeneSetMatrix[0], (Object[])new GeneSetMatrix[0], bl);
        this.fMultipleAllowed = bl2;
        this.fIncludeGmx = bl3;
    }

    GeneSetMatrixChooserAbstractParam(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        super(string, GeneSetMatrix[].class, string2, (Object)new GeneSetMatrix[0], (Object[])new GeneSetMatrix[0], bl);
        this.fMultipleAllowed = bl2;
        this.fIncludeGmx = bl3;
    }

    public GeneSet[] getGeneSets(List list) {
        GeneSet[] geneSetArray = this.getGeneSetMatrixCombo(true).getGeneSets();
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            if (!list.contains(geneSetArray[i2].getName())) continue;
            arrayList.add(geneSetArray[i2]);
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    public GeneSet[] getGeneSets(IntegerParam integerParam, IntegerParam integerParam2, Set set, boolean bl) {
        GeneSet[] geneSetArray = this.getGeneSetMatrixCombo(bl).getGeneSets();
        int n = integerParam.getIValue();
        int n2 = integerParam2.getIValue();
        return GeneSetGenerators.removeGeneSetsBySize(geneSetArray, n, n2, set);
    }

    public GeneSet[] getGeneSets(IntegerParam integerParam, IntegerParam integerParam2, Dataset dataset, boolean bl) {
        int n = integerParam.getIValue();
        int n2 = integerParam2.getIValue();
        return this.getGeneSets(n, n2, dataset, bl);
    }

    public GeneSet[] getGeneSets(int n, int n2, Dataset dataset, boolean bl) {
        GeneSet[] geneSetArray = this.getGeneSetMatrixCombo(bl).getGeneSets();
        return GeneSetGenerators.removeGeneSetsBySize(geneSetArray, n, n2, dataset);
    }

    public GeneSet[] getGeneSets(IntegerParam integerParam, IntegerParam integerParam2, DatasetOptParam datasetOptParam) {
        GeneSet[] geneSetArray = this._getGeneSets().gsets;
        boolean bl = true;
        if (datasetOptParam.isSpecified()) {
            if (integerParam.isSpecified()) {
                geneSetArray = GeneSetGenerators.removeGeneSetsSmallerThan(geneSetArray, integerParam.getIValue(), datasetOptParam.getDataset(), bl);
                bl = false;
            }
            if (integerParam2.isSpecified()) {
                geneSetArray = GeneSetGenerators.removeGeneSetsLargerThan(geneSetArray, integerParam2.getIValue(), datasetOptParam.getDataset(), bl);
            }
        } else {
            if (integerParam.isSpecified()) {
                geneSetArray = GeneSetGenerators.removeGeneSetsSmallerThan(geneSetArray, integerParam.getIValue());
            }
            if (integerParam2.isSpecified()) {
                geneSetArray = GeneSetGenerators.removeGeneSetsLargerThan(geneSetArray, integerParam2.getIValue());
            }
        }
        return geneSetArray;
    }

    public GeneSet[] getGeneSets(DatasetOptParam datasetOptParam, boolean bl) {
        GeneSet[] geneSetArray = this._getGeneSets().gsets;
        if (datasetOptParam.isSpecified()) {
            return GeneSetGenerators.qualifyGeneSets(geneSetArray, datasetOptParam.getDataset(), bl);
        }
        return geneSetArray;
    }

    public GeneSet[] getGeneSets(Dataset dataset, boolean bl) {
        GeneSet[] geneSetArray = this._getGeneSets().gsets;
        return GeneSetGenerators.qualifyGeneSets(geneSetArray, dataset, bl);
    }

    public GeneSet[] getGeneSets(boolean bl) {
        return this.getGeneSetMatrixCombo(bl).getGeneSets();
    }

    public GeneSet[] getGeneSets(IntegerParam integerParam, IntegerParam integerParam2, boolean bl) {
        GeneSet[] geneSetArray = this._getGeneSets().gsets;
        if (integerParam.isSpecified()) {
            geneSetArray = GeneSetGenerators.removeGeneSetsSmallerThan(geneSetArray, integerParam.getIValue());
        }
        if (integerParam2.isSpecified()) {
            geneSetArray = GeneSetGenerators.removeGeneSetsLargerThan(geneSetArray, integerParam2.getIValue());
        }
        return geneSetArray;
    }

    public GeneSet getGeneSetCombo() {
        GeneSet[] geneSetArray = this._getGeneSets().gsets;
        if (geneSetArray.length == 0) {
            throw new IllegalArgumentException("Not specified!!");
        }
        if (geneSetArray.length == 1) {
            return geneSetArray[0];
        }
        return new FSet("combo_geneset", geneSetArray);
    }

    public GeneSetMatrix getGeneSetMatrixCombo(boolean bl) {
        return this._getGeneSets().toGm(bl);
    }

    private boolean _isSymbols(GeneSet[] geneSetArray) {
        Chip chip = VdbRuntimeResources.getChip_Gene_Symbol();
        int n = 0;
        int n2 = 0;
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            for (int i3 = 0; i3 < geneSetArray[i2].getNumMembers(); ++i3) {
                if (chip.isProbe(geneSetArray[i2].getMember(i3))) {
                    ++n;
                } else {
                    ++n2;
                }
                if (n > 10) {
                    return true;
                }
                if (n2 <= 100) continue;
                return false;
            }
        }
        return false;
    }

    private GeneSet[] mapToSymbols(GeneSet[] geneSetArray, Chip chip) {
        Chip2ChipMapperSymbol chip2ChipMapperSymbol = VdbRuntimeResources.getGeneSymbolMapper(chip, true);
        MGeneSetMatrix mGeneSetMatrix = chip2ChipMapperSymbol.map(new DefaultGeneSetMatrix("foo", geneSetArray), false);
        MGeneSet[] mGeneSetArray = mGeneSetMatrix.getMappedGeneSets();
        GeneSet[] geneSetArray2 = new GeneSet[mGeneSetArray.length];
        for (int i2 = 0; i2 < mGeneSetArray.length; ++i2) {
            geneSetArray2[i2] = mGeneSetArray[i2].getMappedGeneSet(true);
        }
        return geneSetArray2;
    }

    private GeneSet[] mapFromSymbols(GeneSet[] geneSetArray, Chip chip) {
        Chip2ChipMapperSymbol chip2ChipMapperSymbol = VdbRuntimeResources.getGeneSymbolMapper(chip, false);
        MGeneSetMatrix mGeneSetMatrix = chip2ChipMapperSymbol.map(new DefaultGeneSetMatrix("foo", geneSetArray), false);
        MGeneSet[] mGeneSetArray = mGeneSetMatrix.getMappedGeneSets();
        GeneSet[] geneSetArray2 = new GeneSet[mGeneSetArray.length];
        for (int i2 = 0; i2 < mGeneSetArray.length; ++i2) {
            geneSetArray2[i2] = mGeneSetArray[i2].getMappedGeneSet(true);
        }
        return geneSetArray2;
    }

    public GeneSet[] getGeneSetsCombo(boolean bl, FeatureSpaceReqdParam featureSpaceReqdParam, ChipOptParam chipOptParam) {
        GeneSet[] geneSetArray = this._getGeneSets().toGm(bl).getGeneSets();
        boolean bl2 = this._isSymbols(geneSetArray);
        if (featureSpaceReqdParam.isSymbols() && bl2) {
            klog.debug("No gene set mapping automagix was done");
        } else if (featureSpaceReqdParam.isSymbols() && !bl2) {
            klog.debug("Internally mapping gene sets to Gene Symbols");
            if (!chipOptParam.isSpecified()) {
                throw new IllegalArgumentException("Chip param must be specified. This is needed for mapping gene sets from native to gene symbols");
            }
            geneSetArray = this.mapToSymbols(geneSetArray, chipOptParam.getChip());
        } else if (featureSpaceReqdParam.isNative() && bl2) {
            klog.debug("Internally mapping gene sets from Gene Symbols to native");
            if (!chipOptParam.isSpecified()) {
                throw new IllegalArgumentException("Chip param must be specified. This is needed for mapping gene sets from symbols to native(i.e datasets) format");
            }
            geneSetArray = this.mapFromSymbols(geneSetArray, chipOptParam.getChip());
        } else if (featureSpaceReqdParam.isNative() && !bl2) {
            klog.debug("No gene set mapping automagix was done");
        }
        return geneSetArray;
    }

    public GeneSetMatrix getGeneSetMatrixCombo(IntegerParam integerParam, IntegerParam integerParam2, boolean bl) {
        return this._getGeneSets().toGm(integerParam, integerParam2, bl);
    }

    public GeneSetMatrix getGeneSetMatrixCombo(IntegerParam integerParam, IntegerParam integerParam2, Dataset dataset, boolean bl) {
        return this._getGeneSets().toGm(integerParam, integerParam2, dataset, bl);
    }

    public GeneSetMatrix getGeneSetMatrixCombo(IntegerParam integerParam, Dataset dataset, boolean bl) {
        return this._getGeneSets().toGm(integerParam.getIValue(), Integer.MAX_VALUE, dataset, bl);
    }

    public GeneSetMatrix getGeneSetMatrixCombo(DatasetMultiChooserParam datasetMultiChooserParam, boolean bl) {
        if (datasetMultiChooserParam.isSpecified()) {
            Dataset[] datasetArray = datasetMultiChooserParam.getDatasets();
            return new DefaultGeneSetMatrix("combo_qualified", this.getGeneSets(bl), datasetArray);
        }
        return this.getGeneSetMatrixCombo(bl);
    }

    public GeneSetMatrix getGeneSetMatrixCombo(DatasetOptParam datasetOptParam, boolean bl) {
        if (datasetOptParam.isSpecified()) {
            Dataset[] datasetArray = new Dataset[]{datasetOptParam.getDataset()};
            String string = this._getName() + "_qualified";
            return new DefaultGeneSetMatrix(string, this.getGeneSets(bl), datasetArray);
        }
        return this.getGeneSetMatrixCombo(bl);
    }

    public GeneSetMatrix getGeneSetMatrixCombo(DatasetReqdParam datasetReqdParam, boolean bl) {
        String string = this._getName() + "_qualified";
        return new DefaultGeneSetMatrix(string, this.getGeneSets(bl), new Dataset[]{datasetReqdParam.getDataset()});
    }

    public GeneSetMatrix getGeneSetMatrixCombo(Dataset dataset, boolean bl) {
        String string = this._getName() + "_qualified";
        return new DefaultGeneSetMatrix(string, this.getGeneSets(bl), new Dataset[]{dataset});
    }

    protected final Object[] _getObjects() {
        Object[] objectArray;
        Object object = this.getValue();
        if (object instanceof String) {
            String[] stringArray = GeneSetMatrixChooserAbstractParam._parse(object.toString());
            objectArray = new Object[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].toLowerCase().startsWith("ftp.") || stringArray[i2].toLowerCase().startsWith("gseaftp.")) {
                    URL uRL = new URL("ftp://" + stringArray[i2]);
                    FileInputStream fileInputStream = FTPUtils.ftpDownloadAndCreateInputStream(uRL);
                    GeneSetMatrix geneSetMatrix = ParserFactory.readGeneSetMatrix(stringArray[i2], fileInputStream, false);
                    if (AuxUtils.isAux(stringArray[i2])) {
                        objectArray[i2] = geneSetMatrix.getGeneSet(AuxUtils.getAuxNameOnlyIncludingHash(stringArray[i2]));
                        continue;
                    }
                    objectArray[i2] = geneSetMatrix;
                    continue;
                }
                objectArray[i2] = AuxUtils.isAux(stringArray[i2]) ? ParserFactory.readGeneSet(new File(stringArray[i2]), true) : ParserFactory.read(new File(stringArray[i2]), true);
            }
        } else {
            objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        }
        return objectArray;
    }

    private String _getName(Object[] objectArray) {
        String string = "combo";
        if (objectArray.length == 1 && objectArray[0] instanceof GeneSetMatrix) {
            string = ((GeneSetMatrix)objectArray[0]).getName();
        }
        return string;
    }

    private String _getName() {
        return this._getName(this._getObjects());
    }

    protected final GeneSetMatrixChooserAbstractParam$GeneSetsStruc _getGeneSets() {
        Object[] objectArray = this._getObjects();
        if (this.isReqd() && objectArray.length == 0) {
            throw new IllegalArgumentException("Must specify GeneSetMatrix parameter: " + this.getNameEnglish() + " (" + this.getDesc() + ")");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = this._getName(objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] instanceof GeneSetMatrix) {
                arrayList.addAll(((GeneSetMatrix)objectArray[i2]).getGeneSetsL());
                continue;
            }
            if (objectArray[i2] instanceof GeneSet) {
                arrayList.add(objectArray[i2]);
                continue;
            }
            if (objectArray[i2] instanceof Dataset) {
                arrayList.add(((Dataset)objectArray[i2]).getRowNamesGeneSet());
                continue;
            }
            if (objectArray[i2] instanceof Chip) {
                arrayList.add(((Chip)objectArray[i2]).getProbeNamesAsGeneSet());
                continue;
            }
            throw new IllegalArgumentException("Unknown object: " + objectArray[i2]);
        }
        return new GeneSetMatrixChooserAbstractParam$GeneSetsStruc(this, string, arrayList.toArray(new GeneSet[arrayList.size()]));
    }

    protected final GeneSetMatrix[] _getGeneSetMatrices() {
        Object[] objectArray = this._getObjects();
        GeneSetMatrix[] geneSetMatrixArray = new GeneSetMatrix[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            GeneSet geneSet;
            if (objectArray[i2] instanceof GeneSetMatrix) {
                geneSetMatrixArray[i2] = (GeneSetMatrix)objectArray[i2];
                continue;
            }
            if (objectArray[i2] instanceof GeneSet) {
                geneSet = (GeneSet)objectArray[i2];
                geneSetMatrixArray[i2] = new DefaultGeneSetMatrix(geneSet.getName(), new GeneSet[]{geneSet});
                continue;
            }
            if (objectArray[i2] instanceof Dataset) {
                geneSet = ((Dataset)objectArray[i2]).getRowNamesGeneSet();
                geneSetMatrixArray[i2] = new DefaultGeneSetMatrix(geneSet.getName(), new GeneSet[]{geneSet});
                continue;
            }
            if (objectArray[i2] instanceof Chip) {
                geneSet = ((Chip)objectArray[i2]).getProbeNamesAsGeneSet();
                geneSetMatrixArray[i2] = new DefaultGeneSetMatrix(geneSet.getName(), new GeneSet[]{geneSet});
                continue;
            }
            throw new IllegalArgumentException("Unknown object: " + objectArray[i2]);
        }
        if (this.isReqd() && geneSetMatrixArray.length == 0) {
            throw new IllegalArgumentException("Must specify GeneSetMatrix parameters, got: " + geneSetMatrixArray.length);
        }
        return geneSetMatrixArray;
    }

    public void setValue(String[] stringArray) {
        try {
            System.out.println(">> number of paths: " + stringArray.length + " >" + stringArray);
            TraceUtils.showTrace();
            Object[] objectArray = new Object[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                System.out.println(">>> reading path: " + stringArray[i2]);
                File file = new File(stringArray[i2]);
                objectArray[i2] = ParserFactory.read(file, true);
            }
            super.setValue(objectArray);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static String[] _parse(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter s cannot be null");
        }
        Set set = ParseUtils.string2stringsSet(string, ",", false);
        System.out.println("to parse>" + string + "< got: " + set);
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            if (string2.length() <= 0) continue;
            hashSet.add(string2);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public void setValue(String string) {
        this.setValue(GeneSetMatrixChooserAbstractParam._parse(string));
    }

    private String format(Object[] objectArray) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == null) continue;
            this.log.debug(objectArray[i2].getClass());
            if (objectArray[i2] instanceof PersistentObject) {
                String string = ParserFactory.getCache().getSourcePath(objectArray[i2]);
                stringBuffer.append(string);
            } else {
                stringBuffer.append(objectArray[i2].toString().trim());
            }
            if (i2 == objectArray.length - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    protected final ActionListener getActionListener() {
        if (this.fAl == null) {
            this.fAl = new GeneSetMatrixChooserAbstractParam$MyPobActionListener(this.fMultipleAllowed, this.fIncludeGmx);
            this.fAl.setChooser(this.fChooser);
        }
        return this.fAl;
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    @Override
    public String getValueStringRepresentation(boolean bl) {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return this.format(objectArray);
        }
        return this.format(new Object[]{object});
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.fChooser == null) {
            this.fChooser = new GeneSetMatrixChooserUI(false);
            this.fChooser.setCustomActionListener(this.getActionListener());
            String string = this.getValueStringRepresentation(false);
            if (string == null) {
                string = this.format((Object[])this.getDefault());
            }
            if (this.isFileBased()) {
                // empty if block
            }
            this.fChooser.setText(string);
            ParamHelper.addDocumentListener(this.fChooser.getTextField(), this);
        }
        return this.fChooser;
    }

    private static boolean isVersion(String string, String string2) {
        int n = string2.toLowerCase().indexOf(string);
        return n != -1;
    }

    static final /* synthetic */ boolean access$000(String string, String string2) {
        return GeneSetMatrixChooserAbstractParam.isVersion(string, string2);
    }
}

