/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GOptionsFieldPlusChooser;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.tui.ReportStub;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import xtools.api.param.AbstractObjectChooserParam;
import xtools.api.param.ReportCacheChooserParam$MyActionListener;
import xtools.api.param.ReportCacheChooserParam$MyListRenderer;

public class ReportCacheChooserParam
extends AbstractObjectChooserParam {
    public ReportCacheChooserParam(boolean bl) {
        super("rpt_dir", "Report dir", Report.class, "Report directory", (Object[])new Report[0], (Object[])new Report[0], bl);
    }

    public ReportCacheChooserParam(String string, boolean bl) {
        super("rpt_dir", string, Report.class, "Report directory", (Object[])new Report[0], (Object[])new Report[0], bl);
    }

    @Override
    public final GFieldPlusChooser getSelectionComponent() {
        super.setHints(this._getReportsInCache());
        GOptionsFieldPlusChooser gOptionsFieldPlusChooser = (GOptionsFieldPlusChooser)super.getSelectionComponent();
        gOptionsFieldPlusChooser.getJListWindow().getJList().setCellRenderer(new ReportCacheChooserParam$MyListRenderer());
        gOptionsFieldPlusChooser.setListSelectionMode(1);
        return super.getSelectionComponent();
    }

    public final File getReportDir() {
        Object object = this.getValue();
        if (object == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        File file = new File(object.toString());
        if (file.exists() && file.isDirectory()) {
            return file;
        }
        return this.getReport().getReportDir();
    }

    public final Report getReport() {
        Object object = this.getValue();
        if (object == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        if (object instanceof Report) {
            return (Report)object;
        }
        return ParserFactory.readReport(new File(object.toString()), true);
    }

    protected static final String format(Object[] objectArray) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] instanceof Report) {
                Report report = (Report)objectArray[i2];
                stringBuffer.append(report.getReportDir().getPath());
                if (i2 == objectArray.length - 1) continue;
                stringBuffer.append(',');
                continue;
            }
            klog.warn("Illegal state: " + objectArray[i2]);
        }
        return stringBuffer.toString();
    }

    @Override
    protected final ActionListener getActionListener() {
        return new ReportCacheChooserParam$MyActionListener(this);
    }

    private Report[] _getReportsInCache() {
        File[] fileArray = this.getReportFiles();
        ArrayList<Report> arrayList = new ArrayList<Report>();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            try {
                Report report;
                File file;
                File file2;
                ReportStub reportStub = new ReportStub(fileArray[i2]);
                if (reportStub.getName().indexOf("Gsea") == -1 || !(file2 = new File(file = (report = reportStub.getReport(false)).getReportDir(), "edb")).exists()) continue;
                arrayList.add(report);
                continue;
            }
            catch (Throwable throwable) {
                this.log.error(throwable);
            }
        }
        return arrayList.toArray(new Report[arrayList.size()]);
    }

    private File[] getReportFiles() {
        File file = Application.getVdbManager().getReportsCacheDir();
        if (!file.exists()) {
            this.log.warn("Report cache: " + file + " not found");
            return new File[0];
        }
        return file.listFiles(DataFormat.RPT_FORMAT.getFilenameFilter());
    }

    static final /* synthetic */ Report[] access$000(ReportCacheChooserParam reportCacheChooserParam) {
        return reportCacheChooserParam._getReportsInCache();
    }
}

