/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.ChipHelper;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import xtools.api.param.AbstractParam;
import xtools.api.param.ParamHelper;
import xtools.api.param.WChipChooserAbstractParam$MyPobActionListener;
import xtools.api.param.WChipChooserUI;

abstract class WChipChooserAbstractParam
extends AbstractParam {
    private boolean fMultipleAllowed = true;
    private WChipChooserAbstractParam$MyPobActionListener fAl;
    protected WChipChooserUI fChooser;

    WChipChooserAbstractParam(String string, String string2, String string3, boolean bl, boolean bl2) {
        super(string, string2, Chip[].class, string3, (Object)new Chip[0], (Object[])new Chip[0], bl);
        this.fMultipleAllowed = bl2;
    }

    WChipChooserAbstractParam(String string, String string2, boolean bl, boolean bl2) {
        super(string, Chip[].class, string2, (Object)new Chip[0], (Object[])new Chip[0], bl);
        this.fMultipleAllowed = bl2;
    }

    protected final Object[] _getObjects() {
        Object[] objectArray;
        Object object = this.getValue();
        if (object instanceof String) {
            String[] stringArray = WChipChooserAbstractParam._parse(object.toString());
            objectArray = VdbRuntimeResources.getChips(stringArray);
        } else {
            objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        }
        return objectArray;
    }

    protected final Chip _getChip() {
        return ChipHelper.createComboChip(this._getChips());
    }

    protected final Chip[] _getChips() {
        Object[] objectArray = this._getObjects();
        if (this.isReqd() && objectArray.length == 0) {
            throw new IllegalArgumentException("Must specify Chip parameters, got: " + objectArray.length);
        }
        Chip[] chipArray = new Chip[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            chipArray[i2] = (Chip)objectArray[i2];
        }
        return chipArray;
    }

    public void setValue(String[] stringArray) {
        try {
            System.out.println(">> number of paths: " + stringArray.length + " >" + stringArray);
            TraceUtils.showTrace();
            Object[] objectArray = new Object[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                System.out.println(">>> reading path: " + stringArray[i2]);
                File file = new File(stringArray[i2]);
                objectArray[i2] = ParserFactory.read(file, true);
            }
            super.setValue(objectArray);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static String[] _parse(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter s cannot be null");
        }
        Set set = ParseUtils.string2stringsSet(string, ",", false);
        System.out.println("to parse>" + string + "< got: " + set);
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            if (string2.length() <= 0) continue;
            hashSet.add(string2);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public void setValue(String string) {
        this.setValue(WChipChooserAbstractParam._parse(string));
    }

    private String format(Object[] objectArray) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == null) continue;
            this.log.debug(objectArray[i2].getClass());
            if (objectArray[i2] instanceof PersistentObject) {
                String string = ParserFactory.getCache().getSourcePath(objectArray[i2]);
                stringBuffer.append(string);
            } else {
                stringBuffer.append(objectArray[i2].toString().trim());
            }
            if (i2 == objectArray.length - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    protected final ActionListener getActionListener() {
        if (this.fAl == null) {
            this.fAl = new WChipChooserAbstractParam$MyPobActionListener(this.fMultipleAllowed);
            this.fAl.setChooser(this.fChooser);
        }
        return this.fAl;
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    @Override
    public String getValueStringRepresentation(boolean bl) {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return this.format(objectArray);
        }
        return this.format(new Object[]{object});
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.fChooser == null) {
            this.fChooser = new WChipChooserUI(false);
            this.fChooser.setCustomActionListener(this.getActionListener());
            String string = this.getValueStringRepresentation(false);
            if (string == null) {
                string = this.format((Object[])this.getDefault());
            }
            if (this.isFileBased()) {
                // empty if block
            }
            this.fChooser.setText(string);
            ParamHelper.addDocumentListener(this.fChooser.getTextField(), this);
        }
        return this.fChooser;
    }
}

