/*
 * Decompiled with CFR 0.152.
 */
package xtools.gsea;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.gsea.GeneSetCohortGenerator;
import edu.mit.broad.genome.alg.gsea.KSTests;
import edu.mit.broad.genome.math.LabelledVectorProcessors$None;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateMode;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.strucs.CollapsedDetails$Data;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import edu.mit.broad.genome.objects.strucs.TemplateRandomizerType;
import edu.mit.broad.genome.parsers.EdbFolderParser;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.reports.EnrichmentReports;
import edu.mit.broad.genome.reports.EnrichmentReports$Ret;
import edu.mit.broad.genome.reports.pages.HtmlReportIndexPage;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import xtools.api.param.BooleanParam;
import xtools.api.param.DatasetReqdParam;
import xtools.api.param.IntegerParam;
import xtools.api.param.MetricParam;
import xtools.api.param.OrderParam;
import xtools.api.param.ParamFactory;
import xtools.api.param.PermuteTypeChooserParam;
import xtools.api.param.SortParam;
import xtools.api.param.TemplateRandomizerTypeParam;
import xtools.api.param.TemplateSingleChooserParam;
import xtools.gsea.AbstractGseaTool;

public abstract class AbstractGsea2Tool
extends AbstractGseaTool {
    protected final DatasetReqdParam fDatasetParam = new DatasetReqdParam();
    protected final TemplateSingleChooserParam fTemplateParam = new TemplateSingleChooserParam("cls", "Phenotype labels", TemplateMode.CATEGORICAL_2_CLASS_AND_NUMERIC, true);
    protected final MetricParam fMetricParam = new MetricParam(AbstractGsea2Tool.createMetricsForGsea(), false);
    protected final OrderParam fOrderParam = new OrderParam(false);
    protected final SortParam fSortParam = new SortParam(false);
    protected final PermuteTypeChooserParam fPermuteTypeParamType = PermuteTypeChooserParam.createTemplateOrGeneSet(true);
    protected final BooleanParam fMedianParam = ParamFactory.createMedianParam(false);
    protected final IntegerParam fNumMarkersParam = ParamFactory.createNumMarkersParam(100, false);
    protected final BooleanParam fSaveRndRankedListsParam = new BooleanParam("save_rnd_lists", "Save random ranked lists", "Save random ranked lists (might be very large)", false, false);
    protected final TemplateRandomizerTypeParam fRndTypeParam = new TemplateRandomizerTypeParam(TemplateRandomizerType.NO_BALANCE, new TemplateRandomizerType[]{TemplateRandomizerType.NO_BALANCE, TemplateRandomizerType.EQUALIZE_AND_BALANCE}, true);

    protected AbstractGsea2Tool() {
    }

    @Override
    protected final void doAdditionalParams() {
        this.fParamSet.addParam(this.fDatasetParam);
        this.fParamSet.addParamPseudoReqd(this.fTemplateParam);
        this.fParamSet.addParamBasic(this.fMetricParam);
        this.fParamSet.addParamBasic(this.fOrderParam);
        this.fParamSet.addParamBasic(this.fSortParam);
        this.fParamSet.addParamPseudoReqd(this.fPermuteTypeParamType);
        this.fParamSet.addParamAdv(this.fMedianParam);
        this.fParamSet.addParamAdv(this.fNumMarkersParam);
        this.fParamSet.addParamAdv(this.fSaveRndRankedListsParam);
        this.fParamSet.addParamAdv(this.fRndTypeParam);
    }

    protected final EnrichmentDb execute_one(CollapsedDetails$Data collapsedDetails$Data, Template template, GeneSet[] geneSetArray) {
        int n = this.fNumPermParam.getIValue();
        Metric metric = this.fMetricParam.getMetric();
        SortMode sortMode = this.fSortParam.getMode();
        Order order = this.fOrderParam.getOrder();
        LabelledVectorProcessors$None labelledVectorProcessors$None = new LabelledVectorProcessors$None();
        RandomSeedGenerator randomSeedGenerator = this.fRndSeedTypeParam.createSeed();
        Map map = this.fMetricParam.getMetricParams(this.fMedianParam);
        GeneSetCohortGenerator geneSetCohortGenerator = this.fGcohGenReqdParam.createGeneSetCohortGenerator(false);
        DatasetTemplate datasetTemplate = new DatasetGenerators().extract(collapsedDetails$Data.getDataset(), template);
        this.log.debug(">>>>> Using samples: " + datasetTemplate.getDataset().getColumnNames());
        KSTests kSTests = new KSTests(this.getOutputStream());
        ArrayList arrayList = null;
        if (this.fSaveRndRankedListsParam.isTrue()) {
            arrayList = new ArrayList();
        }
        return kSTests.executeGsea(datasetTemplate, geneSetArray, n, metric, sortMode, order, labelledVectorProcessors$None, randomSeedGenerator, this.fRndTypeParam.getRandomizerType(), map, geneSetCohortGenerator, this.fPermuteTypeParamType.permuteTemplate(), this.fNumMarkersParam.getIValue(), arrayList);
    }

    protected final void execute_one_with_reporting(CollapsedDetails$Data collapsedDetails$Data, Template template, GeneSet[] geneSetArray, HtmlReportIndexPage htmlReportIndexPage, boolean bl, GeneSet[] geneSetArray2, int n, boolean bl2, boolean bl3) {
        EnrichmentDb enrichmentDb = this.execute_one(collapsedDetails$Data, template, geneSetArray);
        Metric metric = this.fMetricParam.getMetric();
        int n2 = this.fGeneSetMinSizeParam.getIValue();
        int n3 = this.fGeneSetMaxSizeParam.getIValue();
        DatasetTemplate datasetTemplate = new DatasetGenerators().extract(collapsedDetails$Data.getDataset(), template);
        ArrayList arrayList = null;
        if (this.fSaveRndRankedListsParam.isTrue()) {
            arrayList = new ArrayList();
        }
        EnrichmentReports$Ret enrichmentReports$Ret = EnrichmentReports.createGseaLikeReport(enrichmentDb, this.getOutputStream(), collapsedDetails$Data, htmlReportIndexPage, bl, this.fReport, n, n2, n3, bl3, bl2, geneSetArray2, metric.getName(), this.fNormModeParam.getNormModeName());
        if (arrayList != null && !arrayList.isEmpty()) {
            File file = this.fReport.createSubDir("random_ranked_lists");
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                RankedList rankedList = (RankedList)arrayList.get(i2);
                File file2 = new File(file, rankedList.getName());
                ParserFactory.save(rankedList, file2, false);
            }
        }
        if (this.fPermuteTypeParamType.permuteTemplate() && datasetTemplate.getTemplate().isCategorical()) {
            if (datasetTemplate.getTemplate().getClass(0).getSize() < 7) {
                this.fReport.addComment("Warning: Phenotype permutation was performed but the number of samples in class A is < 7, phenotype: " + datasetTemplate.getTemplateName());
            }
            if (datasetTemplate.getTemplate().getClass(1).getSize() < 7) {
                this.fReport.addComment("Warning: Phenotype permutation was performed but the number of samples in class B is < 7, phenotype: " + datasetTemplate.getTemplateName());
            }
            if (datasetTemplate.getTemplate().getNumItems() < 14) {
                this.fReport.addComment("With small datasets, there might not be enough random permutations of sample labels to generate a sufficient null distribution. In such cases, gene_set randomization might be a better choice.");
            }
        }
        new EdbFolderParser().export((PersistentObject)enrichmentReports$Ret.edb, enrichmentReports$Ret.savedInDir);
    }
}

