/*
 * Decompiled with CFR 0.152.
 */
package xtools.gsea;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.Metrics$ClassDiff;
import edu.mit.broad.genome.alg.Metrics$ClassLog2Ratio;
import edu.mit.broad.genome.alg.Metrics$ClassRatio;
import edu.mit.broad.genome.alg.Metrics$Cosine;
import edu.mit.broad.genome.alg.Metrics$Euclidean;
import edu.mit.broad.genome.alg.Metrics$Manhatten;
import edu.mit.broad.genome.alg.Metrics$Pearson;
import edu.mit.broad.genome.alg.Metrics$Signal2Noise;
import edu.mit.broad.genome.alg.Metrics$tTest;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.strucs.CollapsedDetails$Data;
import edu.mit.broad.genome.objects.strucs.CollapsedDetails$Ranked;
import edu.mit.broad.vdb.chip.Chip;
import java.util.HashSet;
import xtools.api.AbstractTool;
import xtools.api.ToolCategory;
import xtools.api.param.BadParamException;
import xtools.api.param.BooleanParam;
import xtools.api.param.ChipOptParam;
import xtools.api.param.FeatureSpaceReqdParam;
import xtools.api.param.GeneSetMatrixMultiChooserParam;
import xtools.api.param.GeneSetScoringTableReqdParam;
import xtools.api.param.IntegerParam;
import xtools.api.param.ModeReqdParam;
import xtools.api.param.NormModeReqdParam;
import xtools.api.param.Param;
import xtools.api.param.ParamFactory;
import xtools.api.param.RandomSeedTypeParam;

public abstract class AbstractGseaTool
extends AbstractTool {
    protected GeneSetMatrixMultiChooserParam fGeneSetMatrixParam;
    protected ChipOptParam fChipParam;
    protected final IntegerParam fGeneSetMinSizeParam = ParamFactory.createGeneSetMinSizeParam(15, false);
    protected final IntegerParam fGeneSetMaxSizeParam = ParamFactory.createGeneSetMaxSizeParam(500, false);
    protected final IntegerParam fNumPermParam = ParamFactory.createNumPermParam(true);
    protected final RandomSeedTypeParam fRndSeedTypeParam = new RandomSeedTypeParam(false);
    protected final FeatureSpaceReqdParam fFeatureSpaceParam = new FeatureSpaceReqdParam();
    protected final ModeReqdParam fCollapseModeParam = new ModeReqdParam("mode", "Collapsing mode for probe sets => 1 gene", "Collapsing mode for probe sets => 1 gene", new String[]{"Max_probe", "Median_of_probes"});
    protected final BooleanParam fIncludeOnlySymbols = new BooleanParam("include_only_symbols", "Omit features with no symbol match", "If there is no known gene symbol match for a probe set omit if from the collapsed dataset", true, false);
    protected final NormModeReqdParam fNormModeParam = new NormModeReqdParam();
    protected final GeneSetScoringTableReqdParam fGcohGenReqdParam = new GeneSetScoringTableReqdParam();

    protected AbstractGseaTool() {
    }

    @Override
    public ToolCategory getCategory() {
        return ToolCategory.GSEA;
    }

    protected final CollapsedDetails$Data getDataset(Dataset dataset) {
        CollapsedDetails$Data collapsedDetails$Data = new CollapsedDetails$Data();
        collapsedDetails$Data.orig = dataset;
        if (this.fFeatureSpaceParam.isSymbols()) {
            if (!this.fChipParam.isSpecified()) {
                throw new BadParamException("Chip parameter must be specified as you asked to analyze in the space of gene symbols. Chip is used to collapse probe ids into symbols", 1002);
            }
            Chip chip = this.fChipParam.getChipCombo();
            Dataset dataset2 = new DatasetGenerators().collapse(dataset, chip, this.fIncludeOnlySymbols.isTrue(), this.fCollapseModeParam.getStringIndexChoosen());
            this.log.info("Collapsing dataset was done. Original: " + dataset.getQuickInfo() + " collapsed: " + dataset2.getQuickInfo());
            collapsedDetails$Data.chip = chip;
            collapsedDetails$Data.wasCollapsed = true;
            collapsedDetails$Data.collapsed = dataset2;
            ParamFactory.checkIfCollapsedIsEmpty(collapsedDetails$Data);
        } else {
            collapsedDetails$Data.wasCollapsed = false;
            collapsedDetails$Data.collapsed = dataset;
            this.log.info("No dataset collapsing was done .. using original as is");
        }
        return collapsedDetails$Data;
    }

    protected final CollapsedDetails$Ranked getRankedList(RankedList rankedList) {
        CollapsedDetails$Ranked collapsedDetails$Ranked = new CollapsedDetails$Ranked();
        collapsedDetails$Ranked.orig = rankedList;
        if (this.fFeatureSpaceParam.isSymbols()) {
            if (!this.fChipParam.isSpecified()) {
                throw new BadParamException("Chip parameter must be specified as you asked to analyze in the space of gene symbols. Chip is used to collapse probe ids into symbols.", 1002);
            }
            Chip chip = this.fChipParam.getChipCombo();
            RankedList rankedList2 = new DatasetGenerators().collapse(rankedList, chip, this.fIncludeOnlySymbols.isTrue(), this.fCollapseModeParam.getStringIndexChoosen());
            this.log.info("Collapsing dataset was done. Original: " + rankedList.getQuickInfo() + " collapsed: " + rankedList2.getQuickInfo());
            collapsedDetails$Ranked.chip = chip;
            collapsedDetails$Ranked.wasCollapsed = true;
            collapsedDetails$Ranked.collapsed = rankedList2;
            ParamFactory.checkIfCollapsedIsEmpty(collapsedDetails$Ranked);
        } else {
            collapsedDetails$Ranked.wasCollapsed = false;
            collapsedDetails$Ranked.collapsed = rankedList;
            this.log.info("No ranked list collapsing was done .. using original as is");
        }
        return collapsedDetails$Ranked;
    }

    public static final Metric[] createMetricsForGsea() {
        return new Metric[]{new Metrics$Signal2Noise(), new Metrics$tTest(), new Metrics$Cosine(), new Metrics$Euclidean(), new Metrics$Manhatten(), new Metrics$Pearson(), new Metrics$ClassRatio(), new Metrics$ClassDiff(), new Metrics$ClassLog2Ratio()};
    }

    protected abstract Param[] getAdditionalParams();

    protected void doAdditionalParams() {
    }

    @Override
    public void declareParams() {
        this.fChipParam = new ChipOptParam(false);
        this.fGeneSetMatrixParam = new GeneSetMatrixMultiChooserParam(true);
        this.fParamSet.addParam(this.fGeneSetMatrixParam);
        this.fParamSet.addParam(this.fNumPermParam);
        this.fParamSet.addParamBasic(this.fGcohGenReqdParam);
        this.fParamSet.addParamBasic(this.fGeneSetMinSizeParam);
        this.fParamSet.addParamBasic(this.fGeneSetMaxSizeParam);
        this.fParamSet.addParamPseudoReqd(this.fChipParam);
        this.fParamSet.addParamPseudoReqd(this.fFeatureSpaceParam);
        this.fParamSet.addParamAdv(this.fRndSeedTypeParam);
        this.fParamSet.addParamAdv(this.fNormModeParam);
        this.fParamSet.addParamAdv(this.fIncludeOnlySymbols);
        this.fParamSet.addParamAdv(this.fCollapseModeParam);
        this.doAdditionalParams();
        Param[] paramArray = this.getAdditionalParams();
        for (int i2 = 0; i2 < paramArray.length; ++i2) {
            this.fParamSet.addParam(paramArray[i2]);
        }
    }

    protected final Dataset uniquize(Dataset dataset) {
        GeneSet geneSet = dataset.getRowNamesGeneSet();
        if (geneSet.getNumMembers() == dataset.getNumRow()) {
            return dataset;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("There were duplicate row identifiers in the specified dataset. One id was arbitarilly choosen. Details are below");
        stringBuffer.append("\nGenerally, this is OK, but if you want to avoid this automagic, edit your dataset so that all row ids are unique\n");
        stringBuffer.append('\n');
        stringBuffer.append("# of row ids in original dataset: ").append(dataset.getNumRow()).append('\n');
        stringBuffer.append("# of row UNIQUE ids in original dataset: ").append(geneSet.getNumMembers()).append('\n');
        stringBuffer.append("# The duplicates were\n");
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            String string = dataset.getRowName(i2);
            if (hashSet.contains(string)) {
                stringBuffer.append(string).append('\n');
            }
            hashSet.add(string);
        }
        this.fReport.addComment(stringBuffer.toString());
        return new DatasetGenerators().extractRows(dataset, geneSet);
    }

    protected final RankedList uniquize(RankedList rankedList) {
        FSet fSet = new FSet(rankedList.getName(), rankedList.getName(), rankedList.getRankedNames(), true);
        if (fSet.getNumMembers() == rankedList.getSize()) {
            return rankedList;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("There were duplicate row identifiers in the specified ranked list. One id was arbitarilly choosen. Details are below. ");
        stringBuffer.append("\nGenerally, this is OK, but if you want to avoid this automagic, edit your ranked list so that all row ids are unique\n");
        stringBuffer.append('\n');
        stringBuffer.append("# of row ids in original dataset: ").append(rankedList.getSize()).append('\n');
        stringBuffer.append("# of row UNIQUE ids in original dataset: ").append(fSet.getNumMembers()).append('\n');
        stringBuffer.append("# The duplicates were\n<br><pre>");
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < rankedList.getSize(); ++i2) {
            String string = rankedList.getRankName(i2);
            if (hashSet.contains(string)) {
                stringBuffer.append(string).append('\n');
            }
            hashSet.add(string);
        }
        stringBuffer.append("</pre>");
        this.fReport.addComment(stringBuffer.toString());
        return rankedList.extractRanked(fSet);
    }
}

