/*
 * Decompiled with CFR 0.152.
 */
package xtools.gsea;

import edu.mit.broad.genome.StandardException;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.strucs.CollapsedDetails$Data;
import edu.mit.broad.genome.reports.api.ReportIndexState;
import edu.mit.broad.genome.reports.pages.HtmlReportIndexPage;
import java.util.Properties;
import xtools.api.AbstractTool$Helper;
import xtools.api.param.BooleanParam;
import xtools.api.param.DatasetReqdParam;
import xtools.api.param.IntegerParam;
import xtools.api.param.Param;
import xtools.api.param.ParamFactory;
import xtools.gsea.AbstractGsea2Tool;

public class Gsea
extends AbstractGsea2Tool {
    private final IntegerParam fShowDetailsForTopXSetsParam = new IntegerParam("plot_top_x", "Plot graphs for the top sets of each phenotype", "Plot GSEA mountain and related plots for the top sets of each phenotype", 20, false, Param.ADVANCED);
    private final BooleanParam fMakeZippedReportParam = ParamFactory.createZipReportParam(false);
    private final BooleanParam fMakeGeneSetReportsParam = new BooleanParam("make_sets", "Make detailed gene set report", "Create detailed gene set reports (heat-map, mountain plot etc) for every enriched gene set", true, false, Param.ADVANCED);

    public Gsea(Properties properties) {
        super.init(properties);
    }

    public Gsea(String[] stringArray) {
        super.init(stringArray);
    }

    public Gsea() {
        this.declareParams();
    }

    @Override
    public final void execute() {
        ReportIndexState reportIndexState = new ReportIndexState(true, false, false, Gsea.createHeader(this.fDatasetParam));
        this.startExec(reportIndexState);
        Template template = this.fTemplateParam.getTemplate();
        Metric metric = this.fMetricParam.getMetric();
        if (template.isCategorical()) {
            if (!metric.isCategorical()) {
                throw new StandardException("As the phenotype choosen was categorical, only categorical metrics are allowed. Got: " + metric.getName(), 1010);
            }
            if (!template.isCategorical()) {
                throw new IllegalArgumentException("Only categorical templates allowed. Got: " + template.getName());
            }
        }
        if (!template.isCategorical()) {
            if (!metric.isContinuous()) {
                throw new StandardException("As the phenotype choosen was continuous, only continuous class metrics are allowed. Got: " + metric.getName(), 1011);
            }
            if (!template.isContinuous()) {
                throw new IllegalArgumentException("Only continuous templates allowed. Got: " + template.getName());
            }
        }
        Dataset dataset = this.fDatasetParam.getDataset(this.fChipParam, null);
        Dataset dataset2 = this.uniquize(dataset);
        CollapsedDetails$Data collapsedDetails$Data = super.getDataset(dataset2);
        GeneSet[] geneSetArray = this.fGeneSetMatrixParam.getGeneSetMatrixCombo(true).getGeneSets();
        GeneSet[] geneSetArray2 = AbstractTool$Helper.getGeneSets((Object)collapsedDetails$Data.getDataset(), geneSetArray, this.fGeneSetMinSizeParam, this.fGeneSetMaxSizeParam);
        ParamFactory.checkAndBarfIfZeroSets(geneSetArray2);
        HtmlReportIndexPage htmlReportIndexPage = this.fReport.getIndexPage();
        boolean bl = false;
        this.execute_one_with_reporting(collapsedDetails$Data, template, geneSetArray2, htmlReportIndexPage, false, geneSetArray, this.fShowDetailsForTopXSetsParam.getIValue(), this.fMakeZippedReportParam.isTrue(), this.fMakeGeneSetReportsParam.isTrue());
        if (this.fMakeZippedReportParam.isTrue()) {
            this.fReport.closeReport(true);
            this.fReport.zipReport();
        }
        this.doneExec();
    }

    @Override
    protected final Param[] getAdditionalParams() {
        return new Param[]{this.fShowDetailsForTopXSetsParam, this.fMakeZippedReportParam, this.fMakeGeneSetReportsParam};
    }

    @Override
    public final String getDesc() {
        return "Set parameters and run enrichment tests";
    }

    public static final void main(String[] stringArray) {
        Gsea gsea = new Gsea(stringArray);
        Gsea.tool_main(gsea);
    }

    public static final String createHeader(DatasetReqdParam datasetReqdParam) {
        try {
            if (datasetReqdParam.isSpecified()) {
                Dataset dataset = datasetReqdParam.getDataset();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<div id=\"footer\" style=\"width: 905; height: 35\">\n").append("<h3 style=\"text-align: left\"><font color=\"#808080\">GSEA Report for ").append("Dataset ").append(dataset.getName()).append("</font></h3>\n").append("</div>");
                return stringBuffer.toString();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }
}

