/*
 * Decompiled with CFR 0.152.
 */
package xtools.gsea;

import edu.mit.broad.genome.Printf;
import edu.mit.broad.genome.alg.cluster.ClusteringAlgs;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.objects.BitSetDataset;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GPWrappers;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.reports.api.ReportIndexState;
import edu.mit.broad.genome.reports.pages.HtmlFormat$Links;
import edu.mit.broad.genome.reports.pages.HtmlReportIndexPage;
import edu.mit.broad.genome.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;
import org.apache.ecs.StringElement;
import org.apache.ecs.html.A;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.H2;
import org.apache.ecs.html.H4;
import org.apache.ecs.html.LI;
import org.apache.ecs.html.TD;
import org.apache.ecs.html.TH;
import org.apache.ecs.html.TR;
import org.apache.ecs.html.Table;
import org.apache.ecs.html.UL;
import xapps.api.vtools.viewers.VizFactory;
import xtools.api.AbstractTool;
import xtools.api.ToolCategory;
import xtools.api.param.DirParam;
import xtools.api.param.StringMultiInputParam;

public class LeadingEdgeTool
extends AbstractTool {
    public DirParam fGseaResultDirParam = new DirParam(true);
    public StringMultiInputParam fGeneSetNamesParam = new StringMultiInputParam("gsets", "gene sets", true);

    public LeadingEdgeTool(Properties properties) {
        super.init(properties);
    }

    public LeadingEdgeTool(String[] stringArray) {
        super.init(stringArray);
    }

    public LeadingEdgeTool() {
        this.declareParams();
    }

    private Dataset _morph(Dataset dataset, RankedList rankedList) {
        Matrix matrix = new Matrix(dataset.getNumRow(), dataset.getNumCol());
        for (int i2 = 0; i2 < dataset.getNumRow(); ++i2) {
            for (int i3 = 0; i3 < dataset.getNumCol(); ++i3) {
                float f2 = rankedList.getScore(dataset.getColumnName(i3));
                float f3 = dataset.getElement(i2, i3);
                if (f3 == 1.0f) {
                    matrix.setElement(i2, i3, f2);
                    continue;
                }
                matrix.setElement(i2, i3, f3);
            }
        }
        return new DefaultDataset(dataset.getName(), matrix, dataset.getRowNames(), dataset.getColumnNames(), true, dataset.getAnnot());
    }

    @Override
    public final void execute() {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        ConcreteElement concreteElement;
        ReportIndexState reportIndexState = new ReportIndexState(true, false, false, LeadingEdgeTool.getHeader(this.fGseaResultDirParam));
        this.startExec(reportIndexState);
        File file = this.fGseaResultDirParam.getFile();
        EnrichmentDb enrichmentDb = ParserFactory.readEdb(file, true);
        String[] stringArray = this.fGeneSetNamesParam.getStrings();
        EnrichmentResult[] enrichmentResultArray = new EnrichmentResult[stringArray.length];
        GeneSet[] geneSetArray = new GeneSet[enrichmentResultArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.log.debug("gset: " + stringArray[i2]);
            enrichmentResultArray[i2] = enrichmentDb.getResultForGeneSet(stringArray[i2]);
            geneSetArray[i2] = enrichmentResultArray[i2].getSignal().getAsGeneSet();
        }
        DefaultGeneSetMatrix defaultGeneSetMatrix = new DefaultGeneSetMatrix("leading_edge_matrix_for_" + enrichmentDb.getName(), geneSetArray);
        BitSetDataset bitSetDataset = new BitSetDataset(defaultGeneSetMatrix);
        Dataset dataset = bitSetDataset.toDataset(true, false);
        File file2 = this.fReport.savePage((PersistentObject)dataset, false);
        Dataset dataset2 = null;
        try {
            this.log.info("Clustering signal matrix: " + dataset.getQuickInfo() + " " + file2.getPath());
            dataset2 = ClusteringAlgs.cluster(dataset).getDatasetOrdered();
        }
        catch (Throwable throwable) {
            this.fReport.addError("Trouble clustering", throwable);
        }
        HtmlReportIndexPage htmlReportIndexPage = this.fReport.getIndexPage();
        Div div = new Div();
        H2 h2 = new H2("Leading edge results for enrichment database: <b>" + enrichmentDb.getName() + "</b>");
        div.addElement(h2);
        div = new Div();
        div.addElement(new H4("Leading edge analysis: Clustered results"));
        UL uL = new UL();
        uL.addElement(new LI("There were " + enrichmentResultArray.length + " gene sets used in the leading edge analysis (see below for details)"));
        Dataset dataset3 = this._morph(dataset2, enrichmentDb.getRankedList());
        BufferedImage bufferedImage = VizFactory.createGramImager(GPWrappers.createColorScheme_for_lev_with_score(dataset3)).createBpogImage(dataset3);
        File file3 = this.fReport.createFile("leading_edge_heat_map_clustered.png", "foo");
        ImageUtils.savePng(bufferedImage, file3);
        StringElement stringElement = HtmlFormat$Links.hyper("Heat map of clustered leading edge subsets", file3, ". Rows are gene sets and columns are genes. This matrix is clustered", this.fReport.getReportDir());
        uL.addElement(new LI(stringElement));
        div.addElement(uL);
        htmlReportIndexPage.addBlock(div, true);
        Table table = new Table();
        TH tH = new TH();
        tH.addElement(new TD("# members"));
        tH.addElement(new TD("# members<br>in signal"));
        tH.addElement(new TD("Tag %"));
        tH.addElement(new TD("List %"));
        tH.addElement(new TD("Signal strength"));
        table.addElement(tH);
        for (int i3 = 0; i3 < enrichmentResultArray.length; ++i3) {
            concreteElement = new TR();
            object3 = enrichmentResultArray[i3].getGeneSetName();
            serializable = new File(file, (String)object3 + ".html");
            object2 = new A(serializable.toURI().toString(), (String)object3);
            ((TR)concreteElement).addElement(new TD((Element)object2));
            ((TR)concreteElement).addElement(new TD("" + enrichmentResultArray[i3].getGeneSet().getNumMembers()));
            object = enrichmentResultArray[i3].getSignal();
            ((TR)concreteElement).addElement(new TD("" + object.getSize()));
            ((TR)concreteElement).addElement(new TD(Printf.format(object.getTagFraction() * 100.0f, 0) + "%"));
            ((TR)concreteElement).addElement(new TD(Printf.format(object.getListFraction() * 100.0f, 0) + "%"));
            ((TR)concreteElement).addElement(new TD(Printf.format(object.getSignalStrength() * 100.0f, 0) + "%"));
            table.addElement(concreteElement);
        }
        div = new Div();
        div.addElement(new H4("Details of gene sets and signals used in this analysis"));
        div.addElement(table);
        htmlReportIndexPage.addBlock(div, true);
        div = new Div();
        div.addElement(new H4("Leading edge analysis: other files made"));
        uL = new UL();
        File file4 = this.fReport.savePage((PersistentObject)dataset2, false);
        concreteElement = HtmlFormat$Links.hyper("Clustered dataset (gct)", file4, "for the specified gene sets. 1's denote membership of a gene in the leading edge subset", this.fReport.getReportDir());
        uL.addElement(new LI(concreteElement));
        object3 = this.fReport.savePageGmx(defaultGeneSetMatrix);
        serializable = HtmlFormat$Links.hyper("GeneSetMatrix (gmx)", (File)object3, "of leading edge subsets", this.fReport.getReportDir());
        uL.addElement(new LI((Element)((Object)serializable)));
        concreteElement = HtmlFormat$Links.hyper("Dataset (gct)", file2, "for the specified gene sets. 1's denote membership of a gene in the leading edge subset", this.fReport.getReportDir());
        uL.addElement(new LI(concreteElement));
        object2 = VizFactory.createGramImager(GPWrappers.createColorScheme_for_lev_with_score(dataset)).createBpogImage(this._morph(dataset, enrichmentDb.getRankedList()));
        object = this.fReport.createFile("leading_edge_heat_map_unclustered.png", "foo");
        ImageUtils.savePng((BufferedImage)object2, (File)object);
        stringElement = HtmlFormat$Links.hyper("Heat map of leading edge subsets", (File)object, ". Rows are gene sets and columns are genes. This matrix is NOT clustered", this.fReport.getReportDir());
        uL.addElement(new LI(stringElement));
        div.addElement(uL);
        htmlReportIndexPage.addBlock(div, true);
        div = new Div();
        uL = new UL();
        div.addElement(new H4("Other"));
        uL.addElement(new LI(HtmlFormat$Links.hyper("Parameters", this.fReport.getParamsFile(), "used for this analysis", this.fReport.getReportDir())));
        div.addElement(uL);
        htmlReportIndexPage.addBlock(div, false);
        htmlReportIndexPage.setAddBrowseFooter(false);
        this.doneExec();
    }

    @Override
    public final ToolCategory getCategory() {
        return ToolCategory.GSEA;
    }

    @Override
    public final void declareParams() {
        this.fParamSet.addParam(this.fGseaResultDirParam);
        this.fParamSet.addParam(this.fGeneSetNamesParam);
    }

    public static final void main(String[] stringArray) {
        LeadingEdgeTool leadingEdgeTool = new LeadingEdgeTool(stringArray);
        LeadingEdgeTool.tool_main(leadingEdgeTool);
    }

    private static final String getHeader(DirParam dirParam) {
        try {
            if (dirParam.isSpecified()) {
                String string = dirParam.getDir().getName();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<div id=\"footer\" style=\"width: 905; height: 35\">\n").append("<h3 style=\"text-align: left\"><font color=\"#808080\">Leading edge report for ").append("GSEA result folder: ").append(string).append("</font></h3>\n").append("</div>");
                return stringBuffer.toString();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }
}

