/*
 * Decompiled with CFR 0.152.
 */
package xtools.munge;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.GeneSetGenerators;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.PersistentObject;
import java.io.File;
import java.util.Properties;
import xtools.api.AbstractTool;
import xtools.api.ReportBlocks$SimpleBlockListing;
import xtools.api.ToolCategory;
import xtools.api.param.BooleanParam;
import xtools.api.param.DataFormatChooser;
import xtools.api.param.DatasetFormatParam;
import xtools.api.param.DatasetReqdParam;
import xtools.api.param.GeneSetMatrixMultiChooserParam;
import xtools.api.param.ModeReqdParam;
import xtools.api.param.StringMultiInputParam;

public class XtractDataset
extends AbstractTool {
    private final DatasetReqdParam fDatasetParam = new DatasetReqdParam();
    private final BooleanParam fIsColumnNames = new BooleanParam("column", "Extract columns instead of rows", "Specified names are column names (and not the default of row names)", false, false);
    private final StringMultiInputParam fNamesParam = new StringMultiInputParam("names", "Extract these features", "Row or column names from dataset, whitespace or comma delimited", new String[0], false);
    private final GeneSetMatrixMultiChooserParam fGeneSetsParam = new GeneSetMatrixMultiChooserParam(false, true, false);
    private final DatasetFormatParam fDatasetOutputFormatParam = new DatasetFormatParam(false);
    private final ModeReqdParam fIncludeModeParam = new ModeReqdParam("mode", "Include or Exclude specified features", "Include or Exclude specified features", new String[]{"include", "exclude"});

    public XtractDataset(Properties properties) {
        super.init(properties);
    }

    public XtractDataset(String[] stringArray) {
        super.init(stringArray);
    }

    public XtractDataset() {
        this.declareParams();
    }

    @Override
    public final void execute() {
        int n;
        Object object;
        GeneSet[] geneSetArray;
        this.startExec(false);
        Dataset dataset = this.fDatasetParam.getDataset();
        if (this.fNamesParam.isSpecified()) {
            geneSetArray = new GeneSet[]{this.fNamesParam.getAsGeneSet()};
        } else if (this.fGeneSetsParam.isSpecified()) {
            geneSetArray = this.fGeneSetsParam.getGeneSets(true);
        } else {
            throw new IllegalArgumentException("At least one of " + this.fNamesParam.getName() + " or " + this.fGeneSetsParam.getName() + " must be specified");
        }
        if (this.fIncludeModeParam.getStringIndexChoosen() == 1) {
            this.log.info("EXcluding specified names if applicable");
            object = this.fIsColumnNames.isTrue() ? dataset.getColumnNamesGeneSet() : dataset.getRowNamesGeneSet();
            for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
                n = object.getNumMembers();
                geneSetArray[i2] = GeneSetGenerators.subtractGeneSet((GeneSet)object, geneSetArray[i2]);
                this.log.info("Before: " + n + " after subtracting: " + geneSetArray[i2].getNumMembers());
            }
        } else {
            this.log.info("INcluding specified names if applicable");
        }
        object = new DatasetGenerators().extractDatasets(dataset, geneSetArray, this.fIsColumnNames.isTrue());
        ReportBlocks$SimpleBlockListing reportBlocks$SimpleBlockListing = new ReportBlocks$SimpleBlockListing("The following datasets were extracted", this.fReport);
        for (n = 0; n < ((Dataset[])object).length; ++n) {
            Comparable<StringBuffer> comparable;
            if (object[n] == null || object[n].getNumRow() == 0) {
                comparable = new StringBuffer("Error: there were no matches to : " + dataset.getName());
                ((StringBuffer)comparable).append(" from gene set ").append(geneSetArray[n].getName());
                ((StringBuffer)comparable).append("\n<br>Check to make sure the features spaces are the same for the gene set and dataset");
                reportBlocks$SimpleBlockListing.add(((StringBuffer)comparable).toString());
                continue;
            }
            comparable = this.fReport.savePage((PersistentObject)object[n], (DataFormatChooser)this.fDatasetOutputFormatParam);
            reportBlocks$SimpleBlockListing.add("Extracted data to file", object[n].getName(), (File)comparable);
        }
        reportBlocks$SimpleBlockListing.close();
        this.doneExec();
    }

    @Override
    public final ToolCategory getCategory() {
        return ToolCategory.DATASET;
    }

    @Override
    public final String getDesc() {
        return "Extract expression values for a gene set from a dataset";
    }

    @Override
    public final void declareParams() {
        this.fParamSet.addParam(this.fDatasetParam);
        this.fParamSet.addParamPseudoReqd(this.fGeneSetsParam);
        this.fParamSet.addParamBasic(this.fNamesParam);
        this.fParamSet.addParamBasic(this.fDatasetOutputFormatParam);
        this.fParamSet.addParamBasic(this.fIsColumnNames);
        this.fParamSet.addParamBasic(this.fIncludeModeParam);
    }

    public static final void main(String[] stringArray) {
        XtractDataset xtractDataset = new XtractDataset(stringArray);
        XtractDataset.tool_main(xtractDataset);
    }
}

