library(affy)

# extension e.g. '.gct'
check.extension <- function(file.name, extension) {
	ext <- regexpr(paste(extension,"$",sep=""), tolower(file.name))
	if(ext[[1]] == -1) {
		file.name <- paste(file.name, extension, sep="") 
	}
	return(file.name)
}

write.res <-
#
# write a res structure as a file
#
function(res, filename, check.file.extension=TRUE)
{
	if(check.file.extension) {
		filename <- check.extension(filename, ".res")
	}
	f <- file(filename, "w")
	on.exit(close(f))
	# write the labels
	cat("Description\tAccession\t", file=f, append=TRUE)
	cat(colnames(res$data), sep="\t\t", file=f, append=TRUE)
	cat("\n", file=f, append=TRUE)
	
	# write the descriptions
	if(!is.null(res$column.descriptions)) {
		cat("\t", file=f, append=TRUE)
		cat(res$column.descriptions, sep="\t\t", file=f, append=TRUE)
	} 
	cat("\n", file=f, append=TRUE)
	
	# write the size
	cat(NROW(res$data), "\n", sep="", file=f, append=TRUE)
	
	# write the data
	# 1st combine matrices
	dim <- dim(res$data)
	dim[2] <- dim[2]*2
	
	m <- matrix(nrow=dim[1], ncol=dim[2]+2)
	
	if(!is.null(res$row.descriptions)) {
		m[,1] <- res$row.descriptions
	} else {
		m[, 1] <- ''
	}
	
	m[,2] <- row.names(res$data)
	
	index <- 3
	for(i in 1:dim(res$data)[2]) {
		m[,index] <- res$data[,i]
		index <- index + 2
	}
	index <- 4
	
	for(i in 1:dim(res$calls)[2]) {
		m[,index] <- as.character(res$calls[,i])
		index <- index + 2
	}
	write.table(m, file=f, col.names=FALSE, row.names=FALSE, append=TRUE, quote=FALSE, sep="\t", eol="\n")
	return(filename)
}

## THE SCRIPT

r <- ReadAffy(filenames=cel.file.names) 
eset <- mas5(r, normalize=FALSE)
data <- exprs(eset)

#remove .CEL extension from sample names
col.names <- colnames(data)
col.names <- sub(".[cC][eE][lL].gz$|.[cC][eE][lL]$", "", col.names)
colnames(data) <- col.names
			
calls.eset <- mas5calls.AffyBatch(r, verbose = FALSE) 
calls <- exprs(calls.eset)
	
write.res(list(data=data, row.descriptions=NULL, calls=calls), "output.res", T)
